// TULIP - define tulipDraw, tulipGrowBy, 
// and the "constructor" function makeTulip
//
function tulipDraw() {
    noStroke();
    fill(16, 122, 12);
    rect(this.x, this.y - this.height, 10, this.height);

    // petals
    fill(255, 0, 0); // red
    var y = this.y - this.height;
    ellipse(this.x + 5, y, 44, 44);
    triangle(this.x - 16, y, this.x + 20, y, this.x - 20, y - 31);
    triangle(this.x - 14, y, this.x + 24, y, this.x + 3, y - 39);
    triangle(this.x + -4, y, this.x + 26, y, this.x + 29, y - 36);
};


function tulipGrow(amount) {
    this.height += amount;
};


function makeTulip(tx, ty, th) {
    var tulip = {x: tx, y: ty, height: th,
                 show: tulipDraw, grow: tulipGrow};
    return tulip; // return the new object
};


// SUNFLOWER - define sunflowerDraw, sunflowGrowBy, 
// and the "constructor" function makeSunflower
//
function sunflowerDraw() {
    noStroke();
    fill(16, 122, 12);
    rect(this.x, this.y - this.height, 10, this.height);
    
    // petals
    stroke(0, 0, 0);
    fill(255, 221, 0); // yellow
    var y = this.y - this.height
    ellipse(this.x - 10, y, 20, 18);
    ellipse(this.x + 5, y - 15, 20, 18);
    ellipse(this.x + 5, y + 15, 20, 18);
    ellipse(this.x + 20, y, 20, 18);
    fill(20, 20, 20); // dark center
    ellipse(this.x + 5, y, 20, 20);
};


function sunflowerGrow(amount) {
    this.height += amount;
};


function makeSunflower(sx, sy, sh) {
    var sunflower = {x: sx, y: sy, height: sh,
                 show: sunflowerDraw, grow: sunflowerGrow};
    return sunflower; // return the new object
};


// MAIN PROGRAM STARTS HERE

var tulip;
var sunflower;
var flowers = []; // an empty array

function setup() {
    createCanvas(400, 400);
    tulip = makeTulip(38, 390, 150);
    sunflower = makeSunflower(186, 390, 100);
    flowers.push(tulip);
    flowers.push(sunflower);
    frameRate(5);
}

function draw() {
    background(207, 250, 255);
    for (var i = 0; i < flowers.length; i++) {
        flowers[i].show();
    }
    noStroke();
    fill(0);
    text("Press key for acts of random flowers.", 10, 20);
    text("Press mouse to grow", 10, 35);
};

function mousePressed() {
    for (var i = 0; i < flowers.length; i++) {
        flowers[i].grow(5);
    }
}

function keyPressed() {
    // pick a random flower maker (constructor)
    var allFlowers = [makeTulip, makeSunflower];
    var flowerMaker = random(allFlowers);
    flowers.push(flowerMaker(random(width), 
                 height - random(100), 90 + random(50)));
}