var bx = [];   // array of boxes

function setup() { // set random position, velocity, and color for 100 rects
    createCanvas(200, 200);
    for (i = 0; i < 100; i++) { // for loop initializing 100 values in each array
        bx[i] = new Object();
        bx[i].x = random(width);
        bx[i].y = random(height);
        bx[i].dx = random(-5, 5);
        bx[i].dy = random(-5, 5);
        bx[i].c = color(random(255), random(255), random(255));
    }
    frameRate(5);
}

// update position and draw each of 100 rectangles
function draw() {
    background(200, 200, 200);
    noStroke();
    for (i = 0; i < 100; i++) {  // for each rectangle ...
        draw_box(bx[i]);
        update_box(bx[i]);
    }
}

function draw_box(b) {
    // Note here: we don't which box it is, there is no subscript
    fill(b.c);
    rect(b.x, b.y, 10, 10);
}

function update_box(b) {
        b.x += b.dx;
        b.y += b.dy;
        // "wrap" logic: if you go off an edge, jump to the opposite edge
        if (b.x > width) b.x = 0;        // wrap horizontally
        else if (b.x < 0) b.x = width;
        if (b.y > height) b.y = 0;       // wrap vertically
        else if (b.y < 0) b.y = height;
}
