var x = []; // every variable now starts out as an empty array
var y = [];
var dx = []; // velocity in x direction (d for "delta" meaning change or difference)
var dy = []; // velocity in y direction
var c = []; // color of each rect wil be random

function setup() { // set random position, velocity, and color for 100 rects
    createCanvas(200, 200);
    for (i = 0; i < 100; i++) { // for loop initializing 100 values in each array
        x[i] = random(width);
        y[i] = random(height);
        dx[i] = random(-5, 5);
        dy[i] = random(-5, 5);
        c[i] = color(random(255), random(255), random(255));
    }
    frameRate(5);
}

// update position and draw each of 100 rectangles
function draw() {
    background(200, 200, 200);
    noStroke();
    for (i = 0; i < 100; i++) {  // for each rectangle ...
        fill(c[i]);
        rect(x[i], y[i], 10, 10);
        x[i] += dx[i];
        y[i] += dy[i];
        // "wrap" logic: if you go off an edge, jump to the opposite edge
        if (x[i] > width) x[i] = 0;        // wrap horizontally
        else if (x[i] < 0) x[i] = width;
        if (y[i] > height) y[i] = 0;       // wrap vertically
        else if (y[i] < 0) y[i] = height;
    }
}