var ex = [];
var ey = []; 

function setup() {
    createCanvas(300, 300);
    frameRate(5);
}

function draw() {
    background(255, 200, 200);
    fill(0);
    noStroke();
    var nPoints = ex.length;

    if (nPoints < 1) {
        text("Click to begin", 5, 15);
    }
    // Draw the dots
    for (var i=0; i < ex.length; i++) {
        ellipse(ex[i], ey[i], 5, 5);
    }

    // Compute their centroid point using computeAvg function below
    // (xAverage, yAverage)
    exAverage = computeAvg(ex, nPoints);
    eyAverage = computeAvg(ey, nPoints);

    // Draw lines from the centroid to every point
    strokeWeight(1); 
    stroke(0, 0, 0, 50); 
    for (var i = 0; i < nPoints; i++) { 
        line (ex[i], ey[i], exAverage, eyAverage); 
    }

    // Draw the centroid
    fill(255);
    stroke(0);
    strokeWeight(2); 
    ellipse(exAverage, eyAverage, 10, 10); 
}

function mousePressed() { 
    ex.push(mouseX); 
    ey.push(mouseY); 
}

// Compute the average of a general array arr
function computeAvg(arr, len) {
    var sum = 0;
    for (var i = 0; i < len; i++) {
        sum += arr[i];
    }
    return sum / len;
}

