var x = [50, 61, 83, 69, 71, 50, 29, 31, 17, 39];
var y = [18, 37, 43, 60, 82, 73, 82, 60, 43, 37];

function setup() {
    createCanvas(200, 200);
    frameRate(5);
}

function draw() {
    background(255, 200, 200);
    var nPoints = x.length;
    
    // Progressively modify the arrays with a small amount of randomness.
    // Each time draw() is called, the more randomness is added. 
    var amount = 1.2;
    for (var i = 0; i < nPoints; i++) {
        x[i] += random(-amount, amount);
        y[i] += random(-amount, amount);
    }
    
    // Now render the star from those arrays
    fill(255);
    stroke(0);
    beginShape();
    for (var i = 0; i < nPoints; i++) {
        vertex(x[i], y[i]);
    }
    endShape(CLOSE);
}