var size;   // size of each square
var BLANK = "white";  // the "empty" state value
var state = [BLANK, BLANK, BLANK, BLANK, BLANK, BLANK, BLANK, BLANK, BLANK];
var turn = "red"; // whose turn is it? (red or green)
var gameOver = false; 

// state layout is like this:
// 0 1 2
// 3 4 5
// 6 7 8

function setup() {
    createCanvas(300, 300);
    size = width / 3;
}

// test if mouse is inside the square at x, y and size w
//
function mouseInsideSquare(x, y, w) {
    return mouseX > x && mouseX < x + w && mouseY > y && mouseY < y + w;
}


// mouseToIndex finds the index of the square containing the mouse (if any)
// returns the index. If mouse is not in any square, returns -1.
//
function mouseToIndex() {
    var x = 0;
    var y = 0;
    for (var index = 0; index < 9; index++) {
        if (mouseInsideSquare(x, y, size)) {
            return index;
        }
        x += size;
        if (x >= width) { 
            x = 0; 
            y += size; 
        }
    }
    return -1;
}

// checkWin() checks for every possible win and returns the
// color of the winner if any, otherwise returns BLANK
//
function checkWin() {

    // check for 3 in a row horizontally
    for (var i = 0; i < 9; i += 3) {
        if (state[i] == state[i + 1] && state[i] == state[i + 2] 
            && state[i] != BLANK) { // winner cannot be "BLANK"!
                return state[i]; // a winner
        }
    }

    // check for 3 in a row vertically
    for (var j = 0; j < 3; j += 1) {
        if (state[j] == state[j + 3] && state[j] == state[j + 6]
            && state[j] != BLANK) { // winner cannot be "BLANK"!
                return state[j]; // a winner
        }
    }

    // check for diagonal wins
    if (state[0] == state[4] && state[0] == state[8] 
        && state[0] != BLANK) { // winner cannot be "BLANK"!
            return state[0]; // from top left to bottom right
    }
    if (state[6] == state[4] && state[6] == state[2]
        && state[6] != BLANK) { // winner cannot be "BLANK"!
            return state[6]; // from bottom left to top right
    }

    return "none"; // no winning 3-in-a-row
}


function draw() {
    background(220);
    // draw the 3x3 game board
    var index = 0; // index into state to get color
    for (var row = 0; row < 3; row++) {
        for (var column = 0; column < 3; column++) {
            fill(state[index]);
            rect(column*size, row*size, size, size);
            index = index + 1;
        }
    }
    // if there is a winner, print a message and stop
    var winner = checkWin();
    if (winner != "none") {
        print("Game Over!");
        gameOver = true;
        noLoop(); // we are done
    }
}


// mousePressed uses turn to set the state when a move is made
function mousePressed() {
    var index = mouseToIndex();
 //   print("Mouse pressed! " + index.toString());

    // only process a click if click is inside a square and the game is not over
    // does the order matter here?
    if (!gameOver && index != -1 && state[index] == BLANK) {
 //       print(index.toString());
        state[index] = turn;
 //       print(state.toString());
        if (turn == "red") {
            turn = "green";
        } else {
            turn = "red";
        }
    }
}
