var isRed = [] // isRed is true if the button should
  // be red, and false if the button should be green.
  // We use this to determine fill color when we draw
  // the buttons.

function setup() {
    createCanvas(201, 41);
    for (var i = 0; i < 10; i++) { // there are 10 buttons
        isRed[i] = false;  // all buttons start out green
    }
    frameRate(5);
}

function draw() {
    background(255);
    // draw the buttons
    for (var i = 0; i < 10; i++) { // for each button...
        if (isRed[i]) { // is the i'th button red?
            fill(205, 0, 0); // red
        } else {
            fill(0, 205, 0); // green
        }
        // draw the i'th button at position i * 20
        rect(i * 20, 0, 20, 40)
    }
}

// when the mouse is pressed, toggle the isRed state
//   of the button. We have to determine which of the
//   buttons to toggle. We divide the mouse position by
//   the width of the buttons (20) to compute the button
//   number. E.g. if mouseX === 30, we're in the middle 
//   of button #1 (remember the leftmost button is #0), 
//   and mouseX/20 === 1.5, meaning the middle (0.5) of 
//   button #1. The int() function rounds down to the 
//   nearest integer, converting 1.5 into 1, which is the
//   index we are after.
//   
function mousePressed() {
    var index = int(mouseX / 20);
    isRed[index] = ! isRed[index]; // ! means "not"
    // (! true) is false, and (! false) is true
}