var theta = 0;  // angle of rotation (starting)
var r = 200;    // radius

function setup() {
    createCanvas(500, 500);
    frameRate(5);
}

function draw() {
    background(150, 200, 150);
    fill(255);
    strokeWeight(2);
    push();
    translate(250, 250);
    stroke(0);
    circle(0, 0, 2*r);
    var x = r * cos(radians(theta));
    var y = r * sin(radians(theta));
    stroke(255, 0, 0);
    line(0, 0, x, y);
    pop();
    theta += 1;

    // compute unit circle x and y values rounded to 3 places
    var unit_x = round(map(x, -r, r, -1.0, 1.0)*1000)/1000;
    var unit_y = round(map(y, -r, r, -1.0, 1.0)*1000)/1000;
    print("unit_x = " + unit_x.toString() 
          + " unit_y = " + unit_y.toString());


}
