// FORM+CODE
// Casey Reas and Chandler McWilliams

var option = 0;
var density;
function setup() {
    createCanvas(640, 480);
    noFill();
    frameRate(5); // reduce computation 
}

function draw() {
    background(255);
    density = map(mouseX, 0, width, 20, 50);
    drawOption(option);
}

function drawOption(option) {
    if (option == 0) { stitches(); } 
    else if (option == 1) { line_perspective(); } 
    else if (option == 2) { rotating_arcs(); } 
    else if (option == 3) { overlapping_circles(); }
    else if (option == 4) { groups_of_five(); } 
}

function stitches() {
    for (var x = 50; x <= width-50; x += density) {
        for (var y = 50; y <= height-50; y+=density) {
            line(x-5, y-5, x+5, y+5);
            line(x+5, y-5, x-5, y+5);
        }
    }
} 

function line_perspective() {
    for (var x = 50; x <= width-50; x += density) {
        for (var y = 50; y <= height-50; y+=density) {
            line(x, y, width/2, height/2);
        }
    }
} 
 
function rotating_arcs() {
    var count = 120;
    for (var x = 50; x <= width-50; x += density) {
        for (var y = 50; y <= height-50; y+=density) {
            var s = map(count, 120, 0, 0, TWO_PI*2);
            arc(x, y, 14, 14, s, s + PI);
            count--;
        }
    }
} 

function overlapping_circles() {
    for (var x = 50; x <= width-50; x += density) {
        for (var y = 50; y <= height-50; y+=density) {
            ellipse(x, y, 40, 40);
        }
    }
} 

function groups_of_five() {
    for (var x = 50; x < width-50; x += density) {
        for (var y = 50; y < height-50; y+=density) {
            //rect(x-10, y-10, 22, 22);
            for (var i = 0; i < 16; i+=4) {
                line(x + i, y, x + i, y + 12);
            }
            line(x, y, x + 12, y + 12);
        }
    }
}

function mousePressed() {
    option = (option + 1) % 5;
}