
public class TowersOfHanoi {

	public static void main(String[] args) {
		int numDisks = 4;
		System.out.println("INSTRUCTIONS FOR TOWERS OF HANOI WITH " + numDisks + " DISKS\n");
		// Move numDisks from peg A to peg C via peg B
		hanoi(numDisks, "A", "B", "C");
	}
	
	public static void hanoi(int numDisks, String startPeg, String extraPeg, String endPeg) {
		if (numDisks > 1)
			hanoi(numDisks-1, startPeg, endPeg, extraPeg);
		System.out.println("Move one disk from " + startPeg + " to " + endPeg);
		if (numDisks > 1)
			hanoi(numDisks-1, extraPeg, startPeg, endPeg);
	}
}
