
import java.awt.*;
import java.awt.event.*;
import javax.swing.*;

public class Maze extends JFrame implements ActionListener {

	private Container pane;	
	private JPanel subpanel;	// buttons for maze
	private int[][] colorGrid;
	private int numRows;
	private int numColumns;
	private JButton[][] buttonArray;
	private JButton solveButton;
	private JButton clearButton;
	
	public Maze(int[][] grid) {

		super("Maze");
		
		numRows = grid.length;
		numColumns = grid[0].length;		// all rows are same length so use row 0 
		colorGrid = grid;

		pane = getContentPane();
		pane.setLayout(new BorderLayout());
		
		subpanel = new JPanel();
		subpanel.setLayout(new GridLayout(numRows, numColumns));
		subpanel.setBackground(Color.WHITE);
		
		buttonArray = new JButton[numRows][numColumns];
		for (int i = 0; i < numRows; i++) {
			for (int j = 0; j < numColumns; j++) {
				buttonArray[i][j] = new JButton();
				buttonArray[i][j].setIcon(getIcon(colorGrid[i][j]));
				buttonArray[i][j].setBackground(Color.white);
				buttonArray[i][j].addActionListener(this);
				subpanel.add(buttonArray[i][j]);
			}
		}
		pane.add(subpanel, BorderLayout.CENTER);
		
		solveButton = new JButton("SOLVE");
		solveButton.addActionListener(this);
		pane.add(solveButton, BorderLayout.SOUTH);
		
		clearButton = new JButton("CLEAR");
		clearButton.addActionListener(this);
		pane.add(clearButton, BorderLayout.NORTH);
		
		setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		setSize(numRows*100, (numColumns+1)*50);
		setResizable(false);
		setVisible(true);
		
	}

	public Icon getIcon(int colorNum) {
		// Maps a grid number into a color
		switch (colorNum) {
		case 0: return new ImageIcon("images/green.jpg");
		case 1: return new ImageIcon("images/red.jpg");
		default: return null;
		}
	}
	
	public void actionPerformed(ActionEvent ae) {
		// Determine which button was clicked
		if (ae.getSource() == solveButton)
			solveMaze(0,0);
		else if (ae.getSource() == clearButton) {
			for (int i = 0; i < numRows; i++)
				for (int j = 0; j < numColumns; j++)
					buttonArray[i][j].setBackground(Color.white);
		}
		else {
			// Otherwise find out which maze button was clicked and toggle its color.
			int row = 0;    
			int col = 0;
			boolean found;

			found = false;
			row = 0;
			while (!found && row < numRows) {
				col = 0;
				while (!found && col < numColumns) {
					if (ae.getSource() == buttonArray[row][col])
						found = true;
					else
						col++;
				}
				if (!found)
					row++;
			}
			colorGrid[row][col] = (colorGrid[row][col]+1)%2;	// toggle from 0 to 1 or 1 to 0
			buttonArray[row][col].setIcon(getIcon(colorGrid[row][col]));			
		}
	}
	
	public boolean solveMaze(int x, int y) {
		// find a path from (x,y) to (numRows-1, numColumns-1)
		
		System.out.println(x + " " + y);		// print each cell visited for tracing
		
		// base cases
		if (x < 0 || x >= numColumns || y < 0 || y >= numRows)
			return false;
		if (colorGrid[y][x] == 1)   								  // RED, invalid cell
			return false;
		if (!buttonArray[y][x].getBackground().equals(Color.white))   // visited
			return false;
		if (x == numColumns-1 && y == numRows-1) {
			buttonArray[y][x].setBackground(Color.blue);
			return true;
		}
		
		// recursive step
		buttonArray[y][x].setBackground(Color.blue);
		// Try right first, then down, then left, then up
		if (solveMaze(x+1,y) || solveMaze(x,y+1) || solveMaze(x-1,y) || solveMaze(x,y-1))
			return true;
		else {
			// No path to exit from neighbors so backtrack. Color node yellow (visited but not part of solution) and answer NO from here
			buttonArray[y][x].setBackground(Color.yellow);
			return false;
		}
			
	}

	
	public static void main(String[] args) {
		
		int numRows = 5;
		int numColumns = 7;
		
		int[][] grid = new int[numRows][numColumns];
		for (int i = 0; i < numRows; i++)
			for (int j = 0; j < numColumns; j++)
				grid[i][j] = 0;

		Maze mazeGUI = new Maze(grid);
	}
	
}
