import java.io.*;

public class BinaryTree<E> implements Serializable {

	protected BTNode<E> root;
	
	public BinaryTree() {
		root = null;
	}
	
	public BinaryTree(E element, BinaryTree<E> leftTree, BinaryTree<E> rightTree) {
		root = new BTNode<E>(element);
		if (leftTree != null)
			root.left = leftTree.root;
		if (rightTree != null)
			root.right = rightTree.root;
	}
	
	protected BinaryTree(BTNode<E> rootNode) {
		root = rootNode;
	}
	
	public BinaryTree<E> getLeftSubtree() {
		if (root != null && root.left != null) 
			return new BinaryTree<E>(root.left);
		else
			return null;
	}
	
	public BinaryTree<E> getRightSubtree() {
		if (root != null && root.right != null) 
			return new BinaryTree<E>(root.right);
		else
			return null;
	}
	
	public boolean isLeaf() {
		// Is this tree a single leaf?
		if (root == null)
			return false;
		else
			return (root.left == null && root.right == null);
	}
	
	public String toString() {
		StringBuilder sb = new StringBuilder();
		preOrderTraversal(root, 1, sb);
		return sb.toString();
	}
	
	private void preOrderTraversal(BTNode<E> node, int depth, StringBuilder sb) {
		for (int i = 1; i < depth; i++)
			sb.append ("  ");
		if (node == null)
			sb.append("null\n");
		else {
			sb.append(node.toString());
			sb.append("\n");
			preOrderTraversal(node.left, depth+1, sb);
			preOrderTraversal(node.right, depth+1, sb);
		}
	}
	
	protected static class BTNode<E> implements Serializable {
		protected E data;
		protected BTNode<E> left;
		protected BTNode<E> right;
		
		public BTNode(E element) {
			data = element;
			left = null;
			right = null;
		}
		
		public String toString() {
			return data.toString();
		}
	}
	
	
	public static void main(String[] args) {
		
		// trivial tester for binary trees
		
		BinaryTree<String> t1 = new BinaryTree<String>();
		BinaryTree<String> t2 = new BinaryTree<String>("A", t1, t1);
		BinaryTree<String> t3 = new BinaryTree<String>("B", t1, t2);
		BinaryTree<String> t4 = new BinaryTree<String>("C", t3, t1);

		System.out.println(t4);
		
		
		
		
		
	}
	
}
