
public class BinarySearchTree <E extends Comparable<E>> extends BinaryTree<E> {

	protected boolean addReturn;
	protected E removeReturn;
	
	// Wrapper method for user of class to call
	public E find(E target) {
		return find(root, target);
	}
	
	// Search for the target in the tree starting at the node referenced by localRoot
	private E find(BTNode<E> localRoot, E target) {
		// Is the tree empty?
		if (localRoot == null)
			return null;

		// Otherwise look at data in local root (each subtree has its own "local" root)
		int compResult = target.compareTo(localRoot.data);
		if (compResult == 0) 
			return localRoot.data;		// found it, return reference to the data
		else if (compResult < 0)
			return find(localRoot.left, target);	// target is "less" than local root, so search left
		else
			return find(localRoot.right, target);	// target is "greater" than local root, so search right
	}

	// Wrapper method for user of class to call
	public boolean add(E item) {
		root = add(root, item);
		return addReturn;
	}

	// Add item to BST rooted at localRoot
	// Add returns a reference to the root of the new tree once it's updated
	// Field addReturn is defined to hold the result of the add (successful or not) so that
	// the recursive calls don't have to return it all the way back to the wrapper method explicitly.
	private BTNode<E> add(BTNode<E> localRoot, E item) {
		if (localRoot == null) {
			addReturn = true;
			return new BTNode<E>(item);
		}
		else if (item.compareTo(localRoot.data) == 0) {
			addReturn = false;
			return localRoot;
		}
		else if (item.compareTo(localRoot.data) < 0) {
			localRoot.left = add(localRoot.left, item);
			return localRoot;
		}
		else {
			localRoot.right = add(localRoot.right, item);
			return localRoot;
		}
	}

	// Wrapper method for user of class to call
	public E remove(E target) {
		root = remove(root, target);
		return removeReturn;
	}
	
	// Remove item from BST rooted at localRoot, if present
	// Returns a reference to the root of the new tree once it's updated
	// Field removeReturn is defined to hold the result of the remove (the item removed) so that
	// the recursive calls don't have to return it all the way back to the wrapper method explicitly.	
	private BTNode<E> remove(BTNode<E> localRoot, E item) {
		if (localRoot == null) {
			removeReturn = null;
			return localRoot;
		}
		int compResult = item.compareTo(localRoot.data);
		if (compResult < 0) {
			localRoot.left = remove(localRoot.left, item);
			return localRoot;
		}
		else if (compResult > 0) {
			localRoot.right = remove(localRoot.right, item);
			return localRoot;
		}
		else {
			removeReturn = localRoot.data;
			if (localRoot.left == null) {
				return localRoot.right;
			}
			else if (localRoot.right == null) {
				return localRoot.left;
			}
			else {
				removeReturn = localRoot.data;
				if (localRoot.left.right == null) {
					localRoot.data = localRoot.left.data;
					localRoot.left = localRoot.left.left;
					return localRoot;
				}
				else {
					localRoot.data = findLargestChild(localRoot.left);
					return localRoot;
				}
			}
		}
	}
	
	// Support method for remove, when the node removed has two children
	private E findLargestChild(BTNode<E> parent) {
		// Precondition: parent.right is not null (guaranteed by initial call from
		// remove method and from recursive call below)
		if (parent.right.right == null) {
			E returnValue = parent.right.data;
			parent.right = parent.right.left;
			return returnValue;
		}
		else
			return findLargestChild(parent.right);
	}
	
	public static void main(String[] args) {
		// Create a BST
		
		BinarySearchTree<Integer> b = new BinarySearchTree<Integer>();
		
		b.add(62);
		b.add(96);
		b.add(11);
		b.add(39);
		b.add(21);
		b.add(83);
		b.add(45);
		
		System.out.println(b + "\n");
		
		System.out.println("Finding 11: " + b.find(11));
		System.out.println("Finding 21: " + b.find(21));
		System.out.println("Finding 31: " + b.find(31));
		System.out.println("Finding 45: " + b.find(45));
		System.out.println();

		System.out.println("Removing 45:");
		b.remove(45);
		System.out.println(b + "\n");

		System.out.println("Removing 11:");
		b.remove(11);
		System.out.println(b + "\n");
		
		System.out.println("Removing 77:");
		b.remove(77);
		System.out.println(b + "\n");
		
		System.out.println("Removing 62:");
		b.remove(62);
		System.out.println(b + "\n");
		
	
	}
	
	
}
