import java.util.Scanner;
import java.io.File;
import java.io.IOException;

public class SudokuGame {

    public static void main(String[] args) 
    {

        // Create an array to hold the initial values of the Sudoku
        // game board.
        int[][] initialValue = new int[9][9];

        // Read in the initial game board values from a text file.
        // Text files should be located in the same folder as the
        // source code (Java files). If the input file cannot be found, 
        // then use an empty game board instead.

        Scanner scan = new Scanner(System.in);
        System.out.print("Input name of game puzzle file: ");
        String fileName = scan.nextLine();     

        try 
        {
            // An exception may be thrown here if the new File reference
            // cannot be made because the file cannot be found.
            Scanner fileScan = new Scanner(new File(fileName));
            
            for (int row = 0; row < 9; row++)
            {
                for (int col = 0; col < 9; col++)
                {
                    initialValue[row][col] = fileScan.nextInt();
                }
                fileScan.nextLine();
            }
        }
        catch (IOException e)
        {
            System.out.println("WARNING: Could not open " + fileName);
            System.out.println(e);    // print out exception information if desired
            System.out.println("USING EMPTY BOARD AS INITIAL GAME.");

            for (int row = 0; row < 9; row++)
            {
                for (int col = 0; col < 9; col++)
                {
                    initialValue[row][col] = 0;
                }
            }
        }

        // Create the graphical game board so the user can begin playing.
        SudokuBoard game = new SudokuBoard(initialValue);

    }
	
}
