import javax.swing.*;
import java.awt.*;
import java.awt.event.*;

public class SudokuBoard extends JFrame implements ActionListener
{  

    private static final String[] digitChoices 
            = {"","1","2","3","4","5","6","7","8","9"};
    private Container pane;
    private JComboBox[][] comboBoxArray;
    private int[][] board;
	
    // Constructor: Assumes the initalValue array contains integers between 0-9 only
    public SudokuBoard(int[][] initialBoard) 
    {
        // Constructor for the graphic user interface (GUI) frame
        // that requires a two-dimensional array containing the
        // initial values for the Sudoku board.  Each cell of the
        // array contains either a number between 1-9 or a 0 if
        // that cell is initially "empty" in the Sudoku game.
        // Cells initialized to values between 1-9 cannot be changed
        // during the game.

	// call constructor of superclass with title for window
        super("Sudoku");

        // Get a container for GUI components to be placed.
        pane = getContentPane();

        // Set the layout manager of the pane to a 9-by-9 grid,
        // plus an extra empty row to show a background of green or
        // red depending on whether the current board is valid or not.
        // (The layout manager controls how components of the interface
        // will be organized in the window frame.)
        pane.setLayout(new GridLayout(10,9));

        // Create a two dimensional array to hold a "combo-box"
        // for each cell on the grid on the frame's pane.
        comboBoxArray = new JComboBox[9][9];

        // initialize the values on the board
        board = initialBoard;

        // Create a "combo-box" for each grid location on the GUI pane
        // and initialize the choices for each button based on the 
        // corresponding value in the boardValue array.

        for (int row = 0; row < 9; row++) 
        {
            for (int col = 0; col < 9; col++) 
            {
                if (initialBoard[row][col] == 0) 
                {
                    //  Current row and column in game board is "empty"
                    //  Set up a menu of digits for the "combo-box" that 
                    //  the user can select.

                    comboBoxArray[row][col] = new JComboBox(digitChoices);
                    comboBoxArray[row][col].setSelectedIndex(0);   // initial button value displayed

		    // Use this JFrame as the actionListener for the JComboBox.
                    comboBoxArray[row][col].addActionListener(this);
                }
                else 
                {
		    //  Current row and column in game board has a value
                    //  between 1-9. Set up a "combo-box" that contains only
                    //  that value (so user cannot change it).

                    String[] single = new String[1];
                    single[0] = "" + initialBoard[row][col];
                    comboBoxArray[row][col] = new JComboBox(single);
                    comboBoxArray[row][col].setForeground(Color.RED);
                }

                // Set background color of combo-box to either gray
                // or light gray depending on which 3 X 3 square it is in.

                if ((row >= 0 && row <= 2) || (row >= 6 && row <= 8))
                {
                    if ((col >= 0 && col <= 2) || (col >= 6 && col <= 8))
                    {
                        comboBoxArray[row][col].setBackground(Color.GRAY);
                    }
                    else
                    {
                        comboBoxArray[row][col].setBackground(Color.LIGHT_GRAY);
                    }
                }
                else
                {
                    if (col >= 3 && col <= 5)
                    {
                        comboBoxArray[row][col].setBackground(Color.GRAY);
                    }
                    else
                    {
                        comboBoxArray[row][col].setBackground(Color.LIGHT_GRAY);
                    }
                }

	
                // Add the "combo-box" to the pane of the window frame
                // in the next available grid layout position.  (Grid
                // positions are filled in row by row, left to right.)
                pane.add(comboBoxArray[row][col]);
            }
        }

        // Exit the program when the user closes the frame.
        setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);

        // Set the size of the window frame.
        setSize(450, 500);

        // Don't allow changing the size of the window frame.
        setResizable(false);

        // Make the window frame visible.
        setVisible(true);

    }

    public void actionPerformed(ActionEvent ae) 
    {
        // This method is required since this class implements the
        // ActionListener interface.
		
        for (int row = 0; row < 9; row++) 
        {
            for (int col = 0; col < 9; col++) 
            {
                // Find out which "combo-box" was changed.
                // (The ActionEvent ae has a reference to the combo-box
                // that was changed. When a combo-box is changed, an
                // ActionEvent object is created, and this method is
                // called immediately by the frame to process the event.)
                if (ae.getSource() == comboBoxArray[row][col]) 
                {
                    // Get the current menu value of the combo-box
                    // that the user changed and store it in the boardArray
                    int index = comboBoxArray[row][col].getSelectedIndex();
                    board[row][col] = index;
                }				
            }
        }
		
        // If the user changes a combo-box to a new value, call the static
        // isValid method of the SudokuGame class to see if the current
        // boardArray is valid according to Sudoku rules.  If so, set the
        // background of the pane to green, otherwise set the background
        // of the pane to red.
        if (isBoardValid()) 
            pane.setBackground(Color.GREEN);
        else 
            pane.setBackground(Color.RED);
	
    }

    private boolean isBoardValid()
    {
        // ASSIGNMENT:
        // Complete this method that takes the current values of the
        // Sudoku game board as represented in the 2D array board
        // and returns true if the current values represent
        // a valid Sudoku game or false if the current values
        // do not represent a valid Sudoku game.  By valid, we mean
        // that the numbers currently on the board do not violate any
        // of the Sudoku game rules.  The board does not have to be
        // totally completed to be valid, but the numbers that are there
        // must follow the Sudoku number placement rules.

        return true;   // WARNING: Remove this instruction before completing this method!






    }

}

