public class Customer
{	
	// class to model a phone company customer
	
	private String name;
	private String type;			// "Residential" or "Business"
	private int rate;			// in cents per minute
	private int minutes;			// minutes used by customer
	private int numPhoneLines;		// number of phone lines installed
	
	public Customer(String customerName, String customerType, int customerRate)
	{
		name = customerName;
		type = customerType;
		rate = customerRate;
		minutes = 0;
		numPhoneLines = 1;
	}

        public Customer(String customerName, String customerType)
	{
		name = customerName;
		type = customerType;
		if (type.equals("Residential"))
			rate = 8;
		else
			rate = 4;
		minutes = 0;
		numPhoneLines = 1;
	}

        public Customer(String customerName)
	{
		name = customerName;
		type = "Residential";
		rate = 8;
		minutes = 0;
		numPhoneLines = 1;
	}

	public void addPhoneLine()
	{
		numPhoneLines++;
	}

	public void addUsage(int numMinutes)
	{
		minutes += numMinutes;
	}

	public String getName()
	{
		return name;
	}
	
	public String getTypeOfService()
	{
		return type;
	}
	
	public int getRate()
	{
		return rate;
	}
	
	public int getMinutes()
	{
		return minutes;
	}
	
	public int getNumPhoneLines()
	{
		return numPhoneLines;
	}

	public String toString()
	{
		return getName() + "," + getTypeOfService() + "," +
			getRate() + " cents/min," + getMinutes() + " minutes," +
			getNumPhoneLines() + " phone line(s)";
	}			
}
