import javax.swing.*;
import java.awt.*;
import java.awt.event.*;

public class MagicSquareGUI extends JFrame implements ActionListener
{  

    private static final String[] spaceChoices 
            = {"","1","2","3","4","5","6","7","8","9"};
    private Container pane;
    private JComboBox[][] comboBoxArray;
    private int[][] board;
	
    public MagicSquareGUI(int[][] initialBoard) 
    {
	// Initialize JFrame properties and set layout of pane

        super("Magic Square");
        pane = getContentPane();
        pane.setLayout(new GridLayout(4,3));

	// Create array to hold all of the combo boxes for the game

        comboBoxArray = new JComboBox[3][3];

        // Initialize the values on the board from the array passed
	// in as the parameter from main

        board = initialBoard;

        // Create a "combo-box" for each grid location on the GUI pane
        // and initialize the choices for each button based on the 
        // corresponding value in the boardValue array.

        for (int row = 0; row < 3; row++) 
        {
            for (int col = 0; col < 3; col++) 
            {
		// Create a combo box for the current row and column
		// using the spaceChoices array of strings
		// and set the selected index to the value in
		// the initial board for that row and column

		comboBoxArray[row][col] = new JComboBox(spaceChoices);
		comboBoxArray[row][col].setSelectedIndex(board[row][col]);

                // Use this JFrame as the actionListener for the JComboBox.
                comboBoxArray[row][col].addActionListener(this);

		// Set the background for this combo box so that the
		// entire board is a checkerboard pattern of 
		// orange and yellow.
		
                if ( (row+col)%2 == 0 )
                        comboBoxArray[row][col].setBackground(Color.ORANGE);
                else
                        comboBoxArray[row][col].setBackground(Color.YELLOW);
	
                // Add the "combo-box" to the pane of the window frame
                // in the next available grid layout position.  (Grid
                // positions are filled in row by row, left to right.)
                pane.add(comboBoxArray[row][col]);

            }
        }

        // Exit the program when the user closes the frame.
        setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);

        // Set the size of the window frame.
        setSize(150, 200);

        // Don't allow changing the size of the window frame.
        setResizable(false);

        // Make the window frame visible.
        setVisible(true);

    }

    public void actionPerformed(ActionEvent ae) 
    {
        // This method is required since this class implements the
        // ActionListener interface.

        for (int row = 0; row < 3; row++) 
        {
            for (int col = 0; col < 3; col++) 
            {
                // Find out which "combo-box" was changed.
                // (The ActionEvent ae has a reference to the combo-box
                // that was changed. When a combo-box is changed, an
                // ActionEvent object is created, and this method is
                // called immediately by the frame to process the event.)
                if (ae.getSource() == comboBoxArray[row][col]) 
                {
                    // Get the current menu value of the combo-box
                    // that the user changed and store it in the board array
                    int index = comboBoxArray[row][col].getSelectedIndex();
                    board[row][col] = index;
                }				
            }
        }
		
        if (isBoardValid()) 
            pane.setBackground(Color.GREEN);
        else 
            pane.setBackground(Color.RED);
	
    }

    private boolean isBoardValid()
    {
        // Return false if the board is not a magic square (not all
	// rows, columns and diagonals add up to the same number).
	// Otherwise, return true (given below).
        // COMPLETE CODE HERE:










        return true;   		// if board is valid
    }

}

