public class Car
{
	// simple class to model a Car object

	// fields to store data about properties of object
	private String make;
	private int mileage;

	// Constructors to create an instance of this class

	public Car(String carMake, int initialMileage) {
		// Assuming parameters have valid data
		make = carMake;
		mileage = initialMileage;
	}

	public Car(String carMake) {
		// Assuming parameter has valid data
		make = carMake;
		mileage = 0;	// default mileage is 0, i.e. new car
	}

	// Accessors

	public int getMileage() {
		return mileage;
	}

	public String getMake() {
		return make;
	}

	public double getCostOfOwnership() {
		// Cost of ownership is 45 cents per mile driven
		double cost = 0.45 * mileage;
		return cost;
	}

	// Mutators (can possibly change the state of the object)

	public void drive(int miles) {
		// Drive the car the number of miles given in the
		// parameter, as long as it is positive
		if (miles > 0)
			mileage += miles;
	}

	public void resetMileage() {
		// Legal disclaimer: don't do this at home.
		mileage = 0;
	}

	// Other methods

	public String toString() {
		// Returns a string representation of current state of object
		return "Make = " + make + ", Mileage = " + mileage;
	}

	public boolean equals(Car otherCar) {
		// returns true if the car that is running this method
		// is equal to another car with regard to make AND mileage
		return (this.make.equals(otherCar.make) &&
			this.mileage == otherCar.mileage);
	}

}
