#/usr/bin/python

import sys
import socket
from select import select

_timeout = 10
_bufsize = 65536
_debug = False

usertable = {}

class Daemon:
    def __init__(self, id, addr):
        hostname, port = addr
        self.id = id
        self.listensock = socket.socket()
        self.listensock.bind(('0.0.0.0', port))
        self.listensock.listen(5)
        self.sock = None

    def accept(self):        
        self.sock, _ = self.listensock.accept()
        return self.sock, self.handler
        
    def handler(self):
        # Parse the message from the IRC server.  So far, only
        # commands needed for the checkpoint are implemented.
        if self.sock == None:
            return False
        
        msg = self.sock.recv(_bufsize)
        
        if len(msg) == 0:
            self.sock.close()
            self.sock = None
            return False

        for line in msg.splitlines():
            if _debug: print 'Recv: %s' % line
            params = line.split()
            cmd = params[0]

            if cmd == 'ADDUSER':
                usertable[params[1]] = self
                self.sock.send('OK\r\n')
                
            elif cmd == 'NEXTHOP':
                nick = params[1]
                try:
                    self.sock.send('OK %s 1\r\n' % (usertable[nick].id))
                except KeyError:
                    self.sock.send('NONE\r\n')
                    
            elif cmd == 'USERTABLE':
                self.sock.send('OK %d\r\n' % len(usertable))
                for nick in usertable:
                    self.sock.send('%s %s 1\r\n' % \
                                   (nick, usertable[nick].id))

            elif params[0] == 'NEXTHOPS':
                self.sock.send('NONE\r\n')

            elif params[0] == 'CHANTABLE':
                self.sock.send('OK 0\r\n')

            elif params[0] in ['ADDCHAN',
                               'REMOVEUSER',
                               'REMOVECHAN']:
                self.sock.send('OK\r\n')
                
        return True

    def close(self):
        self.listensock.close()
        if self.sock: self.sock.close()

def configure(nodeconf):
    # Extract ports, addresses, from configuration file
    fp = open(nodeconf)
    try:
        lines = [line.split() for line in fp]
        conf1 = lines[0][0], (lines[0][1], int(lines[0][3]))
        conf2 = lines[1][0], (lines[1][1], int(lines[1][3]))
        return conf1, conf2
    finally:
        fp.close()

if __name__ == '__main__':
    
    # Grab configuration from the file
    try: conf1, conf2 = configure(sys.argv[1])
    except IndexError:
        print 'Usage: ./%s <configuration file>' % sys.argv[0]
        sys.exit(-1)

    id1, addr1 = conf1
    id2, addr2 = conf2
    daemon1 = Daemon(id1, addr1)
    daemon2 = Daemon(id2, addr2)

    # Prepare handlers for accepted connections
    listensocks = {daemon1.listensock : daemon1.accept,
                   daemon2.listensock : daemon2.accept}    

    clientsocks = {}

    # Start the routing daemons
    try:
        while True:
            socks = listensocks.keys() + clientsocks.keys()
            recvset, _, _ = select(socks, [], [], _timeout)
            for sock in recvset:
                if sock in listensocks:
                    clientsock, handler = listensocks[sock]()
                    clientsocks[clientsock] = handler
                elif sock in clientsocks:
                    if not clientsocks[sock]():
                        del(clientsocks[sock])    
    finally:
        # Graceful cleanup
        daemon1.close()
        daemon2.close()
    
