#/usr/bin/python

import sys
import socket
import string
from random import choice
from select import select
from time import sleep

_message = ''.join([choice(string.ascii_lowercase) for i in xrange(40)])
_bufsize = 65536
_timeout = 10
_maxscore = 15
_debug = True

class Client:
    def __init__(self, addr):
        self.sock = socket.socket()
        self.sock.connect(addr)

    def register(self, nick):
        self.nick = nick
        print 'Registering %s' % nick
        self.sock.send('NICK %s\r\n' % nick)
        sleep(1)
        self.sock.send('USER user host server :Real Name\r\n')

    def handler(self):
        msg = self.sock.recv(_bufsize)
        for line in msg.splitlines():
            if _debug: print >> sys.stderr, '%s: recv(%s)' % (self.nick, line)
        return (msg.find(_message) >= 0)

    def msg(self, nickto, msg):
        self.sock.send('PRIVMSG %s :%s\r\n' % (nickto, msg))

    def close(self):
        self.sock.close()

def configure(nodeconf):
    fp = open(nodeconf, 'r')
    try:
        lines = [line.split() for line in fp]
        addr1 = lines[0][1], int(lines[0][4])
        addr2 = lines[1][1], int(lines[1][4])
        return addr1, addr2
    finally:
        fp.close()

if __name__ == '__main__':
    print 'Sleeping...'
    sleep(5)
    # Grab configuration from the file
    try:
        addr1, addr2 = configure(sys.argv[1])
    except IndexError:
        print 'Usage: ./%s <configuration file>' % sys.argv[0]
        sys.exit(-1)

    # Initialize two clients
    print >> sys.stderr, 'Initializing clients.'
    client1 = Client(addr1)
    client2 = Client(addr2)

    # Set up the hash table for socket -> client lookup
    entities = [client1, client2]
    socktable = dict([(entity.sock, entity) for entity in entities])
    socks = socktable.keys()
    score = 0

    try:
        # Connect and register both clients
        print >> sys.stderr, 'Registering clients.'
        client1.register('nick1')
        client2.register('nick2')
        sleep(1)
        
        # Send a privmsg from one client to another
        print >> sys.stderr, 'Sending message to remote client.'
        client1.msg('nick2', _message)

        # Recv everything we can until we timeout
        print >> sys.stderr, 'Processing replies from server.'
        while True:
            recvset, _, _ = select(socks, socks, [], _timeout)
            for sock in recvset:
                if socktable[sock].handler() and socktable[sock] is client2:
                    score = _maxscore
                    raise Exception('Checkpoint passed!')
    except Exception, e:
        print 'ERROR:', e
        
        # Make sure all the sockets close gracefully
        client1.close()
        client2.close()

        # Report the scores to the screen, and in the exit value, so
        # the Makefile will be able to detect errors
        print 'Your final score: %d' % score
        if score > 0: sys.exit(0)            
        else: sys.exit(-1)
