
#include "common.h"
#include "gcsmppriv.h"
#include "gcdata.h"

PageQueue::PageQueue()
{
	first_page = last_page = NULL;
	//page_count = 0;
}

PageQueue::~PageQueue()
{
}

void PageQueue::CopyInto(PageQueue& queue)
{
	queue.first_page = first_page;
	queue.last_page = last_page;
	//queue.page_count = page_count;
}

Page* PageQueue::PeekFirstPage()
{
	return first_page;
}

Page* PageQueue::PeekLastPage()
{
	return last_page;
}

BOOL PageQueue::IsEmpty()
{
	//ASSERT(first_page == NULL ? page_count == 0 : TRUE);
	return first_page == NULL;
}

Page* PageQueue::PopPage()
{
	if (first_page == last_page) {
		last_page = NULL;
	}

	Page* result = first_page;

	if (result != NULL) {
		first_page = result->GetNextPage();

		result->SetNextPage(NULL);
		ASSERT(result->GetPrevPage() == NULL);

		//--page_count;
	}

	if (first_page != NULL) {
		first_page->SetPrevPage(NULL);
	}
	return result;
}

void PageQueue::PopPages(Page*& first, Page*& last, int& count)
{
	ASSERT(first_page != NULL);

	first = first_page;
	first_page = first->GetNextNonContinuedPage(count);

	if (first_page == NULL) {
		last_page = NULL;
	}

	for (last = first;
			 last->GetNextPage() != first_page;
			 last = last->GetNextPage()) {
	}

	//page_count -= count;

	last->SetNextPage(NULL);
	ASSERT(first->GetPrevPage() == NULL);

	if (first_page != NULL) {
		first_page->SetPrevPage(NULL);
	}
}

void PageQueue::PushPage(Page* page)
{
	ASSERT(page->GetNextPage() == NULL);
	if (last_page == NULL) {
		first_page = last_page = page;
		first_page->SetPrevPage(NULL);
	}
	else {
		last_page->SetNextPage(page);
		page->SetPrevPage(last_page);
		last_page = page;
	}
	//++page_count;
}

void PageQueue::PushPages(Page* first, Page* last, int count)
{
	ASSERT(last->GetNextPage() == NULL);
	if (last_page == NULL) {
		first_page = first;
		first_page->SetPrevPage(NULL);
		last_page = last;
	}
	else {
		last_page->SetNextPage(first);
		first->SetPrevPage(last_page);
		last_page = last;
	}

	//page_count += count;
}


void PageQueue::InsertAfter(Page* first, Page* last, Page* target)
{
	ASSERT(first);
	ASSERT(last);
	ASSERT(target);

	Page* tmp = target->GetNextPage();

	target->SetNextPage(first);
	first->SetPrevPage(target);
	last->SetNextPage(tmp);

	if(tmp != NULL) {
		tmp->SetPrevPage(last);
	}
	else {
		// A was the last_page
		ASSERT(target == last_page);
		last_page = last;
	}
	//++page_count;
}

void PageQueue::InsertBefore(Page* first, Page* last, Page* target)
{
	ASSERT(first);
	ASSERT(last);
	ASSERT(target);

	Page* tmp = target->GetPrevPage();

	target->SetPrevPage(last);
	last->SetNextPage(target);
	first->SetPrevPage(tmp);

	if(tmp != NULL) {
		tmp->SetNextPage(first);
	}
	else {
		// A was the first_page
		ASSERT(target == first_page);
		first_page = first;
	}
	//++page_count;
}

void PageQueue::CoalescePages(Page* first, Page* last, int count)
{
	// FIXME spoons: There are possibilities of for fragmentation with this
	// implmentation -- we really need to do some coalescing.
	Page* adjacent_page = first - 1;
	if (adjacent_page >= gc_heap::lower_page
			&& adjacent_page->HasStatus(Page::STATUS_FREE)) {
		InsertAfter(first, last, adjacent_page);
	}
	else if ((adjacent_page = last + 1) < gc_heap::upper_page
					 && adjacent_page->HasStatus(Page::STATUS_FREE)) {
		InsertBefore(first, last, adjacent_page);
	}
	else {
		PushPages(first, last, count);
	}
}

void PageQueue::RemovePage(Page* a)
{
	if (a == PeekFirstPage()) {
		PopPage();
	}
	else if (a == PeekLastPage()) {
		// a is not the first page ==> there are at least two pages
		last_page = a->GetPrevPage();
		last_page->SetNextPage(NULL);
		a->SetPrevPage(NULL);
	}
	else {
		a->GetPrevPage()->SetNextPage(a->GetNextPage());
		a->GetNextPage()->SetPrevPage(a->GetPrevPage());
		a->SetPrevPage(NULL);
		a->SetNextPage(NULL);
	}
}

void PageQueue::RemovePages(Page* a, Page* b, int count)
{
	Page* next_page = b->GetNextPage();

	if (a == PeekFirstPage()) {
		// a is the beginning of this list.
		Page* page = PopPage();
		while (TRUE) {
			if (PeekFirstPage() == next_page) {
				break;
			}
			else {
				Page* tmp = PopPage();
				page->SetNextPage(tmp);
				tmp->SetPrevPage(page);
				page = tmp;
			}
		}
	}
	else {
		Page* previous_page;
#ifdef VERIFY_HEAP
		for (previous_page = PeekFirstPage();
				 previous_page->GetNextPage() != a;
				 previous_page = previous_page->GetNextPage());
		ASSERT(previous_page == a->GetPrevPage());
#else
		previous_page = a->GetPrevPage();
#endif
		previous_page->SetNextPage(next_page);
		if (next_page != NULL) {
			next_page->SetPrevPage(previous_page);
		}
		else {
			last_page = previous_page;
		}
		page_count -= page_count;
	}

	b->SetNextPage(NULL);
	//page_count -= count;
}

void PageQueue::Clear()
{
	first_page = last_page = NULL;
	//page_count = 0;
}

int PageQueue::GetLength()
{
	int count = 0;
	for( Page* tmp_page = first_page;
			 tmp_page != NULL;
			 ++count, tmp_page = tmp_page->GetNextPage());
	//return count;
	//ASSERT(count == page_count);

	return count;
}



WorkList::WorkList()
{
  Init();
}

void WorkList::Init()
{
	obj_list_size = 128;
	obj_list_free =	obj_list_size - 1;

	obj_list = new (Object*[obj_list_size]);

#ifdef _DEBUG
	memset((BYTE*)obj_list, 0xCC, sizeof(Object*) * obj_list_size);
#endif // _DEBUG

	obj_first_item = 0;
	obj_last_item = -1;

	work_list_size = 4;

	work_list = new (Work[work_list_size]);

#ifdef _DEBUG
	memset((BYTE*)work_list, 0xCC, sizeof(Work) * work_list_size);
#endif // _DEBUG

	work_first_item = 0;
	work_last_item = -1;
}

WorkList::~WorkList()
{
	delete (obj_list);
	delete (work_list);
}

void
WorkList::AddAll(WorkList* other)
{
	ASSERT(other->obj_first_item == other->obj_last_item + 1);
	/*
	int size = (other->obj_list_size - 1) - other->obj_list_free;
	int end = (obj_last_item < obj_first_item) ? obj_first_item
		: obj_list_size;

	while (size > obj_list_free) {
		// FIXME this will cause unnecessary copying
		obj_list_free = -1;
		ExpandObjList();
	}

	// Copy the part that fits after last (without wrapping around).
	if (obj_last_item + size + 1 > end) {
		memcopy((BYTE*)&obj_list[obj_last_item + 1],
						(BYTE*)&other->obj_list[other->obj_first_item],
						(end - (obj_last_item + 1)) * sizeof(Object*));
		obj_last_item = end - 1;
		other->obj_first_item += (end - (obj_last_item + 1));
		size -= (end - (obj_last_item + 1));

		// Copy into the other gap -- that gap between the beginning of the array
		// and obj_first_item.
		ASSERT(size < obj_first_item - 1);
		memcopy((BYTE*)obj_list,
						(BYTE*)&other->obj_list[other->obj_first_item],
						size * sizeof(Object*));
		obj_last_item = size;
	}
	else {
		memcopy((BYTE*)&obj_list[obj_last_item + 1],
						(BYTE*)&other->obj_list[other->obj_first_item],
						size * sizeof(Object*));
		obj_last_item += size;
	}
	other->obj_last_item = other->obj_first_item - 1;
	other->obj_list_free = other->obj_list_size - 1;
	*/

	int size = other->Size();
	int end = (work_last_item < work_first_item) ? work_first_item
		: work_list_size;

	if (size > (work_list_size - (((work_last_item + work_list_size) - work_first_item + 1) % work_list_size) + 1)) {
		// Double the storage?
		// FIXME copy-and-paste from EnsureSpace below
		int new_list_size = work_list_size;
		do {
			new_list_size *= 2;
		}
		while (size > (new_list_size - (((work_last_item + work_list_size) - work_first_item + 1) % work_list_size) + 1));

		Work* new_work_list = new (Work[new_list_size]);

		memcpy(new_work_list, &work_list[work_first_item],
					 (work_list_size - work_first_item) * sizeof(Work));

		// We must check to see whether the old lists wrapped around or no.	 If
		// yes, then we must copy the lists in two pieces.
		if (work_last_item < work_first_item) {
			// Remember that last item points one cell past the actual last item.
			memcpy(&new_work_list[work_list_size - work_first_item], work_list,
						 work_last_item * sizeof(Work));
		}

		delete (work_list);

		work_first_item = 0;
		work_last_item = work_list_size - 1;

		work_list_size = new_list_size;
		work_list = new_work_list;

		end = work_list_size;
	}

	// Copy the part that fits after last (without wrapping around).
	if (work_last_item + size + 1 > end) {
		memcopy((BYTE*)&work_list[work_last_item + 1],
						(BYTE*)&other->work_list[other->work_first_item],
						(end - (work_last_item + 1)) * sizeof(Work));
		work_last_item = end - 1;
		other->work_first_item += (end - (work_last_item + 1));
		size -= (end - (work_last_item + 1));

		// Copy into the other gap -- that gap between the beginning of the array
		// and work_first_item.
		ASSERT(size < work_first_item - 1);
		memcopy((BYTE*)work_list,
						(BYTE*)&other->work_list[other->work_first_item],
						size * sizeof(Work));
		work_last_item = size;
	}
	else if (size > 0) {
		memcopy((BYTE*)&work_list[work_last_item + 1],
						(BYTE*)&other->work_list[other->work_first_item],
						size * sizeof(Work));
		work_last_item += size;
	}
	other->work_last_item = other->work_first_item - 1;
}

void
WorkList::ExpandObjList()
{
	ASSERT(obj_list_free == -1);
	//if ((obj_last_item + 1) % obj_list_size == obj_first_item) {

		// Reallocate the backing storage.	(This test wastes one cell, but makes
		// it easier to distinguish an empty queue from a full one.)

		// Double the storage?
		int new_list_size = obj_list_size * 2;

		Object** new_obj_list = new (Object*[new_list_size]);

#ifdef _DEBUG
		memset((BYTE*)new_obj_list, 0xCC, sizeof(Object*) * new_list_size);
#endif // _DEBUG

		memcpy(new_obj_list, &obj_list[obj_first_item],
					 (obj_list_size - obj_first_item) * sizeof(Object*));

		// We must check to see whether the old lists wrapped around or no.	 If
		// yes, then we must copy the lists in two pieces.
		if (obj_last_item < obj_first_item) {
			// Remember that last item points one cell past the actual last item.
			memcpy(&new_obj_list[obj_list_size - obj_first_item], obj_list,
						 obj_last_item * sizeof(Object*));
		}

		delete (obj_list);

		obj_first_item = 0;
		obj_last_item = obj_list_size - 1;

		// Assume 2x!
		obj_list_free = new_list_size - obj_list_size - 1;
		obj_list_size = new_list_size;
		obj_list = new_obj_list;
  //}
}

inline void
WorkList::EnsureSpace()
{
	if ((work_last_item + 1) % work_list_size == work_first_item) {
		//RetailDebugBreak();

		// Reallocate the backing storage.	(This test wastes one cell, but makes
		// it easier to distinguish an empty queue from a full one.)

		// Double the storage?
		int new_list_size = work_list_size * 2;

		Work* new_work_list = new (Work[new_list_size]);

		memcpy(new_work_list, &work_list[work_first_item],
					 (work_list_size - work_first_item) * sizeof(Work));

		// We must check to see whether the old lists wrapped around or no.	 If
		// yes, then we must copy the lists in two pieces.
		if (work_last_item < work_first_item) {
			// Remember that last item points one cell past the actual last item.
			memcpy(&new_work_list[work_list_size - work_first_item], work_list,
						 work_last_item * sizeof(Work));
		}

		delete (work_list);

		work_first_item = 0;
		work_last_item = work_list_size - 1;

		work_list_size = new_list_size;
		work_list = new_work_list;
	}
}

void
WorkList::AddWorkAsRoot(Object** root, BOOL interior)
{
	work_last_item = (work_last_item + 1) % work_list_size;
	EnsureSpace();
	work_list[work_last_item].root = root;
	work_list[work_last_item].flags =
		(interior ? WORK_INTERIOR_ROOT : WORK_NORMAL_ROOT);
	/*
  obj_last_item = (obj_last_item + 1) % obj_list_size;
	if (!(obj_list_free--)) {
		ExpandObjList();
	}
	obj_list[obj_last_item] =
		((size_t)root | (interior ? WORK_INTERIOR_ROOT : WORK_NORMAL_ROOT));
	*/
}

void
WorkList::AddWorkAsRange(Object* ptr, BYTE* limit)
{
	work_last_item = (work_last_item + 1) % work_list_size;
	EnsureSpace();
	work_list[work_last_item].ptr = ptr;
	work_list[work_last_item].limit = limit;
	work_list[work_last_item].flags = WORK_RANGE_PTR;
}

void
WorkList::AddWorkAsWrites(Object* ptr, BYTE* limit)
{
	ASSERT(gc_heap::GcIsConcurrentCollector());

	/*
	last_item = (last_item + 1) % list_size;
	EnsureSpace();
	work_list[last_item].flags = WORK_WRITES;
	work_list[last_item].ptr = ptr;
	work_list[last_item].limit = limit;
	*/

	ASSERT(!"SPLIT_LIST unsupported in the concurrent collector");
}


BOOL
WorkList::HasWork()
{
	return Size() != 0;
}

BOOL
WorkList::HasPtrWork()
{
	return (obj_list_size - 1) > obj_list_free;
}

int
WorkList::Size()
{
	return ((obj_last_item + obj_list_size) - obj_first_item + 1) % obj_list_size
		+ ((work_last_item + work_list_size) - work_first_item + 1) % work_list_size;
}

void
WorkList::RemoveWork(Work& work)
{
	ASSERT(Size() != 0);
	if ((obj_list_size - 1) > obj_list_free) {
		work.ptr = obj_list[obj_first_item];
		work.flags = WORK_NORMAL_PTR;
		++obj_list_free;

		ASSERT((size_t)work.ptr != 0xCCCCCCCC);

#ifdef _DEBUG
    ((size_t*)obj_list)[obj_first_item] = 0xCCCCCCCC;
#endif

		obj_first_item = (obj_first_item + 1) % obj_list_size;
	}
	else {
		work.root = work_list[work_first_item].root;
		work.limit = work_list[work_first_item].limit;
		work.flags = work_list[work_first_item].flags;

#ifdef _DEBUG
    memset((BYTE*)&work_list[work_first_item], 0xCC, sizeof(Work));
#endif //_DEBUG

		work_first_item = (work_first_item + 1) % work_list_size;
	}
}


int
WorkList::Capacity()
{
  return obj_list_size + work_list_size;
}


