// ==++==
//
//
//	  Copyright (c) 2002 Microsoft Corporation.	 All rights reserved.
//
//	  The use and distribution terms for this software are contained in the file
//	  named license.txt, which can be found in the root of this distribution.
//	  By using this software in any fashion, you are agreeing to be bound by the
//	  terms of this license.
//
//	  You must not remove this notice, or any other, from this software.
//
//
// ==--==
#ifndef __EXCEPTION_HANDLING_h__
#define __EXCEPTION_HANDLING_h__

#define PRETAG_VALUE  0xAAAAAAAA
#define POSTTAG_VALUE 0xFFFFFFFF


typedef DWORD_PTR	(HandlerFn)(DWORD_PTR dwStackFrame, Object* pExceptionObj);

enum CLRUnwindStatus { UnwindPending, FirstPassComplete, SecondPassComplete, UnwindCollided };

class ExceptionTracker
{
public:
	ExceptionTracker(DWORD_PTR dwExceptionPc,
					 DWORD	   ExceptionCode,
					 DWORD_PTR dwNestingLevel) :
#ifdef _DEBUG
		m_dwPreTag(PRETAG_VALUE),
#endif
		m_pPrevious(NULL),
		m_pThread(GetThread()),
		m_dwExceptionPc(dwExceptionPc),
		m_ExceptionCode(ExceptionCode),
		m_fHandlerPending(false),
		m_dwNestingLevel(dwNestingLevel)
#ifdef _DEBUG
		, m_dwPostTag(POSTTAG_VALUE)
#endif
	{
	}

	CLRUnwindStatus ProcessCallFrame(DWORD_PTR dwControlPc, DWORD_PTR dwStackFrame, BOOL fIsFirstPass);
	DWORD			GetExceptionCode() { return m_ExceptionCode; }
	DWORD_PTR		GetResumePC() { return m_dwResumePC; }
	void			UpdateThrowable();
	bool			HasPendingHandler() { return m_fHandlerPending; }
	DWORD_PTR		GetNestingLevel() { return m_dwNestingLevel; }

private:
					DWORD_PTR	CallHandler(DWORD_PTR dwHandlerStartPC, DWORD_PTR dwStackFrame);
					void		GetMethodInfo(DWORD_PTR dwControlPc);
			inline	BOOL		ClauseCoversPC(EE_ILEXCEPTION_CLAUSE* pEHClause, DWORD_PTR dwControlPc);
			static	DWORD_PTR	GetMethodStartAddr(MethodDesc* pMD);

	INDEBUG(inline	void		ValidateState();)
	INDEBUG(inline	BOOL		ThrowableIsValid();)

private:
	INDEBUG(DWORD_PTR	m_dwPreTag;)
public:
	ExceptionTracker*	m_pPrevious;
private:
	Thread*				m_pThread;
	DWORD_PTR			m_dwExceptionPc;
	DWORD				m_ExceptionCode;

	IJitManager*		m_pJitMan;
	METHODTOKEN			m_MethodToken;
	DWORD_PTR			m_dwMethodStartPC;
	DWORD_PTR			m_dwResumePC;

	DWORD_PTR			m_dwResumeStackFrame;
	DWORD_PTR			m_dwCatchToCallPC;

	bool				m_fHandlerPending;
	DWORD_PTR			m_dwNestingLevel;

	INDEBUG(DWORD_PTR	m_dwPostTag;)
};

#endif	// __EXCEPTION_HANDLING_h__
