/**************************************************************************
*                                                                         *
*         Java Grande Forum Benchmark Suite - Thread Version 1.0          *
*                                                                         *
*                            produced by                                  *
*                                                                         *
*                  Java Grande Benchmarking Project                       *
*                                                                         *
*                                at                                       *
*                                                                         *
*                Edinburgh Parallel Computing Centre                      *
*                                                                         *
*                email: epcc-javagrande@epcc.ed.ac.uk                     *
*                                                                         *
*                 Original version of this code by                        *
*            Florian Doyon (Florian.Doyon@sophia.inria.fr)                *
*              and  Wilfried Klauser (wklauser@acm.org)                   *
*                                                                         *
*      This version copyright (c) The University of Edinburgh, 2001.      *
*                         All rights reserved.                            *
*                                                                         *
**************************************************************************/


//package raytracer; 


//import java.util.Vector;
using System.Collections;

public class Scene
{
    public readonly ArrayList lights;
    public readonly ArrayList objects;
    private View view;  
  
    public Scene ()
    {
        this.lights = new ArrayList ();
        this.objects = new ArrayList ();        
    }
  
    public void addLight(Light l)
    {
        this.lights.Add(l);
    }
  
    public void addobject(Primitive object_)
    {
        this.objects.Add(object_);
    }
  
    public void setView(View view)
    {
        this.view = view;
    }
  
    public View getView()
    {
        return this.view;
    }
  
    public Light getLight(int number)
    {
        return (Light) this.lights[number];
    }
  
    public Primitive getobject(int number)
    {
        return (Primitive) objects[number];
    }
  
    public int getLights()
    {
        return this.lights.Count;
    }
  
    public int getobjects()
    {
        return this.objects.Count;
    }
  
    public void setobject(Primitive object_, int pos)
    {
        this.objects[pos] = object_;
    }
}




