/**************************************************************************
*                                                                         *
*         Java Grande Forum Benchmark Suite - Thread Version 1.0          *
*                                                                         *
*                            produced by                                  *
*                                                                         *
*                  Java Grande Benchmarking Project                       *
*                                                                         *
*                                at                                       *
*                                                                         *
*                Edinburgh Parallel Computing Centre                      *
*                                                                         * 
*                email: epcc-javagrande@epcc.ed.ac.uk                     *
*                                                                         *
*                                                                         *
*      This version copyright (c) The University of Edinburgh, 1999.      *
*                         All rights reserved.                            *
*                                                                         *
**************************************************************************/


//package jgfutil;
using System;

public class JGFTimer {

  public string name; 
  public string opname; 
  public double time; 
  public double opcount; 
  public long calls; 
  public int size = -1;
  
  private long start_time;
  private bool on; 

  public JGFTimer(string name, string opname){
    this.name = name;
    this.opname = opname;
    reset_(); 
  }

  public JGFTimer(string name, string opname, int size){
    this.name = name;
    this.opname = opname;
    this.size = size;
    reset_();
  }

  public JGFTimer(string name) : this(name,"") {}



  public void start(){
    if (on) Console.Out.WriteLine("Warning timer " + name + " was already turned on");
    on = true; 
    start_time = Environment.TickCount;
  }


  public void stop(){
    time += (double) (Environment.TickCount-start_time) / 1000.0;
    if (!on) Console.Out.WriteLine("Warning timer " + name + " wasn't turned on");
    calls++;
    on = false;  
  }

  public void addops(double count){
    opcount += count;
  } 

  public void addtime(double added_time){
    time += added_time;
  }

  public void reset_(){
    time = 0.0; 
    calls = 0; 
    opcount = 0; 
    on = false;
  }

  public double perf(){
    return opcount / time; 
  }

  public void longWrite(){
      Console.Out.WriteLine("Timer            Calls         Time(s)       Performance("+opname+"/s)");   
     Console.Out.WriteLine(name + "           " + calls +    "           "  +  time + "        " + this.perf());
  }

  public void Write(){
    if (opname.Equals("")) {
      Console.Out.WriteLine(name + "   " + time + " (s)");
    }
    else {

      switch(size) {
      case 0:
      Console.Out.WriteLine(name + ":SizeA" + "\t" + time + " (s) \t " + (float)this.perf() + "\t"
                        + " ("+opname+"/s)");
      break;
      case 1:
      Console.Out.WriteLine(name + ":SizeB" + "\t" + time + " (s) \t " + (float)this.perf() + "\t"
                        + " ("+opname+"/s)");
      break;
      case 2:
      Console.Out.WriteLine(name + ":SizeC" + "\t" + time + " (s) \t " + (float)this.perf() + "\t"
                        + " ("+opname+"/s)");
      break;
      default:
      Console.Out.WriteLine(name + "\t" + time + " (s) \t " + (float)this.perf() + "\t"
                        + " ("+opname+"/s)");
      break;
      }

    }
  }


  public void Writeperf(){

     string name;
     name = this.name; 

     // pad name to 40 characters
     while ( name.Length < 40 ) name = name + " "; 
     
     Console.Out.WriteLine(name + "\t" + (float)this.perf() + "\t"
			+ " ("+opname+"/s)");  
  }

}
