/**************************************************************************
*                                                                         *
*         Java Grande Forum Benchmark Suite - Thread Version 1.0          *
*                                                                         *
*                            produced by                                  *
*                                                                         *
*                  Java Grande Benchmarking Project                       *
*                                                                         *
*                                at                                       *
*                                                                         *
*                Edinburgh Parallel Computing Centre                      *
*                                                                         * 
*                email: epcc-javagrande@epcc.ed.ac.uk                     *
*                                                                         *
*                                                                         *
*      This version copyright (c) The University of Edinburgh, 1999.      *
*                         All rights reserved.                            *
*                                                                         *
**************************************************************************/


//package jgfutil;

//import java.util.*;
using System;
using System.Collections;
using System.Runtime.CompilerServices;

public class JGFInstrumentor{

  private static Hashtable timers = new Hashtable();
  private static Hashtable data = new Hashtable();

  //  [MethodImpl(MethodImplOptions.Synchronized)]
  public static void addTimer (string name){

    if (timers.ContainsKey(name)) {
      Console.Out.WriteLine("JGFInstrumentor.addTimer: warning -  timer " + name + 
			 " already exists");
    }
    else {
      timers[name] = new JGFTimer(name);
    }
  }
    
  //  [MethodImpl(MethodImplOptions.Synchronized)]
  public static void addTimer (string name, string opname){

    if (timers.ContainsKey(name)) {
      Console.Out.WriteLine("JGFInstrumentor.addTimer: warning -  timer " + name + 
			 " already exists");
    }
    else {
      timers[name] = new JGFTimer(name,opname);
    }
    
  }

  //  [MethodImpl(MethodImplOptions.Synchronized)]
  public static void addTimer (string name, string opname, int size){

    if (timers.ContainsKey(name)) {
      Console.Out.WriteLine("JGFInstrumentor.addTimer: warning -  timer " + name +
                         " already exists");
    }
    else {
      timers[name] = new JGFTimer(name,opname,size);
    }

  }

  //  [MethodImpl(MethodImplOptions.Synchronized)]
  public static void startTimer(string name){
    if (timers.ContainsKey(name)) {
      ((JGFTimer) timers[name]).start();
    }
    else {
      Console.Out.WriteLine("JGFInstrumentor.startTimer: failed -  timer " + name + 
			 " does not exist");
    }

  }

  //  [MethodImpl(MethodImplOptions.Synchronized)]
  public static void stopTimer(string name){
    if (timers.ContainsKey(name)) {
      ((JGFTimer) timers[name]).stop();
    }
    else {
      Console.Out.WriteLine("JGFInstrumentor.stopTimer: failed -  timer " + name + 
			 " does not exist");
    }
  }

  [MethodImpl(MethodImplOptions.Synchronized)]
  public static void addOpsToTimer(string name, double count){
    if (timers.ContainsKey(name)) {
      ((JGFTimer) timers[name]).addops(count);
    }
    else {
      Console.Out.WriteLine("JGFInstrumentor.addOpsToTimer: failed -  timer " + name + 
			 " does not exist");
    }
  }  

  //  [MethodImpl(MethodImplOptions.Synchronized)]
  public static void addTimeToTimer(string name, double added_time){
    if (timers.ContainsKey(name)) {
      ((JGFTimer) timers[name]).addtime(added_time);
    }
    else {
      Console.Out.WriteLine("JGFInstrumentor.addTimeToTimer: failed -  timer " + name +
                         " does not exist");
    }



  }

  //  [MethodImpl(MethodImplOptions.Synchronized)]
  public static double readTimer(string name){
    double time; 
    if (timers.ContainsKey(name)) {
      time = ((JGFTimer) timers[name]).time;
    }
    else {
      Console.Out.WriteLine("JGFInstrumentor.readTimer: failed -  timer " + name + 
			 " does not exist");
       time = 0.0; 
    }
    return time; 
  }  

  //  [MethodImpl(MethodImplOptions.Synchronized)]
  public static void resetTimer(string name){
    if (timers.ContainsKey(name)) {
      ((JGFTimer) timers[name]).reset_();
    }
    else {
      Console.Out.WriteLine("JGFInstrumentor.resetTimer: failed -  timer " + name +
 			 " does not exist");
    }
  }
  
  //  [MethodImpl(MethodImplOptions.Synchronized)]
  public static void WriteTimer(string name){
    if (timers.ContainsKey(name)) {
      ((JGFTimer) timers[name]).Write();
    }
    else {
      Console.Out.WriteLine("JGFInstrumentor.WriteTimer: failed -  timer " + name +
 			 " does not exist");
    }
  }
  
  //  [MethodImpl(MethodImplOptions.Synchronized)]
  public static void WriteperfTimer(string name){
    if (timers.ContainsKey(name)) {
      ((JGFTimer) timers[name]).Writeperf();
    }
    else {
      Console.Out.WriteLine("JGFInstrumentor.WriteTimer: failed -  timer " + name +
 			 " does not exist");
    }
  }

  //  [MethodImpl(MethodImplOptions.Synchronized)]  
  public static void storeData(string name, object obj){
    data[name] = obj; 
  }

  //  [MethodImpl(MethodImplOptions.Synchronized)]
  public static void retrieveData(string name, object obj){
    obj = data[name]; 
  }

  // [MethodImpl(MethodImplOptions.Synchronized)]
  public static void WriteHeader(int section, int size,int nthreads) {

    string header, base_; 
 
    header = "";
    base_ = "Java Grande Forum Thread Benchmark Suite - Version 1.0 - Section "; 
  
    switch (section) {
    case 1: 
      header = base_ + "1";
      break;
    case 2:
      switch (size) {
      case 0:
	header = base_ + "2 - Size A";
	break;
      case 1:
	header = base_ + "2 - Size B";
	break;
      case 2:
	header = base_ + "2 - Size C";
	break;
      }
      break; 
    case 3:    
      switch (size) {
      case 0:
	header = base_ + "3 - Size A";
	break;
      case 1:
	header = base_ + "3 - Size B";
	break;
      }
      break; 
    }

    Console.Out.WriteLine(header); 

    if (nthreads == 1) {
      Console.Out.WriteLine("Executing on " + nthreads + " thread");
    }
    else {
      Console.Out.WriteLine("Executing on " + nthreads + " threads");
    }

    Console.Out.WriteLine("");

  } 

}
