function test( method, data, labeleds, Rs, K, lambda, TestRange, output_period, load_fact )

if nargin < 1  method = 'dtm';              end   % 'dtm' or 'ltm' or 'LapPLSI'
if nargin < 2  data = '20news';             end   % '20news' or 'yahoo' or 'reuters'
if nargin < 3  labeleds = [ 0 1 3 5 10 ];   end   % # of labeled samples in each category. 0 means clustering
if nargin < 4  Rs = [ 10 ];                 end   % reduced dimensionality or # of topics
if nargin < 5  K = 20;                      end   % # of nearest neighbor for favorable relationship
if nargin < 6  lambda = 1000;               end   % balance parameter for LTM and LapPLSI
if nargin < 7  TestRange = 1:20;            end   % test id for repetition
if nargin < 8  output_period = 10;          end   % show intermediate results every this number of iteration. 0 doesn't show intermediate results
if nargin < 9  load_fact = 0;               end   % 0 performs topic modeling, 1 reads the previous results from the file

data_file = sprintf( '%s_cnt', data );
MAX_ITER = 300;

if strcmp( data, '20news' )
    sample = 100;
    classnum = 20;
elseif strcmp( data, 'reuters' ) 
    sample = 100;
    classnum = 20;
elseif strcmp( data, 'yahoo' ) 
    sample = 1;
    classnum = 20;
else
    return;
end

if ~strcmp( method, 'dtm' ) && ~strcmp( method, 'ltm' ) && ~strcmp( method, 'LapPLSI' )
    return;
end

output_folder = sprintf( 'outputs_%s', data );
fact_folder = sprintf( 'facts_%s', data );
if ~exist( output_folder, 'dir' )
    mkdir( output_folder );
end
if ~exist( fact_folder, 'dir' )
    mkdir( fact_folder );
end
if ~exist( 'NNgraphs', 'dir' )
    mkdir( 'NNgraphs' );
end

% load dataset
load( data_file );
classnum_org = classnum; %max( gnd );

pLSA_param.Verbosity = 1;
pLSA_param.Max_Iterations = 100; 
pLSA_param.Min_Likelihood_Change = 1;
options.alpha = lambda;
options.lambda = lambda;
options.nRepeat = 1;
options.maxIter = MAX_ITER;

NumOfTests = length( TestRange );
accsvms = zeros( length(labeleds), NumOfTests );
accknns = zeros( length(labeleds), NumOfTests );

for i = 1 : length( Rs )
    R = Rs( i );

    if strcmp( method, 'dtm' )
        output_file = sprintf( '%s/%s_%d_%d_%d.txt', output_folder, method, K, R, TestRange(1) );
    else
        output_file = sprintf( '%s/%s_%d_%d_%d_%d.txt', output_folder, method, K, lambda, R, TestRange(1) );
    end
    fid = fopen( output_file, 'w' );    
    
    fprintf( 1, 'R = %d, lambda = %d\n', R, lambda );
    tic;
       
    for j = TestRange

        fprintf( 1, '\nTest %d:\n', j );
        rand( 'state', j );        
        [ selected_ids, Y, labeleds_id, unlabeleds_id ] = ...
            choose_samples( gnd, classnum, classnum_org, sample, 10, j );
        %selected_ids = selected_ids(randperm(length(selected_ids)));
        N = length( selected_ids );
        U = fea( :, selected_ids );
        U( sum(U,2) == 0, : ) = [];
        U = get_tfidf( U, 1 );        
        [ W W_ ] = NNgraph( data, K, j, classnum, 'dtm', U, Y, N );  
            % do not change 'dtm' even though another method is tested.
            % Our way to build the neighbor graph is better than the ways introduced for LTM or LapPLSI
        
        if strcmp( method, 'dtm' )
            fact_file = sprintf( '%s/%s_%d_%d_%d', fact_folder, method, K, R, j );                
        else
            fact_file = sprintf( '%s/%s_%d_%d_%d_%d', fact_folder, method, K, lambda, R, j );                
        end
        
        labeled_ids = cell( length(labeleds), 1 );
        unlabeled_ids = cell( length(labeleds), 1 );
        for k = 1 : length(labeleds)
            rand( 'state', j );
            [ selected_ids, Y, labeled_ids{k}, unlabeled_ids{k} ] = ...
                choose_samples( gnd, classnum, classnum_org, sample, labeleds( k ), j );
        end
        
        if ~load_fact
            if strcmp( method, 'dtm' )
                [ X V ] = dtm( U, Y, R, W, W_, lambda, classnum, MAX_ITER, output_period, labeled_ids, unlabeled_ids );
            else
                [Pw_z,Pz_d,Pd,Li,perp,beta] = pLSA(U,[],R,pLSA_param);        
                if strcmp( method, 'ltm' )
                    [ X V ] = ltm(U, Y, R, W, options, Pz_d, Pw_z, classnum, output_period, labeled_ids, unlabeled_ids );
                elseif strcmp( method, 'LapPLSI' )
                    [ X V ] = LapPLSI(U, Y, R, W, options, Pz_d, Pw_z, classnum, output_period, labeled_ids, unlabeled_ids );
                end
            end
            save( fact_file, 'X', 'V' );
        else
            load( fact_file );
        end
        
        residual = compute_residual( U, V, X, U > 0 );
        dist_ratio = compute_distance_ratio( X, diag(sum(W)) - W, diag(sum(W_)) - W_, N );

        fprintf( 'residual: %f, dist_ratio: %f\n', residual, dist_ratio );
        for k = 1 : length(labeleds)
            rand( 'state', j );
            [ selected_ids, Y, labeled_ids, unlabeled_ids ] = ...
                choose_samples( gnd, classnum, classnum_org, sample, labeleds( k ), j );
            
            [ acc1, acc2, acc3, acc4, accval ] = compute_accuracies( X, N, R, Y, labeled_ids, unlabeled_ids, classnum );
            accsvms( k,j ) = acc2;     % svm accuracy or k-means clustering
            accknns( k,j ) = acc4;     % knn accuracy or k-means clustering
            
            fprintf( 'labeld = %d, svm: %0.2f knn: %0.2f validation: %0.2f\n', labeleds(k), acc2, acc4, accval );
            fprintf( fid, '%f %f %f\n', acc2, acc4, accval );
        end
    end   
    
    fprintf( 1, 'R = %3d: ', R );    
    for k = 1 : length(labeleds)
        labeled = labeleds( k );
        if labeled > 0
            fprintf( 1, '%0.1f+-%0.1f/%0.1f+-%0.1f\t', ...
                mean( accsvms(k,:) ), std( accsvms(k,:), 1 ), mean( accknns(k,:) ), std( accknns(k,:), 1 ) );
        else
            fprintf( 1, '%0.1f+-%0.1f/%0.1f+-%0.1f\t', ...
                mean( accsvms(k,:) ), std( accsvms(k,:), 1 ), mean( accknns(k,:) ), std( accknns(k,:), 1 ) );
        end
    end
    fprintf( 1, '\n' );
    
    toc;
    fclose( fid );    
end

