function fea = get_tfidf( fea, normalization_method )

    [nFea,nSmp] = size(fea);
    df = sum(fea > 0, 2)+1;
    idf = log(nSmp./df);
    
    for i = 1:nSmp 
        fea(:,i) = fea(:,i) / sum(fea(:,i));
        fea(:,i) = fea(:,i) .* idf;
    end

    if nSmp > 1000
        for i = 1 : ceil(nSmp/1000)
            range = (i-1)*1000+1:min(i*1000,nSmp);
            if normalization_method == 1
                fea(:,range) = fea(:,range) ./ repmat(sum(fea(:,range)), [size(fea,1) 1] );    
            elseif normalization_method == 2
                fea(:,range) = fea(:,range) ./ repmat(sqrt(sum(fea(:,range).^2)), [size(fea(:,range),1) 1] );
            end    
        end
    else
        if normalization_method == 1
            fea = fea ./ repmat(sum(fea), [size(fea,1) 1] );    
        elseif normalization_method == 2
            fea = fea ./ repmat(sqrt(sum(fea.^2)), [size(fea,1) 1] );        
        end          
    end