function [ selected_ids, Y, labeled_id, unlabeled_id ] ...
            = choose_samples( gnd, classnum, classnum_org, sample, labeled, test_no )

    rand( 'state', test_no );
    randclassids = randperm( classnum_org );
    randclassids = sort( randclassids(1:classnum) );

    rand( 'state', test_no );
    selected_ids = [];
    Y = [];
    labeled_id = [];
    unlabeled_id = [];

    for k = 1 : classnum
        ids = find( gnd == randclassids(k) );
        rand_ids = randperm( length( ids ) );
        if sample > 1
            ids = ids(rand_ids(1:min(sample,end)));
        else
            ids = ids(rand_ids(1:floor(length( ids )*sample)));
        end
        
        len_sofar = length( selected_ids );
        len_add = length( ids );
        selected_ids = [ selected_ids; ids ];        
        Y = [ Y; ones( len_add, 1 ) * k ];
        
        labeled_id = [ labeled_id len_sofar+(1:labeled) ];
        unlabeled_id = [ unlabeled_id len_sofar+(labeled+1:len_add) ];
    end
    
%     if any(gnd==0)
%         ids = find( gnd == 0 );
%         rand_ids = randperm( length( ids ) );
%         ids = ids(rand_ids(1:1000));
%         selected_ids = [ selected_ids; ids ];        
%         Y = [ Y; ones( 1000, 1 )*(classnum+1) ];
%     end
    