function [ W W_ ] = build_NNgraph_dtm( U, Y, K )

    N = length( Y );
    classnum = max( Y );

    W = sparse([],[],[],N,N,N*K*2);
    for i = 1 : N
        nonzero = U(:,i) > 0;
        if sum( nonzero ) > 1
            dist = full( sum( min( U(nonzero,:), repmat( U(nonzero,i), [ 1 N ] ) ) ) )';
        else
            dist = full( min( U(nonzero,:), repmat( U(nonzero,i), [ 1 N ] ) ) )';
        end
        
        [ sortedDist sortedIdx ] = sort( dist, 'descend' );

        W( i, sortedIdx(2:K+1) ) = sortedDist(2:K+1);
        W( sortedIdx(2:K+1), i ) = sortedDist(2:K+1);        
    end
    
    W_ = W * W;
    W_(W > 0) = 0;
    W_(W_> 0) = 1;
    W_(logical(eye(N))) = 0;
    