#include "CollisionPlane.h"
#include <math.h>
#include "Constants.h"

CollisionPlane::CollisionPlane(P3D p, V3D n) {
	pointOnPlane = p;
	normal = n.normalized();
}

bool CollisionPlane::isColliding(P3D p) {
	V3D displacement = p - pointOnPlane;
	double d = displacement.dot(normal);
	return (d < 0);
}

// Compute the tangential direction at a contact point
// along which the frictional impulse will be applied.
V3D CollisionPlane::frictionTangent(Cuboid &c, P3D &p) {
	// TODO: implement me
	return V3D(0, 0, 0);
}

// If the given cuboid is colliding with this plane, then move it
// out of the plane, and apply normal and frictional responses.
void CollisionPlane::applyCollisionResponse(Cuboid &c) {
	// TODO: implement me
}
