#include <GUILib/GLUtils.h>
#include "TestAppFEMSim.h"
#include <GUILib/GLMesh.h>
#include <GUILib/GLContentManager.h>
#include <MathLib/MathLib.h>
#include <MathLib/Plane.h>
#include <FEMSimLib/CSTSimulationMesh2D.h>

//#define EDIT_BOUNDARY_CONDITIONS

TestAppFEMSim::TestAppFEMSim() {
	setWindowTitle("Test FEM Sim Application...");

	TwAddSeparator(mainMenuBar, "sep2", "");

	int nRows = 10;
	int nCols = 2;
	CSTSimulationMesh2D::generateSquareTriMesh("../data/FEM/2d/triMeshTMP.tri2d", -1, 0, 0.1, 0.1, nRows, nCols);

	femMesh = new CSTSimulationMesh2D();
	femMesh->readMeshFromFile("../data/FEM/2d/triMeshTMP.tri2d");
	femMesh->addGravityForces(V3D(0, -9.8, 0));

	//set some boundary conditions...
	for (int i = 0; i < nCols;i++)
		femMesh->setPinnedNode(i, femMesh->nodes[i]->getWorldPosition());

	showGroundPlane = false;

	TwAddVarRW(mainMenuBar, "Static Solve", TW_TYPE_BOOL8, &computeStaticSolution, "");
	TwAddVarRW(mainMenuBar, "checkDerivatives", TW_TYPE_BOOL8, &checkDerivatives, "");

}

TestAppFEMSim::~TestAppFEMSim(void){
}

//triggered when mouse moves
bool TestAppFEMSim::onMouseMoveEvent(double xPos, double yPos) {
	lastClickedRay = getRayFromScreenCoords(xPos, yPos);

	currentRay = getRayFromScreenCoords(xPos, yPos);
	if (selectedNodeID != -1){
		Plane plane(camera->getCameraTarget(), V3D(camera->getCameraPosition(), camera->getCameraTarget()).unit());
		P3D targetPinPos; getRayFromScreenCoords(xPos, yPos).getDistanceToPlane(plane, &targetPinPos);
		femMesh->setPinnedNode(selectedNodeID, targetPinPos);
		return true;
	}
	else if (GLApplication::onMouseMoveEvent(xPos, yPos) == true) return true;
	return false;
}

//triggered when mouse buttons are pressed
bool TestAppFEMSim::onMouseButtonEvent(int button, int action, int mods, double xPos, double yPos) {

	if (GLApplication::onMouseButtonEvent(button, action, mods, xPos, yPos)) return true;

	return false;
}

//triggered when using the mouse wheel
bool TestAppFEMSim::onMouseWheelScrollEvent(double xOffset, double yOffset) {
	if (GLApplication::onMouseWheelScrollEvent(xOffset, yOffset)) return true;

	return false;
}

bool TestAppFEMSim::onKeyEvent(int key, int action, int mods) {
	if (GLApplication::onKeyEvent(key, action, mods)) return true;

	return false;
}

bool TestAppFEMSim::onCharacterPressedEvent(int key, int mods) {
	if (GLApplication::onCharacterPressedEvent(key, mods)) return true;

	return false;
}


void TestAppFEMSim::loadFile(const char* fName) {
	Logger::consolePrint("Loading file \'%s\'...\n", fName);
}

void TestAppFEMSim::saveFile(const char* fName) {
	Logger::consolePrint("SAVE FILE: Do not know what to do with file \'%s\'\n", fName);
}


// Run the App tasks
void TestAppFEMSim::process() {
	//do the work here...

	double simulationTime = 0;
	double maxRunningTime = 1.0 / desiredFrameRate;
	femMesh->checkDerivatives = checkDerivatives != 0;

	//if we still have time during this frame, or if we need to finish the physics step, do this until the simulation time reaches the desired value
	while (simulationTime < 1.0 * maxRunningTime) {
		simulationTime += simTimeStep;
		if (computeStaticSolution)
			femMesh->solve_statics();
		else {
			femMesh->solve_dynamics(simTimeStep);
		}
	}
}

// Draw the App scene - camera transformations, lighting, shadows, reflections, etc apply to everything drawn by this method
void TestAppFEMSim::drawScene() {
	glDisable(GL_TEXTURE_2D);
	glDisable(GL_LIGHTING);
	glColor3d(1,1,1);
	femMesh->drawSimulationMesh();
}

// This is the wild west of drawing - things that want to ignore depth buffer, camera transformations, etc. Not pretty, quite hacky, but flexible. Individual apps should be careful with implementing this method. It always gets called right at the end of the draw function
void TestAppFEMSim::drawAuxiliarySceneInfo() {

}

// Restart the application.
void TestAppFEMSim::restart() {

}

bool TestAppFEMSim::processCommandLine(const std::string& cmdLine) {

	if (GLApplication::processCommandLine(cmdLine)) return true;

	return false;
}

