import java.util.*;
 
/**
 *  Given a board this class returns the index of the database where the
 *  result can be found.
 */


public class Index{
  
    /**
     * Given a CheckerBoard, the index for querying the database is computed
     * and returned.  The index is an int.
     * 
     */
   
    public  static int GetIndex(CheckerBoard board){
	/**
	   This class does stuff 
	*/

	ArrayList positions;
	int index;
	
	/* extract info from the board */
	/* we assume that the player is the one we are interested in */
	
	positions = ExtractInfo(board);

	index = GetIndex(board, positions);
	return 2*index;

    }


    /**
     * The "Real" GetIndex method.  It uses the ArrayList of the 
     * positions of the pieces on the board.
     *  
     */
    private static int GetIndex(CheckerBoard b, ArrayList a){
	String number = new String();
	int count =0;
       
	
	if(a.size() == 2){
	    number = "1";
	}
	else{
	   
	    for(int i=0;i<a.size();i++){
		if(b.Piece(((Integer)a.get(i)).intValue()) == 'p' ||
		   b.Piece(((Integer)a.get(i)).intValue()) == 'P'){
		    count = count+1;
		}
	    }
	

	if(count == 1){number = "01";}
	else{
	    if(count == 2) {number = "10";}
	    else{ 
		if(count == 3){number = "11";}
		else{System.err.println("Problem");}
	    }
	}
	}
    
	/* Now process kings */
	for(int i=0;i<a.size();i++){
	    if(b.Piece(((Integer)a.get(i)).intValue()) == 'P' ||
	       b.Piece(((Integer)a.get(i)).intValue()) == 'O'){
		number = number+"1";
	    }
	    else{
		number = number+"0";
	    }

	}

	/* now process the positions.  They must be 5 bits each so
	   some padding may be required.
	*/

	for(int i =0;i<a.size();i++){
	    String s = new String();
	    s=Integer.toBinaryString(((Integer)a.get(i)).intValue());
	    while(s.length()<5){
		s="0"+s;
	    }
	    number=number+s;
	}

	return Integer.parseInt(number,2);

	
    }

    /**
     * Method for getting the positions of the pieces in the
     * correct order (player before opponent)
     *
     */
    private static ArrayList ExtractInfo(CheckerBoard b){
	ArrayList p = new ArrayList();
	Integer x;

	for(int i=0;i<32;i++){
	    if(b.Piece(i)=='p' || b.Piece(i)=='P'){
		x = new Integer(i);
		p.add(x);
	      
	    }
	}


	for(int i = 0;i<32;i++){
	    if(b.Piece(i)=='o' || b.Piece(i)=='O'){
		x = new Integer(i);
		p.add(x);
	    }
	}

	return p;
    }

    /**
     * Given a CheckerBoard, the number of pieces on the board is
     * returned.
     *
    */
    
    public static int PieceCount(CheckerBoard b){
	int pcount = 0;

	for(int i=0;i<32;i++){
	    if(b.Piece(i)!='e'){
		pcount = pcount+1;
	    }
	}
	return pcount;
    }


}
