import java.util.*;
import java.io.*;
/**
   This class handles the endgame database loading and querying.
   There are three private fields, one for each endgame database.
*/

public class EndGame{
    private BitSet database2;
    private BitSet database3;
    private BitSet database4;


    EndGame(){
	this.database2 = new BitSet();
	this.database3 = new BitSet();
	this.database4 = new BitSet();

    }

    /**
     * This loads all three endgame databases.
     * The parameters np1, np2, and np3 must all be different and must be
     * either 2, 3 or 4.  If incorrect values are given, the method returns false
     * and does not load any database.
     *
    */
    public boolean LoadDB(int np1,int np2,int  np3){
	
	boolean foo = false;
	if((np1==2 || np1==3 || np1==4)&&
	   (np2==2||np2==3 || np2==4)&&
	   (np3==2||np3==3|| np3==4)&&
	   (np1!=np2 || np1!=np3 ||np2!=np3)){
	    foo = true;
	}
	boolean x =LoadDB(np1);
	x = LoadDB(np2);
	x = LoadDB(np3);

	return foo;
	
    }
    /**
       This loads any two endgame databases specified by np1 and np2.
       * np1 and np23 must be either 2, 3 or 4 and must be different.
       * Otherwise no databases are loaded and false is returned.
       */

    public boolean LoadDB(int np1, int np2){

	boolean foo = false;
	if( (np1==2 ||np1 ==3 || np1 ==4)&&
	    (np2==2 || np2==3 || np2 ==4)&&
	    (np1!=np2)){
	    foo=true;
	}
	boolean x = LoadDB(np1);
	x = LoadDB(np2);
	return foo;

    }
    /**
     * This loads the databse specified by np1.
     * np1 must be 2, 3 or 4 (number of pieces in the database to be loaded).
     * If np1 is not 2, 3 or 4 then no database is loaded and false is returned.
     * We assume that the databases are  files
     * /afs/andrew/course/15/381/hw2/databases/simple_2.db
     * /afs/andrew/course/15/381/hw2/databases/simple_3.db
     * /afs/andrew/course/15-381/hw2/databases/simple_4.db
     * If you have moved these databases to a local copy then you
     * must change the code accordingly.
     */  
    public boolean LoadDB(int np1){
	String s = new String();
	s = "/afs/andrew/course/15/381/hw2/databases/";
	boolean foo = false;
	if(np1==2 ||np1==3 ||np1 ==4){
	    foo = true;
	}
	if(np1 ==2){
	    /* you might have to change the file */
	    File f = new File(s+"simple_2.db");
	    try{
	    byte[] bytes = getBytesFromFile(f);
	    this.database2 = fromByteArray(bytes);
	    }
	    catch(Exception e){
		System.err.println(e);
	    }
	   
	}
	else{ 
	    if(np1 ==3){
	    /* Load 3 piece database */
		/* you might have to change the file */
		File f = new File(s+"simple_3.db");
		try{
		    byte[] bytes = getBytesFromFile(f);
		    this.database3 = fromByteArray(bytes);
		}
		catch(Exception e){
		    System.err.println(e);
		}
	    }
	    else{ /* Load 4 piece database */
		/* You might have to change the file.*/
	        
		File f = new File(s+"simple_4.db");
		try{
		    byte[] bytes = getBytesFromFile(f);
		    this.database4 = fromByteArray(bytes);
		}
		catch(Exception e){
		    System.err.println(e);
		}
	    }
	}
    
	

	return foo;
    }


    /**
     * Reads the binary database file into a byte array
     */

    private static byte[] getBytesFromFile(File file) throws IOException{
	InputStream is = new FileInputStream(file);
	long length = file.length();
	if(length>Integer.MAX_VALUE){
	    //file is too long 
	    System.out.println("BAD, very bad");
	}
	   byte[] bytes = new byte[(int)length];

	   // read in bytes
	   int offset = 0;
	   int numRead = 0;
	   while(offset<bytes.length &&
		 (numRead = is.read(bytes, offset, bytes.length - offset))>=0){
	       offset = offset+numRead;
	   }

	   // check all bytes have been read in
	   if(offset<bytes.length){
	throw new IOException("Could not completely read file" + file.getName());
    }

    //  close input stream and return bytes
    is.close();
    return bytes;

    }
    /**
     * Converts the byte array into an easier to query bitset.
     */
private static BitSet fromByteArray(byte[] bytes){
    BitSet bits = new BitSet();
    
    for(int i = 0;i<bytes.length*8;i++){
	if((bytes[i/8]&(1<<i%8))>0){
	    bits.set(i);
	}
    }
    return bits;
}

    /**
     * Given a CheckerBoard, the appropriate endgame database is queried
     * and the result of the query is returned.
     * The int returned is either
     * 
     * @return 0 if a WIN,
     *  1 if a LOSS,
     *  2 if a DRAW,
     *  3 if INVALID,
     * -1 if not a valid query -- too many or too few pieces
     */

    public int Query(CheckerBoard b){
	
	int whichDB = Index.PieceCount(b);
	int index = Index.GetIndex(b);
	int query = -1;
	/**
	   Now query the database
	   return 
	        0 if WIN
		1 if LOSE
		2 if DRAW
		3 if INVALID
		4 not a valid query:  too many pieces
	*/

	if (whichDB==2){

	    if(!this.database2.get(index) && !this.database2.get(index+1)){
		query = 0; /* WIN */
	    }
	     else{
		 if(this.database2.get(index)&&!this.database2.get(index+1)) {
		     query = 1; /* LOSE */
		 }
		 else{
		     if(!this.database2.get(index)&&this.database2.get(index+1)){
			 query = 2; /* DRAW */
			     }
		     else{
			 if(this.database2.get(index)&&this.database2.get(index+1)){
			     query = 3; /* INVALID */
			 }
		     }
		 }
	     }

	}

	else{ 
	    if(whichDB == 3){

		if(!this.database3.get(index) && !this.database3.get(index+1)){
		    query = 0; /* WIN */
		}
		else{
		    if(this.database3.get(index)&&!this.database3.get(index+1)) {
			query = 1; /* LOSE */
		    }
		    else{
			if(!this.database3.get(index)&&this.database3.get(index+1)){
			    query = 2; /* DRAW */
			     }
			else{
			    if(this.database3.get(index)&&this.database3.get(index+1)){
				query = 3; /* INVALID */
			    }
			}
		    }
		}

	    }
	    else{ if(whichDB==4){

		if(!this.database4.get(index) && !this.database4.get(index+1)){
		    query = 0; /* WIN */
		}
		else{
		    if(this.database4.get(index)&&!this.database4.get(index+1)) {
			query = 1; /* LOSE */
		    }
		    else{
			if(!this.database4.get(index)&&this.database4.get(index+1)){
			    query = 2; /* DRAW */
				}
			else{
			    if(this.database4.get(index)&&this.database4.get(index+1)){
				query = 3; /* INVALID */
			    }
			}
		    }
		}

	    }
	    else{ query = -1; /* not a valid query */}
	    }
	}
	return query;
    }

    
}
