/*
 *Header:
 *File: typedefs.h 
 *Author: Noda Itsuki
 *Date: 1995/02/24
 *EndHeader:
 */

/*
 *ModifyHistory
 *
 *EndModifyHistory
 */

typedef double Value ;
typedef int ID ;
typedef int TheNumber ;
typedef char* Name ;
typedef int Logical ;

#define NULLCHAR	'\000'

/*
class Angle : public double {} ;
*/
typedef double Angle ;

#define TRUE 1 
#define FALSE 0 
#define	True 1
#define False 0

#define	DISABLE			0x0000
#define	STAND			0x0001
#define	KICK			0x0002
#define KICK_FAULT		0x0004
#define	GOALIE			0x0008
#define CATCH			0x0010
#define CATCH_FAULT		0x0020
#define BALL_TO_PLAYER	0x0040
#define PLAYER_TO_BALL	0x0080
#define DISCARD			0x0100

typedef int	Side ;
#define LEFT	1
#define NEUTRAL	0
#define RIGHT 	-1

#define PLAYMODE_STRINGS {"",\
			"before_kick_off",\
			"time_over",\
			"play_on",\
			"kick_off_l",\
			"kick_off_r",\
			"kick_in_l",\
			"kick_in_r",\
			"free_kick_l",\
			"free_kick_r",\
			"corner_kick_l",\
			"corner_kick_r",\
			"goal_kick_l",\
			"goal_kick_r",\
			"goal_l",\
			"goal_r",\
			"drop_ball",\
			"offside_l",\
			"offside_r",\
		}

typedef enum _PlayMode {
	PM_Null,
	PM_BeforeKickOff,
	PM_TimeOver,
	PM_PlayOn,
	PM_KickOff_Left,
	PM_KickOff_Right,
	PM_KickIn_Left,
	PM_KickIn_Right,
	PM_FreeKick_Left,
	PM_FreeKick_Right,
	PM_CornerKick_Left,
	PM_CornerKick_Right,
	PM_GoalKick_Left,
	PM_GoalKick_Right,
	PM_AfterGoal_Left,
	PM_AfterGoal_Right,
	PM_Drop_Ball,
	PM_OffSide_Left,
	PM_OffSide_Right,
	PM_MAX 
} PlayMode ;

typedef enum _MPObjectType {
	MPO_Ball,
	MPO_Player,
} MPObjectType ;

#define Zero 0.0e0

#define	COLOR_NAME_MAX	64

typedef struct {
	short	enable ;
	short	side ;
	short	unum ;
	short	angle ;
	short	x ;
	short	y ;
} pos_t ;

typedef struct {
	char	name[16] ;
	short	score ;
} team_t ;

typedef struct {
	char	pmode ;
	team_t	team[2] ;
	pos_t	pos[MAX_PLAYER * 2 + 1] ;
	short	time ;
} showinfo_t ;

typedef	struct {
	short	board ;
	char	message[2048] ;
} msginfo_t ;

typedef struct {
	short	x ;
	short	y ;
	char	color[COLOR_NAME_MAX] ;
} pointinfo_t ;

typedef struct {
	short	x ;
	short	y ;
	short	r ;
	char	color[COLOR_NAME_MAX] ;
} circleinfo_t ;
	
typedef struct {
	short	x1 ;
	short	y1 ;
	short	x2 ;
	short	y2 ;
	char	color[COLOR_NAME_MAX] ;
} lineinfo_t ;

typedef struct {
	short mode ;
	union {
		pointinfo_t		pinfo ;
		circleinfo_t	cinfo ;
		lineinfo_t		linfo ;
	} object ;
} drawinfo_t ;

typedef struct {
	short	mode ;
	union {
		showinfo_t	show ;
		msginfo_t	msg ;
		drawinfo_t	draw ;
	} body ;
} dispinfo_t ;

typedef struct displist {
	unsigned long	shost ;
	int				sport ;
	struct displist *next ;
} displist_t ;

typedef struct {
	char	optname[32] ;
	void	*vptr ;
	int		vsize ;
} option_t ;

#define	V_INT		1
#define	V_DOUBLE	2
#define	V_BOOL		3
#define	V_STRING	4
#define	V_ONOFF		5
#define V_NONE		6
