/* -*- Mode: C -*-
 *Header:
 *File: logplayer.C
 *Author: Noda Itsuki
 *Date: 1996/11/28
 *EndHeader:
 */

#include <stdlib.h>
#include <stdio.h>
#include <math.h>
#include <signal.h>
#include <strstream.h>
#include <strings.h>
#include <sys/types.h>
#include <sys/time.h>

#include "param.h"
#include "types.h"
#include "logplayer.h"

#define BUF_MAX		64
#define PROMPT		"LogPlayer=> "

extern Player *Play ;

void nw_Signalhandler(void) ;

void Player::nw_Init(void)
{
	struct timeval wait ;

	printf("Wait for monitor.\n") ;

	for ( ; ; ) {
		wait.tv_sec = 0 ;
		wait.tv_usec = 250000 ;
		select(0, NULL, NULL, NULL, &wait) ;
		port.recv_info() ;
		if (!strcmp(port.rbuf, "(dispinit)")) {
			state = STATE_STOP ;
			printf("LogPlayer is started.\n\n") ;
			break ;
		}
	}
}

void Player::nw_TimerInit(void)
{
	struct sigaction alarm_action ;
	struct itimerval itv ;

	rect = 0 ;
	sent = 0 ;

	itv.it_interval.tv_sec = 0 ;
	itv.it_interval.tv_usec = TIMEDELTA * 1000 ;
	itv.it_value.tv_sec = 0 ;
	itv.it_value.tv_usec = TIMEDELTA * 1000 ;

	alarm_action.sa_handler = (void (*)(...))nw_Signalhandler ;
	alarm_action.sa_flags &= (~SA_RESETHAND) ;
	sigaction(SIGALRM, &alarm_action, NULL) ;
	setitimer(ITIMER_REAL, &itv, NULL) ;
}
	
void Player::nw_Loop(void)
{
	char prompt[BUF_MAX] ;
	char buf[BUF_MAX] ;
	char com[BUF_MAX] ;
	char arg[3][BUF_MAX] ;
	int n ;
	int stdin_flag = FALSE ;

	bzero(buf, sizeof(buf)) ;
	strcpy(prompt, PROMPT) ;

	if (com_file[0] == '\0')
		stdin_flag = TRUE ;

	for ( ; ; ) {
		if (stdin_flag) {
			fputs(prompt, stdout) ; 
			fgets(buf, BUF_MAX, stdin) ;
		}
		else { 
			if (fgets(buf, BUF_MAX, comfp) == NULL) {
				stdin_flag = TRUE ;
				continue ;
			}
			if (buf[0] == '#' || buf[0] == '\n')
				continue ;
		}

		if (sscanf(buf, "%s", com) < 1) {
			cerr << "Error:" << buf << endl ;
			continue ;
		}

		if (!strcmp(com, "quit")) {
			if (!stdin_flag)
				cout << buf << endl ;
			break ;
		}
		else if (!strcmp(com, "play")) {
			int tmp ;
			int from, to ;

			n = sscanf(buf, "%s %s %s %s", com, arg[0], arg[1], arg[2]) ;
			if (n == 4 && !strcmp(arg[1], "to")) {
				if (sscanf(arg[0], "%d", &tmp) == 1)
					from = tmp ;
				else if (!strcmp(arg[0], "end"))
					from = END ;
				else if (!strcmp(arg[0], "here"))
					from = current ;
				else {
					cerr << "Error:" << buf << endl ;
					continue ;
				}

				if (sscanf(arg[2], "%d", &tmp) == 1)
					to = tmp ;
				else if (!strcmp(arg[2], "end"))
					to = END ;
				else if (!strcmp(arg[2], "here"))
					to = current ;
				else {
					cerr << "Error:" << buf << endl ;
					continue ;
				}
			}
			else {
				cerr << "Error:" << buf << endl ;
				continue ;
			}

			if (from == to) {
				cerr << "Can't play. (from = to)" << endl ;
				continue ;
			}

			if (from != current) {
				to_time = from ;
				jump() ;
				if (state == STATE_NOT_JUMP) {
					cerr << "Can't play. (can't go to" 
						 << to_time << ")" << endl ;
					state = STATE_STOP ;
					continue ;
				}
			}
			if (!stdin_flag)
				cout << buf << endl ;

			to_time = to ;
			limit = PLAY_CYCLE ;
			if (to > current)
				nw_Play() ;
			else if (to < current)
				nw_Rewind() ;
		}
		else if (!strcmp(com, "jump") ||
				 !strcmp(com, "feed") ||
				 !strcmp(com, "step") ) {
			int tmp ;
			n = sscanf(buf, "%s %s %s", com, arg[0], arg[1]) ;
			if (n == 3 && !strcmp(arg[0], "to")) {
				if (sscanf(arg[1], "%d", &tmp) == 1)
					to_time = tmp ;
				else if (!strcmp(arg[1], "end"))
					to_time = END ;
				else { 
					cerr << "Error:" << buf << endl ;
					continue ;
				}
			}
			else if (n == 2 && sscanf(arg[0], "%d", &tmp) == 1)
				to_time = current + tmp ;
			else {
				cerr << "Error:" << buf << endl ;
				continue ;
			}

			if (to_time == current) {
				cerr << "Can't go to current time. Current time: "
					 << to_time << endl ;
				continue ;
			}

			if (!stdin_flag)
				cout << buf << endl ;

			if (!strcmp(com, "jump")) {
				jump() ;
				if (state == STATE_NOT_JUMP) {
					cerr << "Can't jump to " << to_time << "." << endl ;
					continue ;
					state = STATE_STOP ;
				}
			}
			else {
				if (!strcmp(com, "feed"))
					limit = FEED_CYCLE ;
				else
					limit = STEP_CYCLE ;
				if (to_time > current)
					nw_Play() ;
				else if (to_time < current)
					nw_Rewind() ;
			}
		}	
		else if (!strcmp(com, "sleep")) {
			unsigned wait_time = 0;
			char tmp[BUF_MAX] ;
			if (sscanf(buf, "%s %d",com, &wait_time) == 2) {
				if (!stdin_flag)
					cout << buf << endl ;
				limit = wait_time ;
				nw_Sleep() ;
			}
			else if (sscanf(buf, "%s %s",com, tmp) == 2 &&
											!strcmp(tmp, "forever") ) {
					if (!stdin_flag)
						stdin_flag = TRUE ;
			}
			else
				cerr << "Error:" << buf << endl ;
		}
		else
			cerr << "Error:" << buf << endl ;
	}
}

void Player::nw_Play(void)
{
	state = STATE_PLAY ;
	sent = 0 ;

	for ( ; ; ) {
		sigpause(SIGUSR1) ;
		sent += TIMEDELTA ;
		if (sent > limit) {
			read_file() ;
			if (state == STATE_STOP)
				break ;
			sent = 0 ;
		}
	}
}

void Player::nw_Rewind(void)
{
	state = STATE_REVERSE ;
	sent = 0 ;

	for ( ; ; ) {
		sigpause(SIGUSR1) ;
		sent += TIMEDELTA ;
		if (sent > limit) {
			rewind_file() ;
			if (state == STATE_STOP)
				break ;
			sent = 0 ;
		}
	}
}

void Player::nw_Sleep(void)
{
	int wait ;

	sent = 0 ;
 	wait = limit * 1000 ;

	for ( ; ; ) {
		sigpause(SIGUSR1) ;
		sent += TIMEDELTA ;
		if (sent > wait)
			break ;
	}
}

void Player::nw_Quit(void)
{
	fclose(infp) ;
	if (out_file[0] != '\0')
		fclose(outfp) ;
	if (com_file[0] != '\0')
		fclose(comfp) ;
	exit(1) ;
}

void nw_Signalhandler(void)
{
	Play->rect += TIMEDELTA ;
	if (Play->rect > 500) {
		Play->port.recv_info() ;
		Play->rect = 0 ;
	}
}
