/*
 *Header:
 *File: netif.h (for C++)
 *Author: Noda Itsuki
 *Date: 1996/12/1
 *EndHeader:
 */

#ifdef	Solaris
#include <sys/filio.h>
#define bzero(a, b) memset(a, 0, b)
#else
#include <sys/ioctl.h>
#endif
#include <unistd.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <netdb.h>
#include <fcntl.h>
#include <sys/socket.h>

/*
 *===================================================================
 *Part: Port class
 *===================================================================
 */
class Port {
	public: 
		int					socketfd ;			/* socket discriptor */
		char				host[256] ;
		int					portnum ;
		struct sockaddr_in	monitor_addr ;		/* monitor addr structure */
		char				rbuf[256] ;			/* recv buffer */
		displist_t			top ;

		void	init(void) ;	
		void	send_info(dispinfo_t *, unsigned long host, int port) ;
		int		recv_info(void) ;
		void	monitor_init(void) ;
} ;
