/* -*- Mode: C -*-
 *Header:
 *File: netif.C (for C++ & cc)
 *Author: Noda Itsuki
 *Date: 1996/02/14
 *EndHeader:
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#ifdef SYSV
#ifndef Solaris
#include <strings.h>
#endif
#endif
#include <unistd.h>
#include <sys/types.h>
#include <sys/socket.h>
#ifdef Solaris
#include <sys/filio.h>
#else
#include <sys/ioctl.h>
#endif
#include <netinet/in.h>
#include <arpa/inet.h>
#include <netdb.h>
#include <errno.h>
#include <math.h>
#include <fcntl.h>

#include <iostream.h>
#include <strstream.h>

#include "param.h"
#include "types.h"
#include "logplayer.h"


/*
 *===================================================================
 *  UDP Send
 *===================================================================
 */

void Port::init(void)
{
	struct sockaddr_in	my_addr ;
	int one ;

	strcpy(host, "localhost") ;

	/* open UDP socket */
	if ((socketfd = socket(AF_INET, SOCK_DGRAM, 0)) < 0) {
		cerr << "can't open socket." << endl ;
		exit(-1) ;
	}

	/* set non-blocking */
	one = 1 ;
	if (ioctl(socketfd, FIONBIO, &one) < 0) {
		cerr << "can't ioctl on socket." << endl ;
		exit(-1) ;
	}

	/* bind local address */
	bzero((char *) &my_addr, sizeof(my_addr)) ;
	my_addr.sin_family			= AF_INET ;
	my_addr.sin_addr.s_addr		= htonl(INADDR_ANY) ;
	my_addr.sin_port			= htons(portnum) ;

	if (bind(socketfd, (struct sockaddr *)&my_addr, sizeof(my_addr)) < 0) {
		cerr << "can't bind local address." << endl ;
		exit(-1) ;
	}

	bzero((char *)&monitor_addr, sizeof(monitor_addr)) ;
	monitor_addr.sin_family		= AF_INET ;

	top.next = NULL ;
}

void Port::send_info(dispinfo_t *msg, unsigned long host, int port)
{
	struct sockaddr_in cli_addr ;
	int n ;

	bzero((char *) &cli_addr, sizeof(cli_addr)) ;
	cli_addr.sin_family			= AF_INET ;
	cli_addr.sin_addr.s_addr	= htonl(host) ;
	cli_addr.sin_port			= htons(port) ;

	n = sizeof(dispinfo_t) ;
	if(sendto(socketfd, (char *)msg, n, 0,
					(struct sockaddr *) &cli_addr, sizeof(cli_addr)) != n){
#ifdef DEBUG
		cerr << "sendto error on socket." << endl ;
#endif
	}
}

int Port::recv_info(void)
{
	int n, len ;

	bzero(rbuf, 256) ;

	len = sizeof(monitor_addr) ;
	n = recvfrom(socketfd, (char *)&rbuf, sizeof(rbuf), 0, 
					(struct sockaddr *)&monitor_addr, &len) ;

	if (!strcmp(rbuf, "(dispinit)")) {
		displist_t *p ;
		unsigned long host = ntohl(monitor_addr.sin_addr.s_addr) ;
		int port = ntohs(monitor_addr.sin_port) ;

		for (p = &top; p->next != NULL; p = p->next) ;

		p->next = (displist_t *)malloc(sizeof(displist_t)) ;
		if (p->next == NULL) {
			perror("malloc") ;
			exit(1) ;
		}
		p->next->shost = host ;
		p->next->sport = port ;
		p->next->next = NULL ;
	}

	return n ;
}
