/*
 *Header:
 *File: logplayer.h (for C++)
 *Author: Noda Itsuki
 *Date: 1996/11/28
 *EndHeader:
 */

#include "stdio.h"
#include "netif.h"
#include <X11/Intrinsic.h>

#define PLAY_CYCLE		150 		/* [msec] */
#define FEED_CYCLE		50
#define STEP_CYCLE		450

#define STATE_WAIT		-1
#define STATE_STOP		0
#define STATE_PLAY		1
#define STATE_REVERSE	2	
#define STATE_REW		3
#define STATE_FOR		4
#define STATE_PLUS		5
#define STATE_MINUS		6
#define STATE_BLANK		7
#define STATE_JUMP		8
#define STATE_NOT_JUMP	9

#define	REC_OFF		0
#define	REC_ON		1

#define END			-1
#define FOREVER		-2
#define NONE		-3


struct LogLineInfo  {
  int time_t;
  int time_s;
  int level;
  char* msg;
};
#define MAX_LOG_LINE_SIZE 200

// added 16.04.98
// logfile format versions
#define MAX_SHOWINFO	10000

/*
 *===================================================================
 *Part: Controler Class
 *===================================================================
 */
class Controler {
	public:
		XtAppContext	app_context ;			/* application context */
		Widget			top ;					/* top widget */
		Widget			main ;					/* main widget */
		Widget			status ;				/* status widget */
		Widget			buttons ;				/* buttons widget */
		Widget			time ;					/* time widget */
		Widget			quit ;
		Widget			rew ;
		Widget			rev ;
		Widget			minus ;
		Widget			stop ;
		Widget			plus ;
		Widget			play ;
		Widget			ff ;
		Widget			record_buttons ;		/* record buttons widget */
		Widget			rec ;					/* record button widget */
		Widget			blank ;					/* record button widget */
		Widget			jump ;
		Widget			input ;
		Widget			go ;
		Widget			speed ;
		/* Pat added this! */
		Widget                  al_level_plus;
		Widget                  al_level_minus;
		Widget                  al_level_max;
		Widget                  al_level_min;
		Widget                  al_player_plus;
		Widget                  al_player_minus;
		/* end Pat added this */

		void			init(int argc, char **argv) ;
		void			assign(void) ;
		void			display_time(int) ;
		void			display_status(void) ;
		void			change_recmode(void) ;
		void			buttons_reset(void) ;
		void			rew_button_reset_true(void) ;
		void			rew_button_reset_false(void) ;
		void			rev_button_reset_true(void) ;
		void			rev_button_reset_false(void) ;
		void			minus_button_reset(void) ;
		void			stop_button_reset_true(void) ;
		void			stop_button_reset_false(void) ;
		void			plus_button_reset(void) ;
		void			play_button_reset_true(void) ;
		void			play_button_reset_false(void) ;
		void			for_button_reset_true(void) ;
		void			for_button_reset_false(void) ;
		void			blank_button_reset(void) ;
		/* Pat added this! */
		void                    al_level_plus_button_reset(void);
		void                    al_level_minus_button_reset(void);
		void                    al_level_max_button_reset(void);
		void                    al_level_min_button_reset(void);
		void                    al_player_plus_button_reset(void);
		void                    al_player_minus_button_reset(void);
		/* end Pat added this */
		void			Loop(void) ;
} ;



/*
 *===================================================================
 *Part: Player Class
 *===================================================================
 */
class Player {
	public:
		Player();
		~Player();
		char			in_file[MAX_FILE_LEN] ;	/* input file name */
		char			out_file[MAX_FILE_LEN] ;	/* output file name */
		char			com_file[MAX_FILE_LEN] ;	/* command file name */
		FILE			*infp ;						/* input file pointer */
		FILE			*outfp ;					/* output file pointer */
		FILE			*comfp ;					/* command file pointer */
		int				send_st ;					/* udp send step interval */
		int				sent ;						/* send counter timer */
		int				rect ;						/* recv counter timer */
		int				limit ;						/* loop time */
		int				state ;						/* status */
		int				current ;					/* current time */
		int				to_time ;					/* jump to [to_time] */
		int				rec_state ;					/* recording state */
		int				no_window ;					/* no window? */
		Port			port ;						/* communication port */
		Controler*		controler ;					/* controler interface */
		/* Pat added this! */
		int                     team_size;
		int                     show_action_logs;
		char                    action_logs_dir[MAX_FILE_LEN];		
		
		FILE*                  curr_action_log_fp;
		int                    curr_action_log_player;
		
		int                    al_player;
		int                    al_level;

		int MoveLogToTime(int time);
		LogLineInfo ProcessLine(char* line);
		  
		/* end Pat added this */


#ifndef X11R5
		XtSignalId		sig_id ;					/* signal handler id */
#endif


		void			init(int argc, char **argv) ;
		void			timer_init(void) ;
		void			GetOption(int argc, char **argv) ;
		void			read_file(void) ;
		void			rewind_file(void) ;
		void			jump(void) ;
		void			send_blank(void) ;
		void			Quit(void) ;
		void			nw_Init(void) ;
		void			nw_TimerInit(void) ;
		void			nw_Loop(void) ;
		void			nw_Quit(void) ;
		void			nw_Play(void) ;
		void			nw_Rewind(void) ;
		void			nw_Sleep(void) ;

		// added 16.04.98
		int				ReadLog(void);
		void			WriteLog(void);
		void			SendLog(void);
		void			RewindLog(void);
		void			StopLog(void);
		void			OpenForRead(char* in_file);
		void			OpenForWrite(char* out_file);

		void                    DisplayActionLog(void); 
		
	private:
		void			NewShowinfo(long pos);

		int				m_iMaxPos;			/* top position read from file */
		long*			m_plFilePos;		/* positions of showinfo in file */
		int				m_iVersion;			/* version of the file format */
		int				m_bReadShowInfo;	/* true,if showinfo has been read */
		dispinfo_t		m_tBuf;				/* buffer for dispinof */
} ;
