/* -*- Mode: C++ -*-
 *Header:
 *File: window.C
 *Auther: Noda Itsuki
 *Date: 1996/12/1
 *EndHeader:
 */
#include <math.h>
#include <stdio.h>
#include <stdlib.h>
#include <iostream.h>

#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Xaw/Command.h>
#include <X11/Xaw/Form.h>
#include <X11/Xaw/Toggle.h>
#include <X11/Xaw/AsciiText.h>
#include <X11/Xaw/Scrollbar.h>
#include <X11/Shell.h>

#include "param.h"
#include "types.h"
#include "logplayer.h"
#include "fallback.h"


#include "ff.xbm"
#include "play.xbm"
#include "plus.xbm"
#include "stop.xbm"
#include "minus.xbm"
#include "rev.xbm"
#include "rew.xbm"
#include "rec.xbm"
#include "blank.xbm"
#include "quit.xbm"
#include "go.xbm"
/* Pat added this! */
#include "play_plus.xbm"
#include "play_minus.xbm"
#include "lev_plus.xbm"
#include "lev_minus.xbm"
#include "lev_max.xbm"
#include "lev_min.xbm"
/* end Pat added this */

static void com_rewind(void) ;
static void com_play(void) ;
static void com_reverse(void) ;
static void com_stop(void) ;
static void com_forward(void) ;
static void com_plus(void) ;
static void com_minus(void) ;
static void com_quit(void) ;
static void com_record(void) ;
static void com_blank(void) ;
static void com_jump(void) ;

/* Pat added this! */
static void com_al_level_plus(void);
static void com_al_level_minus(void);
static void com_al_level_max(void);
static void com_al_level_min(void);
static void com_al_player_plus(void);
static void com_al_player_minus(void);
/* end Pat added this */

extern Player *Play ;

static XtActionsRec actions[] = {
  {"com_jump", (XtActionProc)com_jump}
} ;

#ifdef X11R5
# include "utility.h"
static Arg Args[16] ;
static int Argn ;
#endif

#define	rootwin(x)	RootWindow(XtDisplay(x), XtWindow(x))

/*
 *========================================================================
 *Part: Controler
 *========================================================================
 */

void Controler::init(int argc, char *argv[])
{
  static String fallback_resources[] = FALLBACK_RESOURCES ;

  top = XtAppInitialize(&app_context, "top", NULL, 0, &argc, argv,
			fallback_resources, NULL, 0) ;
	
  assign() ;

  XtRealizeWidget(top) ;
  buttons_reset() ;
}


void Controler::assign(void)
{
#ifdef X11R5
  main = XtCreateManagedWidget("main", formWidgetClass, top, Args, 0) ;

  time = XtCreateManagedWidget("time", labelWidgetClass, main, Args, 0) ;

  status = XtCreateManagedWidget("status", labelWidgetClass, main, Args, 0) ;

  quit = XtCreateManagedWidget("quit", toggleWidgetClass, main, Args, 0) ;
  Pixmap quit_pixmap = XCreateBitmapFromData(XtDisplay(quit), rootwin(quit),
					     (const char*)quit_bits, quit_width, quit_height) ;
  mySetArg_1st(XtNbitmap, (XtArgVal)(XtArgVal)quit_pixmap) ;
  XtSetValues(quit, Args, Argn) ;
  XtAddCallback(quit, XtNcallback,
		(XtCallbackProc)com_quit, (XtPointer)this);

  buttons = XtCreateManagedWidget("buttons", formWidgetClass, main, Args, 0) ;

  rew = XtCreateManagedWidget("rew", toggleWidgetClass, buttons, Args, 0) ;
  Pixmap rew_pixmap = XCreateBitmapFromData(XtDisplay(rew), rootwin(rew),
					    (const char*)rew_bits, rew_width, rew_height) ;
  mySetArg_1st(XtNbitmap, (XtArgVal)(XtArgVal)rew_pixmap) ;
  XtSetValues(rew, Args, Argn) ;
  XtAddCallback(rew, XtNcallback,
		(XtCallbackProc)com_rewind, (XtPointer)this) ;

  rev = XtCreateManagedWidget("rev", toggleWidgetClass, buttons, Args, 0) ;
  Pixmap rev_pixmap = XCreateBitmapFromData(XtDisplay(rev), rootwin(rev),
					    (const char*)rev_bits, rev_width, rev_height) ;
  mySetArg_1st(XtNbitmap, (XtArgVal)rev_pixmap) ;
  XtSetValues(rev, Args, Argn) ;
  XtAddCallback(rev, XtNcallback,
		(XtCallbackProc)com_reverse, (XtPointer)this);

  minus = XtCreateManagedWidget("minus", toggleWidgetClass, buttons, Args, 0);
  Pixmap minus_pixmap = XCreateBitmapFromData(XtDisplay(minus),rootwin(minus),
					      (const char*)minus_bits, minus_width, minus_height);
  mySetArg_1st(XtNbitmap, (XtArgVal)minus_pixmap) ;
  XtSetValues(minus, Args, Argn) ;
  XtAddCallback(minus, XtNcallback,
		(XtCallbackProc)com_minus, (XtPointer)this) ;

  stop = XtCreateManagedWidget("stop", toggleWidgetClass, buttons, Args, 0) ;
  Pixmap stop_pixmap = XCreateBitmapFromData(XtDisplay(stop), rootwin(stop),
					     (const char*)stop_bits, stop_width, stop_height) ;
  mySetArg_1st(XtNbitmap, (XtArgVal)stop_pixmap) ;
  XtSetValues(stop, Args, Argn) ;
  XtAddCallback(stop, XtNcallback,
		(XtCallbackProc)com_stop, (XtPointer)this) ;

  plus = XtCreateManagedWidget("plus", toggleWidgetClass, buttons, Args, 0) ;
  Pixmap plus_pixmap = XCreateBitmapFromData(XtDisplay(plus), rootwin(plus),
					     (const char*)plus_bits, plus_width, plus_height) ;
  mySetArg_1st(XtNbitmap, (XtArgVal)plus_pixmap) ;
  XtSetValues(plus, Args, Argn) ;
  XtAddCallback(plus, XtNcallback,
		(XtCallbackProc)com_plus, (XtPointer)this) ;

  play = XtCreateManagedWidget("play", toggleWidgetClass, buttons, Args, 0) ;
  Pixmap play_pixmap = XCreateBitmapFromData(XtDisplay(play), rootwin(play),
					     (const char*)play_bits, play_width, play_height) ;
  mySetArg_1st(XtNbitmap, (XtArgVal)play_pixmap) ;
  XtSetValues(play, Args, Argn) ;
  XtAddCallback(play, XtNcallback,
		(XtCallbackProc)com_play, (XtPointer)this) ;

  ff = XtCreateManagedWidget("ff", toggleWidgetClass, buttons, Args, 0) ;
  Pixmap ff_pixmap = XCreateBitmapFromData(XtDisplay(ff), rootwin(ff),
					   (const char*)ff_bits, ff_width, ff_height) ;
  mySetArg_1st(XtNbitmap, (XtArgVal)ff_pixmap) ;
  XtSetValues(ff, Args, Argn) ;
  XtAddCallback(ff, XtNcallback,
		(XtCallbackProc)com_forward, (XtPointer)this);

  /* Pat added this! */
  SMURF;
  if (Play->show_action_logs) {
    al_player_minus = XtCreateManagedWidget("al_player_minus", toggleWidgetClass, buttons, Args, 0) ;
    Pixmap al_player_minus_pixmap = XCreateBitmapFromData(XtDisplay(al_player_minus), rootwin(al_player_minus),
							  (const char*)myminus_bits, myminus_width, myminus_height) ;
    mySetArg_1st(XtNbitmap, (XtArgVal)al_player_minus_pixmap) ;
    XtSetValues(al_player_minus, Args, Argn) ;
    XtAddCallback(al_player_minus, XtNcallback,
		  (XtCallbackProc)com_al_player_minus, (XtPointer)this);

    al_player_plus = XtCreateManagedWidget("al_player_plus", toggleWidgetClass, buttons, Args, 0) ;
    Pixmap al_player_plus_pixmap = XCreateBitmapFromData(XtDisplay(al_player_plus), rootwin(al_player_plus),
							 (const char*)myplus_bits, myplus_width, myplus_height) ;
    mySetArg_1st(XtNbitmap, (XtArgVal)al_player_plus_pixmap) ;
    XtSetValues(al_player_plus, Args, Argn) ;
    XtAddCallback(al_player_plus, XtNcallback,
		  (XtCallbackProc)com_al_player_plus, (XtPointer)this);

    al_level_minus = XtCreateManagedWidget("al_level_minus", toggleWidgetClass, buttons, Args, 0) ;
    Pixmap al_level_minus_pixmap = XCreateBitmapFromData(XtDisplay(al_level_minus), rootwin(al_level_minus),
							 (const char*)myminus_bits, myminus_width, myminus_height) ;
    mySetArg_1st(XtNbitmap, (XtArgVal)al_level_minus_pixmap) ;
    XtSetValues(al_level_minus, Args, Argn) ;
    XtAddCallback(al_level_minus, XtNcallback,
		  (XtCallbackProc)com_al_level_minus, (XtPointer)this);

    al_level_plus = XtCreateManagedWidget("al_level_plus", toggleWidgetClass, buttons, Args, 0) ;
    Pixmap al_level_plus_pixmap = XCreateBitmapFromData(XtDisplay(al_level_plus), rootwin(al_level_plus),
							(const char*)myplus_bits, myplus_width, myplus_height) ;
    mySetArg_1st(XtNbitmap, (XtArgVal)al_level_plus_pixmap) ;
    XtSetValues(al_level_plus, Args, Argn) ;
    XtAddCallback(al_level_plus, XtNcallback,
		  (XtCallbackProc)com_al_level_plus, (XtPointer)this);

  al_level_min = XtCreateManagedWidget("al_level_min", toggleWidgetClass, buttons, Args, 0) ;
    Pixmap al_level_min_pixmap = XCreateBitmapFromData(XtDisplay(al_level_min), rootwin(al_level_min),
							 (const char*)myminus_bits, myminus_width, myminus_height) ;
    mySetArg_1st(XtNbitmap, (XtArgVal)al_level_min_pixmap) ;
    XtSetValues(al_level_min, Args, Argn) ;
    XtAddCallback(al_level_min, XtNcallback,
		  (XtCallbackProc)com_al_level_min, (XtPointer)this);

    al_level_plus = XtCreateManagedWidget("al_level_plus", toggleWidgetClass, buttons, Args, 0) ;
    Pixmap al_level_plus_pixmap = XCreateBitmapFromData(XtDisplay(al_level_plus), rootwin(al_level_plus),
							(const char*)myplus_bits, myplus_width, myplus_height) ;
    mySetArg_1st(XtNbitmap, (XtArgVal)al_level_plus_pixmap) ;
    XtSetValues(al_level_plus, Args, Argn) ;
    XtAddCallback(al_level_plus, XtNcallback,
		  (XtCallbackProc)com_al_level_plus, (XtPointer)this);
  }
  /* end Pat added this */
  
  if (Play->out_file[0] != NULLCHAR) {
    record_buttons = XtCreateManagedWidget("record",
					   formWidgetClass, main, Args, 0) ;

    blank = XtCreateManagedWidget("blank", toggleWidgetClass,
				  record_buttons, Args, 0) ;
    Pixmap blank_pixmap = 
      XCreateBitmapFromData(XtDisplay(blank), rootwin(blank),
			    (const char*)blank_bits, blank_width, blank_height);
    mySetArg_1st(XtNbitmap, (XtArgVal)blank_pixmap) ;
    XtSetValues(blank, Args, Argn) ;
    XtAddCallback(blank, XtNcallback,
		  (XtCallbackProc)com_blank, (XtPointer)this) ;

    rec = XtCreateManagedWidget("rec", toggleWidgetClass,
				record_buttons, Args, 0);
    Pixmap rec_pixmap = XCreateBitmapFromData(XtDisplay(rec), rootwin(rec),
					      (const char*)rec_bits, rec_width, rec_height) ;
    mySetArg_1st(XtNbitmap, (XtArgVal)rec_pixmap) ;
    XtSetValues(rec, Args, Argn) ;
    XtAddCallback(rec, XtNcallback,
		  (XtCallbackProc)com_record, (XtPointer)this) ;
  }
  jump = XtCreateManagedWidget("jump", formWidgetClass, main, Args, 0) ;

  mySetArg_1st(XtNeditType, "edit") ;
  input = XtCreateManagedWidget("input",
				asciiTextWidgetClass, jump, Args, Argn) ;
	
  go = XtCreateManagedWidget("go", commandWidgetClass, jump, Args, 0) ;
  Pixmap go_pixmap = XCreateBitmapFromData(XtDisplay(go), rootwin(go),
					   (const char*)go_bits, go_width, go_height) ;
  mySetArg_1st(XtNbitmap, (XtArgVal)go_pixmap) ;
  XtSetValues(go, Args, Argn) ;
  XtAddCallback(go, XtNcallback,
		(XtCallbackProc)com_jump, (XtPointer)this) ;

#else

  main = XtVaCreateManagedWidget("main", formWidgetClass, top, NULL) ;

  time = XtVaCreateManagedWidget("time", labelWidgetClass, main, NULL) ;

  status = XtVaCreateManagedWidget("status", labelWidgetClass, main, NULL) ;

  quit = XtVaCreateManagedWidget("quit", toggleWidgetClass, main, NULL) ;
  Pixmap quit_pixmap = XCreateBitmapFromData(XtDisplay(quit), rootwin(quit),
					     (const char*)quit_bits, quit_width, quit_height) ;
  XtVaSetValues(quit, XtNbitmap, (XtArgVal)quit_pixmap, NULL) ;
  XtAddCallback(quit, XtNcallback,
		(XtCallbackProc)com_quit, (XtPointer)this);

  buttons = XtVaCreateManagedWidget("buttons", formWidgetClass, main, NULL) ;

  rew = XtVaCreateManagedWidget("rew", toggleWidgetClass, buttons, NULL) ;
  Pixmap rew_pixmap = XCreateBitmapFromData(XtDisplay(rew), rootwin(rew),
					    (const char*)rew_bits, rew_width, rew_height) ;
  XtVaSetValues(rew, XtNbitmap, (XtArgVal)rew_pixmap, NULL) ;
  XtAddCallback(rew, XtNcallback,
		(XtCallbackProc)com_rewind, (XtPointer)this) ;

  rev = XtVaCreateManagedWidget("rev", toggleWidgetClass, buttons, NULL) ;
  Pixmap rev_pixmap = XCreateBitmapFromData(XtDisplay(rev), rootwin(rev),
					    (const char*)rev_bits, rev_width, rev_height) ;
  XtVaSetValues(rev, XtNbitmap, (XtArgVal)rev_pixmap, NULL) ;
  XtAddCallback(rev, XtNcallback,
		(XtCallbackProc)com_reverse, (XtPointer)this);

  minus = XtVaCreateManagedWidget("minus", toggleWidgetClass, buttons, NULL) ;
  Pixmap minus_pixmap = XCreateBitmapFromData(XtDisplay(minus),rootwin(minus),
					      (const char*)minus_bits, minus_width, minus_height);
  XtVaSetValues(minus, XtNbitmap, (XtArgVal)minus_pixmap, NULL) ;
  XtAddCallback(minus, XtNcallback,
		(XtCallbackProc)com_minus, (XtPointer)this) ;

  stop = XtVaCreateManagedWidget("stop", toggleWidgetClass, buttons, NULL) ;
  Pixmap stop_pixmap = XCreateBitmapFromData(XtDisplay(stop), rootwin(stop),
					     (const char*)stop_bits, stop_width, stop_height) ;
  XtVaSetValues(stop, XtNbitmap, (XtArgVal)stop_pixmap, NULL) ;
  XtAddCallback(stop, XtNcallback,
		(XtCallbackProc)com_stop, (XtPointer)this) ;

  plus = XtVaCreateManagedWidget("plus", toggleWidgetClass, buttons, NULL) ;
  Pixmap plus_pixmap = XCreateBitmapFromData(XtDisplay(plus), rootwin(plus),
					     (const char*)plus_bits, plus_width, plus_height) ;
  XtVaSetValues(plus, XtNbitmap, (XtArgVal)plus_pixmap, NULL) ;
  XtAddCallback(plus, XtNcallback,
		(XtCallbackProc)com_plus, (XtPointer)this) ;

  play = XtVaCreateManagedWidget("play", toggleWidgetClass, buttons, NULL) ;
  Pixmap play_pixmap = XCreateBitmapFromData(XtDisplay(play), rootwin(play),
					     (const char*)play_bits, play_width, play_height) ;
  XtVaSetValues(play, XtNbitmap, (XtArgVal)play_pixmap, NULL) ;
  XtAddCallback(play, XtNcallback,
		(XtCallbackProc)com_play, (XtPointer)this) ;

  ff = XtVaCreateManagedWidget("ff", toggleWidgetClass, buttons, NULL) ;
  Pixmap ff_pixmap = XCreateBitmapFromData(XtDisplay(ff), rootwin(ff),
					   (const char*)ff_bits, ff_width, ff_height) ;
  XtVaSetValues(ff, XtNbitmap, (XtArgVal)ff_pixmap, NULL) ;
  XtAddCallback(ff, XtNcallback,
		(XtCallbackProc)com_forward, (XtPointer)this);

  /* Pat added this! */
  if (Play->show_action_logs) {
    al_player_minus = XtVaCreateManagedWidget("al_player_minus", toggleWidgetClass, buttons, NULL) ;
    Pixmap al_player_minus_pixmap =
      XCreateBitmapFromData(XtDisplay(al_player_minus), rootwin(al_player_minus),
			    (const char*)play_minus_bits, play_minus_width, play_minus_height) ;
    XtVaSetValues(al_player_minus, XtNbitmap, (XtArgVal)al_player_minus_pixmap, NULL) ;
    XtAddCallback(al_player_minus, XtNcallback,
		  (XtCallbackProc)com_al_player_minus, (XtPointer)this);

    al_player_plus = XtVaCreateManagedWidget("al_player_plus", toggleWidgetClass, buttons, NULL) ;
    Pixmap al_player_plus_pixmap =
      XCreateBitmapFromData(XtDisplay(al_player_plus), rootwin(al_player_plus),
			    (const char*)play_plus_bits, play_plus_width, play_plus_height) ;
    XtVaSetValues(al_player_plus, XtNbitmap, (XtArgVal)al_player_plus_pixmap, NULL) ;
    XtAddCallback(al_player_plus, XtNcallback,
		  (XtCallbackProc)com_al_player_plus, (XtPointer)this);

    al_level_minus = XtVaCreateManagedWidget("al_level_minus", toggleWidgetClass, buttons, NULL) ;
    Pixmap al_level_minus_pixmap =
      XCreateBitmapFromData(XtDisplay(al_level_minus), rootwin(al_level_minus),
			    (const char*)lev_minus_bits, lev_minus_width, lev_minus_height) ;
    XtVaSetValues(al_level_minus, XtNbitmap, (XtArgVal)al_level_minus_pixmap, NULL) ;
    XtAddCallback(al_level_minus, XtNcallback,
		  (XtCallbackProc)com_al_level_minus, (XtPointer)this);

    al_level_plus = XtVaCreateManagedWidget("al_level_plus", toggleWidgetClass, buttons, NULL) ;
    Pixmap al_level_plus_pixmap =
      XCreateBitmapFromData(XtDisplay(al_level_plus), rootwin(al_level_plus),
			    (const char*)lev_plus_bits, lev_plus_width, lev_plus_height) ;
    XtVaSetValues(al_level_plus, XtNbitmap, (XtArgVal)al_level_plus_pixmap, NULL) ;
    XtAddCallback(al_level_plus, XtNcallback,
		  (XtCallbackProc)com_al_level_plus, (XtPointer)this);

    al_level_min = XtVaCreateManagedWidget("al_level_min", toggleWidgetClass, buttons, NULL) ;
    Pixmap al_level_min_pixmap =
      XCreateBitmapFromData(XtDisplay(al_level_min), rootwin(al_level_min),
			    (const char*)lev_min_bits, lev_min_width, lev_min_height) ;
    XtVaSetValues(al_level_min, XtNbitmap, (XtArgVal)al_level_min_pixmap, NULL) ;
    XtAddCallback(al_level_min, XtNcallback,
		  (XtCallbackProc)com_al_level_min, (XtPointer)this);

    al_level_max = XtVaCreateManagedWidget("al_level_max", toggleWidgetClass, buttons, NULL) ;
    Pixmap al_level_max_pixmap =
      XCreateBitmapFromData(XtDisplay(al_level_max), rootwin(al_level_max),
			    (const char*)lev_max_bits, lev_max_width, lev_max_height) ;
    XtVaSetValues(al_level_max, XtNbitmap, (XtArgVal)al_level_max_pixmap, NULL) ;
    XtAddCallback(al_level_max, XtNcallback,
		  (XtCallbackProc)com_al_level_max, (XtPointer)this);
    /* end Pat added this */
  }

  if (Play->out_file[0] != NULLCHAR) {
    record_buttons = XtVaCreateManagedWidget("record", formWidgetClass,
					     main, NULL) ;
    blank = XtVaCreateManagedWidget("blank", toggleWidgetClass,
				    record_buttons, NULL) ;
    Pixmap blank_pixmap = 
      XCreateBitmapFromData(XtDisplay(blank), rootwin(blank),
			    (const char*)blank_bits, blank_width, blank_height);
    XtVaSetValues(blank, XtNbitmap, (XtArgVal)blank_pixmap, NULL) ;
    XtAddCallback(blank, XtNcallback,
		  (XtCallbackProc)com_blank, (XtPointer)this) ;

    rec = XtVaCreateManagedWidget("rec", toggleWidgetClass,
				  record_buttons, NULL);
    Pixmap rec_pixmap = XCreateBitmapFromData(XtDisplay(rec), rootwin(rec),
					      (const char*)rec_bits, rec_width, rec_height) ;
    XtVaSetValues(rec, XtNbitmap, (XtArgVal)rec_pixmap, NULL) ;
    XtAddCallback(rec, XtNcallback,
		  (XtCallbackProc)com_record, (XtPointer)this) ;

  }
												
  jump = XtVaCreateManagedWidget("jump", formWidgetClass, main, NULL) ;

  input = XtVaCreateManagedWidget("input", asciiTextWidgetClass, jump,
				  XtNeditType, "edit", NULL) ;
	
  go = XtVaCreateManagedWidget("go", commandWidgetClass, jump, NULL) ;
  Pixmap go_pixmap = XCreateBitmapFromData(XtDisplay(go), rootwin(go),
					   (const char*)go_bits, go_width, go_height) ;
  XtVaSetValues(go, XtNbitmap, (XtArgVal)go_pixmap, NULL) ;

  XtAddCallback(go, XtNcallback,
		(XtCallbackProc)com_jump, (XtPointer)this) ;
#endif
  XtAppAddActions(app_context, actions, XtNumber(actions)) ;
}

void Controler::display_time(int t)
{
  static char buf[MaxStringSize] ;

  sprintf(buf, "time: %5d", t) ;
#ifndef X11R5
  XtVaSetValues(time, XtNlabel, buf, NULL) ;
#else
  mySetArg_1st(XtNlabel, buf) ;
  XtSetValues(time, Args, Argn) ;
#endif
}

void Controler::display_status(void)
{
  static char buf[MaxStringSize] ;

  switch (Play->state) {
  case STATE_WAIT:
    sprintf(buf, "wait for monitor") ;
    break ;

  case STATE_STOP:
    sprintf(buf, "%s: stop", Play->in_file) ;
    break ;

  case STATE_PLAY:
    sprintf(buf, "%s: play", Play->in_file) ;
    break ;

  case STATE_REVERSE:
    sprintf(buf, "%s: reverse", Play->in_file) ;
    break ;

  case STATE_REW:
    sprintf(buf, "%s: rewind", Play->in_file) ;
    break ;

  case STATE_FOR:
    sprintf(buf, "%s: forward", Play->in_file) ;
    break ;

  case STATE_PLUS:
    sprintf(buf, "%s: +1", Play->in_file) ;
    break ;

  case STATE_MINUS:
    sprintf(buf, "%s: -1", Play->in_file) ;
    break ;

  case STATE_BLANK:
    sprintf(buf, "sending blank") ;
    break ;

  case STATE_JUMP:
    sprintf(buf, "%s: jump to %d", Play->in_file, Play->to_time) ;
    break ;

  case STATE_NOT_JUMP:
    sprintf(buf, "can't jump") ;
    break ;

  default :
    sprintf(buf, "error") ;
    break ;
  }
#ifndef X11R5
  XtVaSetValues(status, XtNlabel, buf, NULL) ;
#else
  mySetArg_1st(XtNlabel, buf) ;
  XtSetValues(status, Args, Argn) ;
#endif
}

void Controler::buttons_reset(void)
{
  if (Play->state == STATE_REW)
    rew_button_reset_true() ;
  else
    rew_button_reset_false() ;
		
  if (Play->state == STATE_REVERSE)
    rev_button_reset_true() ;
  else
    rev_button_reset_false() ;

  minus_button_reset() ;

  if (Play->state == STATE_STOP || Play->state == STATE_WAIT ||
      Play->state == STATE_JUMP || Play->state == STATE_NOT_JUMP)
    stop_button_reset_true() ;
  else
    stop_button_reset_false() ;

  plus_button_reset() ;

  if (Play->state == STATE_PLAY)
    play_button_reset_true() ;
  else
    play_button_reset_false() ;

  if (Play->state == STATE_FOR)
    for_button_reset_true() ;
  else
    for_button_reset_false() ;

  if (Play->out_file[0] != NULLCHAR)
    if (Play->state != STATE_BLANK)
      blank_button_reset() ;

  /* Pat added this! */
  if (Play->show_action_logs) {
    al_level_plus_button_reset();
    al_level_minus_button_reset();
    al_level_max_button_reset();
    al_level_min_button_reset();
    al_player_plus_button_reset();
    al_player_minus_button_reset();
  }
  /* end Pat added this */

}

void Controler::rew_button_reset_true(void)
{
#ifdef X11R5
  mySetArg_1st(XtNstate, True) ;
  XtSetValues(rew, Args, Argn) ;
#else
  XtVaSetValues(rew, XtNstate, True, NULL) ;
#endif
}

void Controler::rew_button_reset_false(void)
{
#ifdef X11R5
  mySetArg_1st(XtNstate, False) ;
  XtSetValues(rew, Args, Argn) ;
#else
  XtVaSetValues(rew, XtNstate, False, NULL) ;
#endif
}

void Controler::rev_button_reset_true(void)
{
#ifdef X11R5
  mySetArg_1st(XtNstate, True) ;
  XtSetValues(rev, Args, Argn) ;
#else
  XtVaSetValues(rev, XtNstate, True, NULL) ;
#endif
}

void Controler::rev_button_reset_false(void)
{
#ifdef X11R5
  mySetArg_1st(XtNstate, False) ;
  XtSetValues(rev, Args, Argn) ;
#else
  XtVaSetValues(rev, XtNstate, False, NULL) ;
#endif
}

void Controler::minus_button_reset(void)
{
#ifdef X11R5
  mySetArg_1st(XtNstate, False) ;
  XtSetValues(minus, Args, Argn) ;
#else
  XtVaSetValues(minus, XtNstate, False, NULL) ;
#endif
}

void Controler::stop_button_reset_true(void)
{
#ifdef X11R5
  mySetArg_1st(XtNstate, True) ;
  XtSetValues(stop, Args, Argn) ;
#else
  XtVaSetValues(stop, XtNstate, True, NULL) ;
#endif
}

void Controler::stop_button_reset_false(void)
{
#ifdef X11R5
  mySetArg_1st(XtNstate, False) ;
  XtSetValues(stop, Args, Argn) ;
#else
  XtVaSetValues(stop, XtNstate, False, NULL) ;
#endif
}

void Controler::plus_button_reset(void)
{
#ifdef X11R5
  mySetArg_1st(XtNstate, False) ;
  XtSetValues(plus, Args, Argn) ;
#else
  XtVaSetValues(plus, XtNstate, False, NULL) ;
#endif
}

void Controler::play_button_reset_true(void)
{
#ifdef X11R5
  mySetArg_1st(XtNstate, True) ;
  XtSetValues(play, Args, Argn) ;
#else
  XtVaSetValues(play, XtNstate, True, NULL) ;
#endif
}

void Controler::play_button_reset_false(void)
{
#ifdef X11R5
  mySetArg_1st(XtNstate, False) ;
  XtSetValues(play, Args, Argn) ;
#else
  XtVaSetValues(play, XtNstate, False, NULL) ;
#endif
}

void Controler::for_button_reset_true(void)
{
#ifdef X11R5
  mySetArg_1st(XtNstate, True) ;
  XtSetValues(ff, Args, Argn) ;
#else
  XtVaSetValues(ff, XtNstate, True, NULL) ;
#endif
}

void Controler::for_button_reset_false(void)
{
#ifdef X11R5
  mySetArg_1st(XtNstate, False) ;
  XtSetValues(ff, Args, Argn) ;
#else
  XtVaSetValues(ff, XtNstate, False, NULL) ;
#endif
}

void Controler::blank_button_reset(void)
{
#ifdef X11R5
  mySetArg_1st(XtNstate, False) ;
  XtSetValues(blank, Args, Argn) ;
#else
  XtVaSetValues(blank, XtNstate, False, NULL) ;
#endif
}

  /* Pat added this! */
void Controler::al_level_plus_button_reset(void)
{
#ifdef X11R5
  mySetArg_1st(XtNstate, False) ;
  XtSetValues(al_level_plus, Args, Argn) ;
#else
  XtVaSetValues(al_level_plus, XtNstate, False, NULL) ;
#endif
}

void Controler::al_level_minus_button_reset(void)
{
#ifdef X11R5
  mySetArg_1st(XtNstate, False) ;
  XtSetValues(al_level_minus, Args, Argn) ;
#else
  XtVaSetValues(al_level_minus, XtNstate, False, NULL) ;
#endif
}

void Controler::al_level_max_button_reset(void)
{
#ifdef X11R5
  mySetArg_1st(XtNstate, False) ;
  XtSetValues(al_level_max, Args, Argn) ;
#else
  XtVaSetValues(al_level_max, XtNstate, False, NULL) ;
#endif
}

void Controler::al_level_min_button_reset(void)
{
#ifdef X11R5
  mySetArg_1st(XtNstate, False) ;
  XtSetValues(al_level_min, Args, Argn) ;
#else
  XtVaSetValues(al_level_min, XtNstate, False, NULL) ;
#endif
}

void Controler::al_player_plus_button_reset(void)
{
#ifdef X11R5
  mySetArg_1st(XtNstate, False) ;
  XtSetValues(al_player_plus, Args, Argn) ;
#else
  XtVaSetValues(al_player_plus, XtNstate, False, NULL) ;
#endif
}

void Controler::al_player_minus_button_reset(void)
{
#ifdef X11R5
  mySetArg_1st(XtNstate, False) ;
  XtSetValues(al_player_minus, Args, Argn) ;
#else
  XtVaSetValues(al_player_minus, XtNstate, False, NULL) ;
#endif
}
/* end Pat added this */



void Controler::Loop(void)
{
  XtAppMainLoop(app_context) ;
}

static void com_rewind(void)
{
  if (Play->state != STATE_WAIT)
    Play->state = STATE_REW ;
  Play->controler->display_status() ;
  Play->controler->buttons_reset() ;
}

static void com_reverse(void)
{
  if (Play->state != STATE_WAIT)
    Play->state = STATE_REVERSE ;
  Play->controler->display_status() ;
  Play->controler->buttons_reset() ;
}

static void com_minus(void)
{
  if (Play->state != STATE_WAIT)
    Play->state = STATE_MINUS ;
  Play->controler->display_status() ;
  Play->controler->buttons_reset() ;
}

void com_stop(void)
{
  if (Play->state != STATE_WAIT)
    Play->state = STATE_STOP ;
  Play->controler->display_status() ;
  Play->controler->buttons_reset() ;
}

static void com_play(void)
{
  if (Play->state != STATE_WAIT)
    Play->state = STATE_PLAY ;
  Play->controler->display_status() ;
  Play->controler->buttons_reset() ;
}


static void com_forward(void)
{
  if (Play->state != STATE_WAIT)
    Play->state = STATE_FOR ;
  Play->controler->display_status() ;
  Play->controler->buttons_reset() ;
}

static void com_plus(void)
{
  if (Play->state != STATE_WAIT)
    Play->state = STATE_PLUS ;
  Play->controler->display_status() ;
  Play->controler->buttons_reset() ;
}

static void com_record(void)
{
  if (Play->rec_state == REC_OFF)
    Play->rec_state = REC_ON ;
  else if (Play->rec_state == REC_ON)
    Play->rec_state = REC_OFF ;
}

static void com_blank(void)
{
  if (Play->state != STATE_WAIT)
    Play->state = STATE_BLANK ;
  Play->controler->display_status() ;
  Play->controler->buttons_reset() ;
}

/* Pat added this! */
#define min(x,y) (((x) < (y)) ? (x) : (y))
#define max(x,y) (((x) > (y)) ? (x) : (y))
#define MAX_LEVEL 220
static void com_al_level_plus(void)
{
  Play->al_level = min(Play->al_level + 10,  MAX_LEVEL);
  Play->controler->buttons_reset() ;
  Play->DisplayActionLog();
}

static void com_al_level_minus(void)
{
  Play->al_level = max(Play->al_level - 10, 0);
  Play->controler->buttons_reset() ;
  Play->DisplayActionLog();
}

static void com_al_level_max(void)
{
  Play->al_level = MAX_LEVEL;
  Play->controler->buttons_reset() ;
  Play->DisplayActionLog();
}

static void com_al_level_min(void)
{
  Play->al_level = 0;
  Play->controler->buttons_reset() ;
  Play->DisplayActionLog();
}

static void com_al_player_plus(void)
{
  Play->al_player = (Play->al_player % (2*Play->team_size)) + 1;
  Play->controler->buttons_reset() ;
  printf("Now at Player %s %d\n",
	 (Play->al_player <= Play->team_size) ? "Left" : "Right",
	 ((Play->al_player-1)%Play->team_size) + 1);
  //Play->DisplayActionLog(); /* too much file io! */
}

static void com_al_player_minus(void)
{
  Play->al_player = ((Play->al_player + (2*Play->team_size - 2)) % (2*Play->team_size)) + 1;
  Play->controler->buttons_reset() ;
  printf("Now at Player %s %d\n",
	 (Play->al_player <= Play->team_size) ? "Left" : "Right",
	 ((Play->al_player-1)%Play->team_size) + 1);
  //Play->DisplayActionLog(); /* too much file io! */
}
/* end Pat added this */



static void com_jump(void)
{
  String str ;
  char *s, *t ;

#ifdef X11R5
  mySetArg_1st(XtNstring, &str) ;
  XtGetValues(Play->controler->input, Args, Argn) ;
#else
  XtVaGetValues(Play->controler->input, XtNstring, &str, NULL) ;
#endif

  s = t = (char *)str ;
  for ( ; ; s++) {
    if (*s == NULLCHAR || s == (char)NULL)
      break ;
    if (*s == '\n') t = s + 1;
  }

  if (Play->state != STATE_WAIT) {
    if (sscanf(t, "%d", &Play->to_time) == 1)
      Play->state = STATE_JUMP ;
    else if (!strcmp(t, "end")) {
      Play->to_time = END ;
      Play->state = STATE_JUMP ;
    }
    else {
      Play->state = STATE_NOT_JUMP ;
    }
    Play->controler->display_status() ;
    Play->controler->buttons_reset() ;
  }
#ifdef X11R5
  mySetArg_1st(XtNstring, "") ;
  XtSetValues(Play->controler->input, Args, Argn) ;
#else
  XtVaSetValues(Play->controler->input, XtNstring, "", NULL) ;
#endif
}

static void com_quit(void)
{
  Play->Quit() ;
}
