#include <math.h>
#include "turnball.h"
#include "Memory.h"
#include "client.h"

  /*
       kick-power-rate := max-kick-power-rate *  
                       (1 - 
                         0.25 * |dirDiference|/180 -
                         0.25 * (distBallPlayer - BallSize - PlayerSize)/
                               kick_margin)
			       */
/* this is the code from the server v 4.06:
   	power *= stadium->kprate *
			(1 - 0.25*dir_diff/PI - 0.25*dist_ball/stadium->kmargin) ;
			*/
/* given the location of the ball relative to the player, what is max
   kick power */
float get_effkickpowrate()
{
  return Mem->SP_kick_power_rate *
    (1 - .25 * fabs(Mem->GetBall()->get_ang()) / 180.0 -
     .25 * (Mem->GetBall()->get_dist() - Mem->SP_ball_size - Mem->SP_player_size) /
     Mem->SP_kickable_margin);
}


int kickable() {
  if (Mem->GetBall()->pos_valid() &&
      Mem->GetBall()->get_dist() < Mem->SP_kickable_area) return 1;
  else return 0;
}


int is_straight_kick(float dir)
{
  Vector btraj = Polar2Vector(Mem->CP_opt_ctrl_dist, dir) -
    Mem->GetBall()->get_pos();
  float ang;
  float dist;
  int res;
  
  ang = ACos( (Sqr(Mem->CP_opt_ctrl_dist) - Sqr(btraj.mod()) -
	       Sqr(Mem->GetBall()->get_dist()))/
	      (-2 * Mem->GetBall()->get_dist() * btraj.mod()) );
  Debug2("   isStraight ang: %f\n", ang);
  if (fabs(ang) > 90) {
    Debug("    isStraight: Obtuse!\n");
    return 1; /* obtuse angle implies definately straight */
  }
  dist = Sin(ang) * Mem->GetBall()->get_dist();
  Debug2("   isStraight dist: %f\n", dist);
  res = (fabs(dist) > Mem->CP_closest_margin);
  return ( res );  
} 


/* Kick with direction ddir and power such that the ball moves distance ddist
   The distance is kind of an arbitrary power float
   If ddist is too big, kick it as hard as possible.
   corrects for ball velocity
   Returns 1 if kick will make it
   use dokick determines whether the distance should try to be covered in
    one cycle or multiplied by the dokick_factor*/
int dokick(float ddir, float ddist, int use_dokick) 
{
  float v0;
  float power;
  int retval = 1;
  float kick_dir = ddir;
  
  if (use_dokick)
    v0 = ddist * Mem->CP_dokick_factor;
  else
    v0 = ddist;
  
  ddir = NormalizeAngleDegle(ddir);
  
  if (Mem->GetBall()->get_vel() != 0) { /* correct for ball velocity */
    Vector tmp = Polar2Vector(v0, ddir) - Mem->GetBall()->get_vel();
    kick_dir = tmp.dir();
    power = tmp.mod() / get_effkickpowrate();
    Debug3(" Correcting for ball velocity# vel.x: %f\tvel.y:%f\n",
	  Mem->GetBall()->get_vel().x, Mem->GetBall()->get_vel().y);
    Debug3(" New stuff# power: %f\t ddir:%f\n", power, kick_dir);
  } else
     power = v0  / get_effkickpowrate();

  if (power > Mem->SP_max_power) {
    Debug("Trying to kick over SP_max_power! Correcting...\n");
    if (Mem->GetBall()->get_vel() == 0) {
      power = Mem->SP_max_power;
    } else {
      /* this is a real pain
	 We're looking at the traingle that is kick + vel = traj
	 First we'll figure out the angle between the traj and vel vectors
	 Then, we use the law of sines to get another angle in the triangle
	 Then, we'll use the law of cosines to get the size of new traj vector
	 Then, we'll recompute the kick based on that */

      Vector btraj = Polar2Vector(ddist, ddir);
      float ang = fabs(btraj.dir() - Mem->GetBall()->get_heading());
      float max_kick_vel = Mem->SP_max_power * get_effkickpowrate();
      float ball_vel = Mem->GetBall()->get_speed();
      float ang2 = fabs(ASin(ball_vel / max_kick_vel * Sin(ang)));
      Debug3("  vel/traj ang: %g\tkick/traj ang: %g\n", ang, ang2);
      float traj_mod = sqrt(Sqr(max_kick_vel) + Sqr(ball_vel) - 
			    2.0 * max_kick_vel * ball_vel * Cos(180-ang-ang2));
      Debug2("  new traj_mod: %g\n", traj_mod);
      btraj = Polar2Vector(traj_mod, ddir);
      Vector tmp = btraj - Mem->GetBall()->get_vel();
      kick_dir = tmp.dir();
      power = tmp.mod() / get_effkickpowrate();
      Debug3(" Correcting for ball velocity AND max power# vel.x: %f\tvel.y:%f\n",
	     Mem->GetBall()->get_vel().x, Mem->GetBall()->get_vel().y);
      Debug3(" 	New stuff# power: %f\t dir:%f\n", power, kick_dir);
      retval = 1;
    } 
  } 
  
  //SMURF  if (power > Mem->CP_minkickpower || doit) {
  kick(power, kick_dir);
  //SMURF} else retval = 0;

  return retval;
}


/* kick ball so that it is at angle ddir and dist Mem->CP_opt_ctrl_dist
   If you have to kick around the player, kick rotway(clockwise or counter-)
   */
KickToRes kick_to(float target_dir, TurnDir rotate)
{
  float dir;
  float dist;
  Vector btraj;
  
  Debug2("\nat kick_to: target_dir: %f\n", target_dir);

  target_dir = NormalizeAngleDegle(target_dir);
  
  Debug2("Time: %d\n", Mem->CurrentTime);
  /* the pos valid is not really right - if we are turning the ball and didn't
     actually see it last time, then there's a problem */
  if ( !Mem->GetBall()->pos_valid || !kickable() ) {
    return KT_LOST_BALL;
  }

  Debug3(" ball.dist: %f\t.dir: %f\n",
	 Mem->GetBall()->get_dist(), Mem->GetBall()->get_ang());
  Debug3(" ball.vel.x: %f\t.y: %f\n",
	 Mem->GetBall()->get_vel().x, Mem->GetBall()->get_vel().y);
  Debug3(" ball.rpos.x: %f\t.y: %f\n",
	 Mem->GetBall()->get_pos().x, Mem->GetBall()->get_pos().y);
  Debug2(" target_dir: %f\n", target_dir);

  if ( fabs(NormalizeAngleDegle(target_dir - Mem->GetBall()->get_ang())) < Mem->CP_KickTo_err) {
    /* Do something to indicate we are done */
    if (Mem->GetBall()->get_speed() < Mem->CP_max_ignore_vel)
      return KT_DID_NOTHING;
    Debug("  Stop ball kick\n");
    dokick(0, 0, TRUE);
    return KT_SUCCESS;
  }

  if (is_straight_kick(target_dir)) {
    float pow;
      
    btraj = Polar2Vector(Mem->CP_opt_ctrl_dist, target_dir) -
      Mem->GetBall()->get_pos();
    dir = btraj.dir();
    dist = btraj.mod();
    
    /* now we're goign to do some distance twiddling to get the ball to
       get to the right angle and stop */
    pow = dist / get_effkickpowrate();
    pow = Min(pow, Mem->CP_max_turn_kick_pow);
    dist = pow * get_effkickpowrate();
      
    Debug3("  Straight kick# dir: %f dist: %f\n", dir, dist);
    dokick(dir, dist, FALSE);

  } else if (Mem->GetBall()->get_dist() < Mem->CP_closest_margin) {

    /* ball is too close to do a tangent kick, so do a kick at 90 degrees */
    dir = ((int)rotate)*(-90) + Mem->GetBall()->get_ang();
    dist = 2.0*sqrt(Sqr(Mem->CP_opt_ctrl_dist) - Sqr(Mem->GetBall()->get_dist()));
    Debug3("  Close kick# dir: %f dist: %f\n", dir, dist);
    dokick(dir, dist, TRUE);

  } else {

    /* do a turning kick */
    dir = 180 + Mem->GetBall()->get_ang() +
      ((int)rotate)*ASin(Mem->CP_closest_margin / Mem->GetBall()->get_dist());
    Debug3(" ball dist: %f\tclosest_margin: %f\n",
	   Mem->GetBall()->get_dist(), Mem->CP_closest_margin);
    dist = sqrt(Sqr(Mem->GetBall()->get_dist()) - Sqr(Mem->CP_closest_margin));
    dist +=
      sqrt(Sqr(Mem->CP_opt_ctrl_dist) - Sqr(Mem->CP_closest_margin));
    Debug3("  Turning ball# dir: %f dist: %f\n", dir, dist);
    dokick(dir, dist, TRUE);

  }

  return KT_DID_KICK;
}





/* step determines which part of the kick the player should try to do
   the return of the function is what shoudl be passed as an argument next.
   This function implements a 3 kicks in a straight line
   step 0 is rotating the ball to the right starting position
   step 1 is kicking the ball to the edge
   step 2 is the final kick before the ball leaves us */
int kick_hard_straight(float dir, int step)
{
  float target_dir;
  int res;
  Vector nokick_pos =
    Mem->GetBall()->get_pos() + Mem->GetBall()->get_vel(); /* the position w/ no kick */
  
  if (!kickable())
    return -1;

  Debug3("\nTime: %d\nkick_hard_straight called with step: %d\n",
	 Mem->CurrentTime, step);
  
  if (step == 0) {
    Debug(" doing turning kick\n");
    target_dir = 90 + ACos(Mem->CP_hard_kick_margin / Mem->CP_opt_ctrl_dist) + dir;
    res = kick_to(target_dir, TURN_CW);
    if (res == KT_SUCCESS)
      return 1;
    return 0; /* SMURF - need better return codes */

    /*SMURF the next part of this if is not quite right (the check shoudl be better) */
  } else if (step == 2 ||
	     nokick_pos.mod() > Mem->SP_kickable_area - Mem->CP_hard_kick_err) {
    /* do the final kick */
    Debug(" doing the final kick\n");
    /* the third parameter is the distance- set it to a big number to get
       as hard a kick as possible */
    dokick(dir, 100, FALSE);
    return 3;

  } else if (step == 1) {
    /* do the accelerating kick */
    Debug(" doing the accel kick\n");

    /* the vector to the point on the edge where the ball shoudl come out */
    Vector edge_vec =
      Polar2Vector(Mem->SP_kickable_area - Mem->CP_hard_kick_err,
		   dir + 90 -
		   ACos(Mem->CP_hard_kick_margin /
			(Mem->SP_kickable_area - Mem->CP_hard_kick_err)));
    /* the ball trajectory to get to that point */
    Vector edge_traj = edge_vec - nokick_pos;
    /* first, if we can kick to the edge,
       or if we're only goign to get two more kicks,
       kick to the edge */
    if ( edge_traj.mod() <
	  Mem->SP_max_power * get_effkickpowrate() ||
	 (nokick_pos + Mem->GetBall()->get_vel()).mod() >
	  (Mem->SP_kickable_area - Mem->CP_hard_kick_err) ) {
      /* kick to edge */
      Debug("  kicking to the edge\n");
      edge_traj = edge_vec - Mem->GetBall()->get_pos();
      dokick(edge_traj.dir(), edge_traj.mod(), FALSE);
      return 2;
    }

    /* we can't get to edge, just kick it hard along path */
    /* SMURF - for now, just kick as hard as possible and end up on path
       we actually need to make sure we get one more accelerate kick, but
       we'll worry about that later */
    /* SNORK - this is really the wrong thing to do - should kick to path */
    Debug("  normal accel kick- SNORK\n");
    dokick(dir, Mem->SP_ball_speed_max, FALSE);
    return 1;
  } else {
    printf("kick_hard_straight called with bad step. oops!\n");
    return -1;
  } 
  
} 


/*******************************************************/

#ifdef NEVER

int is_straight_kick(float dir, Object* pball)
{
  float tmpdir;
  Vector btraj = Polar2Vector(Mem->CP_opt_ctrl_dist, dir) - pball->rpos;
  float ndir = btraj.dir();
  float bdir = pball->rpos.dir();
  ndir = NormalizeAngleDegle(ndir - bdir);

  tmpdir = 90 + ACos((Mem->SP_playersize+2*Mem->SP_ballsize)/pball->rpos.mod());
  if (fabs(ndir) < tmpdir ||
      btraj.mod() < Sqr(pball->rpos.mod()) -
      Sqr(Mem->SP_playersize+2*Mem->SP_ballsize))    {
    return 1;
  } else return 0;
} 


/* Do an internal simulation of the ball trajectory */
/* updates rpos, vel, dir, dist */
int ballstep(Object* pball, float power, float angle) {
  int collision = 0;
  if (pball->time < last_time_seen)
    return 0;
  if (power > 0)
    pball->vel += Polar2Vector(power*get_effkickpowrate(*pball), angle);
  pball->rpos += pball->vel;
  if (pball->rpos.mod() < Mem->SP_playersize + Mem->SP_ballsize) {
    /* this code could seem not new... */
    float r = Mem->SP_ballsize + Mem->SP_playersize;
    float d = pball->rpos.mod();
    float th = fabs(NormalizeAngleDegle(pball->vel.dir() - pball->rpos.dir()));
    float l1 = d * Cos(th);
    float h = d * Sin(th);
    float cosp = h / r;
    float sinp = sqrt(1.0 - Sqr(cosp));
    float l2 = r * sinp;
    pball->rpos += pball->vel*(-(l1+l2)/Max(pball->vel.mod(), 1.0e-10));
    pball->vel *= -0.1;
    collision = 1;
    Debug("COLLISION!\n");
  }
  pball->vel *= Mem->SP_balldecay;
  pball->dist = pball->rpos.mod();
  pball->dir  = (int)(pball->rpos.dir());  
  pball->time++;
  return collision;
}

/* Estimate realtive ball position and speed */
void estimate_state(Object* pobj) {
  sigprocmask(SIG_BLOCK, &sigiomask, NULL);
  pobj->rpos = Polar2Vector(pobj->dist, pobj->dir);
  if (SeenObj(*pobj)) {
    if (ChInfo(*pobj)) {
      Debug("   estimate_state: have change info\n");
      pobj->vel = estimate_objvel(pobj);
    } else if (pobj->dist > 4) {
      Debug("   estimate_state: too far away- assuming no movemnet\n");
      pobj->vel = 0;
    } else
      Debug("   estimate_state: using old vel vector\n");
  } else {
    Debug("  estimate_state: object not seen!\n");
    pobj->vel = 0;
  } 
}

/* Estimate object relative speed */
Vector estimate_objvel(Object *pobj) 
{
  return Vector(pobj->distch, pobj->dist*Tan(pobj->dirch)).rotate(pobj->dir);
}


#endif






