/* -*- Mode: C++ -*- */

#include "client.h"
#include "behave.h"
#include "setplay.h"
#include "kick.h"
#include "dribble.h"

/*****************************************************************************************/

void execute_setplay(){
  if ( !Mem->InSetPlay ) my_error("should only be here if in set play");

  Mem->LogAction2(20,"setplay executing");

  if ( !Mem->CoachActive && Mem->PlayMode != PM_Play_On ){
    /**** confirm starter ****/
    /**** Only need this if there isn't an on-line coach to say where the ball is ****/
    /**** Even so, only need when the ball position is ambiguous ****/
    Pnum    spStarterPos = Mem->SetPlayStarterPosition();

    if ( spStarterPos != Pnum_Unknown && Mem->Confirmed_Setplay_Starter == Unum_Unknown ){  
      /* there is a starter */
      Unum player = Mem->PositionPlayer(spStarterPos);
      Mem->LogAction4(30,"execute_setplay: %d in position %d is the starter",player,spStarterPos);
      if ( player == Unum_Unknown ){
	if ( Mem->SetPlayLastSpoke == 0 || 
	     Mem->CurrentTime - Mem->SetPlayLastSpoke > Mem->CP_Setplay_Say_Delay ){
	  Mem->SayToPosition(spStarterPos,PMsg_ping);
	  Mem->SetPlayLastSpoke = Mem->CurrentTime;
	}
      }
      else if ( Mem->Confirmed_Setplay_Starter == Unum_Unknown ){
	if ( Mem->CurrentTime - Mem->SetPlayInvokeTime > Mem->SetPlayTimeLimit/4 &&
	     (Mem->PlayMode == PM_My_Kick_In || Mem->PlayMode == PM_My_Free_Kick ||
	      Mem->PlayMode == PM_My_Goalie_Free_Kick) ){
	  /* Only have to worry if ball's position could be in doubt */
	  /*printf("%d:%d Going to have to reinitialize (time)\n",
	    Mem->MyNumber,Mem->CurrentTime);*/
	  Mem->LogAction2(40,"execute_setplay: ending setplay since no confirmed starter");
	  Mem->EndSetPlay(); /* force reinitialization */
	  return;
	}
	else if ( Mem->CurrentTime - Mem->SetPlayInvokeTime > 10 ){
	  if ( Mem->SetPlayLastSpoke == 0 || 
	       Mem->CurrentTime - Mem->SetPlayLastSpoke > Mem->CP_Setplay_Say_Delay ){
	    Mem->LogAction2(40,"execute_setplay: pinging starter");
	    Mem->SayToPlayer(player,PMsg_Setplay_Ping_Starter);  /* Wait before forcing starter issue */
	    Mem->SetPlayLastSpoke = Mem->CurrentTime;
	  }
	}
      }
    }
  }
  /**** end confirm starter ****/

  if ( Mem->SetPlayStartTime == 0 ){
    Mem->LogAction2(30,"execute_setplay: setplaystarttime == 0");
    setplay_prepare();
    return;
  }

  if ( Mem->BallKickable() || Mem->GotBallInSetPlay ){
    Mem->LogAction2(30,"execute_setplay: ball kickable or got ball");
    setplay_kick();
    return;
  }

  setplay_wait();

  if ( Mem->CurrentTime - Mem->SetPlayStartTime >= Mem->SetPlayTimeLimit ){
    Mem->LogAction3(30,"execute_setplay: time limit up %d",Mem->CurrentTime - Mem->SetPlayStartTime);
    Mem->EndSetPlay();
  }
}



/*****************************************************************************************/
/*****************************************************************************************/
/*****************************************************************************************/

void setplay_prepare()
{
  Mem->LogAction2(20,"setplay preparing");

  SPAtype spPosType = Mem->MySetPlayPositionType();
  Pnum    spStarterPos = Mem->SetPlayStarterPosition();
  if ( Mem->SetPlayStartTime != 0 ) my_error("shouldn't be here if setplay started");

  Bool AdjustForOffsides = TRUE;
  if ( Mem->SetPlayType() == PM_My_Corner_Kick || Mem->SetPlayType() == PM_My_Kick_Off ||
       Mem->SetPlayType() == PM_Their_Free_Kick || Mem->SetPlayType() == PM_Their_Goalie_Free_Kick ||
       Mem->SetPlayType() == PM_Their_Goal_Kick || Mem->SetPlayType() == PM_My_Goalie_Free_Kick  ||
       Mem->SetPlayType() == PM_Their_Corner_Kick)
    AdjustForOffsides = FALSE;

  Bool starter_ready_to_go = FALSE;
  if ( spPosType == SPA_Starter ){
    /* call Pat's set-up for shot function */
    if ( Mem->PlayMode == PM_My_Kick_Off || Mem->goalie_after_catch ) /* kickoff or goalie catch */
      starter_ready_to_go = TRUE; /* moved there */
    if ( !starter_ready_to_go ){
      /* starter_ready_to_go = go_to_static_ball(Mem->MySetPlayAimPoint()); */
      Vector dest = Mem->MySetPlayAimPoint(AdjustForOffsides);
      Vector traj = dest - Mem->BallAbsolutePosition();
      starter_ready_to_go = go_to_static_ball(traj.dir());
    }
    else {
      Mem->LogAction2(40,"setplay_prepare: I'm starter -- ready to go");
      scan_field_with_neck();
    }
  }
  else{
    if ( Mem->InMySetPlayPosition(AdjustForOffsides) ){
      Mem->LogAction2(40,"setplay_prepare: in position");
      if ( Mem->SetPlayType() == PM_Their_Goalie_Free_Kick || Mem->SetPlayType() == PM_Their_Goal_Kick) 
	/* need to see where goalie moves to and/or when the ball moves */
	face_neck_and_body_to_ball();
      else
	scan_field_with_body();
    }
    else{
      if ( Mem->PlayMode == PM_Play_On && Mem->HaveBeenInSetPlayPosition == FALSE ){
	Mem->LogAction2(40,"setplay_prepare: couldn't get to position on time");
	Mem->EndSetPlay(); /* couldn't get there in time */
	return;
      }
      else{
#ifndef NO_ACTION_LOG
	Vector pos = Mem->MySetPlayHome(AdjustForOffsides);
	Mem->LogAction4(40,"setplay_prepare: going to position (%.1f,%.1f)",pos.x,pos.y);
#endif
	go_to_point(Mem->MySetPlayHome(AdjustForOffsides),Mem->MySetPlayPositionBuffer(),40);
      }
    }
  }

  Bool tmp = (Mem->Player_Setplay_Ready[Mem->MyNumber] == SPnum_Unknown && /* no ack yet         */
       spStarterPos != Unum_Unknown &&                              /* no point in saying */
       spPosType != SPA_Starter &&
       Mem->InMySetPlayPosition(AdjustForOffsides)) ? TRUE : FALSE;

  //  if ( Mem->Player_Setplay_Ready[Mem->MyNumber] == SPnum_Unknown && /* no ack yet         */
  //     spStarterPos != Unum_Unknown &&                              /* no point in saying */
  //       spPosType != SPA_Starter &&
  //       Mem->InMySetPlayPosition(TRUE) ){           
  if ( tmp ){
    if ( Mem->SetPlayLastSpoke == 0 || 
	 Mem->CurrentTime - Mem->SetPlayLastSpoke > Mem->CP_Setplay_Say_Delay ){
      /* Don't always say ready or else all the messages collide */
      Mem->LogAction2(40,"setplay_prepare: saying 'ready'");
      Mem->Say(PMsg_Setplay_Ready,Mem->MySetPlayPosition());
      Mem->SetPlayLastSpoke = Mem->CurrentTime;
    }
  }
  else{
    ;
  }
  
  /* If you're the one near the ball, wait until everyone's in position */
  if ( spPosType == SPA_Starter ){
    if ( starter_ready_to_go && Mem->AllInSetPlayPosition(AdjustForOffsides) && !Mem->ClockStopped ){
      Mem->LogAction2(40,"setplay_prepare: all ready -- choosing action and kicking");
      Mem->ModifySetPlayStartAction();          /* Choose best of 1st 2 */
      if ( Mem->goalie_after_catch && !Mem->goalie_moved_after_catch ){
	Mem->LogAction2(40,"Goalie moving before kicking");
	if ( Mem->PositionSetPlayY(Mem->MySetPlayAimPosition()) > 0 )
	  move(Mem->MyRightGoalKickSpot);
	else 
	  move(Mem->MyLeftGoalKickSpot);
	Mem->goalie_moved_after_catch = TRUE;
	return;
      }
      else if ( Mem->goalie_after_catch && !Mem->BallKickable() ){
	Mem->LogAction2(40,"Goalie waiting to realize the ball's moved too");
	face_neck_to_ball(); /* I've moved but I don't yet know the ball's with me */
	if ( Mem->PlayMode != PM_Play_On )
	  return;
      }
      else{
	setplay_kick();
	return;
      }
    }
    else if (Mem->CurrentTime - Mem->SetPlayInvokeTime > Mem->SetPlayTimeLimit && !Mem->ClockStopped ){
      Mem->LogAction2(40,"setplay_prepare: time up -- choosing action and kicking");
      Mem->ModifySetPlayStartAction();          /* Choose best of 1st 2 */
      if ( Mem->goalie_after_catch && !Mem->goalie_moved_after_catch ){
	Mem->LogAction2(40,"Goalie moving before kicking");
	if ( Mem->PositionSetPlayY(Mem->MySetPlayAimPosition()) > 0 )
	  move(Mem->MyRightGoalKickSpot);
	else 
	  move(Mem->MyLeftGoalKickSpot);
	Mem->goalie_moved_after_catch = TRUE;
      }
      else if ( Mem->goalie_after_catch && !Mem->BallKickable() ){
	Mem->LogAction2(40,"Goalie waiting to realize the ball's moved too");
	face_neck_to_ball(); /* I've moved but I don't yet know the ball's with me */
	if ( Mem->PlayMode != PM_Play_On )
	  return;
      }
      else{
	setplay_kick();
	return;
      }
    }	
    else if ( Mem->goalie_after_catch && Mem->MyX() > Mem->FieldRectangle.LeftX() + Mem->SP_catch_area_l )
      scan_field_with_body();
    /* 
       else{
       Mem->CheckForPlayersInMyPosition();
       }
       */
  }
  else{ /* Not the starter */
    if ( Mem->CurrentTime - Mem->SetPlayInvokeTime > Mem->SetPlayTimeLimit && !Mem->ClockStopped &&
	 Mem->BallKickable() ){  
      Mem->LogAction2(40,"setplay_prepare: time up -- not starter, so just putting ball in play");
      hold_ball(); /* just to put it in play */
      Mem->EndSetPlay();
    }
    /*Mem->CheckForPlayersInMyPosition();*/
  }

  if ( Mem->PlayMode == PM_Play_On || 
       ((Mem->PlayMode == PM_My_Goal_Kick || Mem->PlayMode == PM_Their_Goal_Kick)) &&  Mem->BallMoving() ){ 
    Mem->LogAction2(40,"setplay_prepare: set play started (in Play_on mode or ball moving)");
    Mem->SetPlayStartTime = Mem->CurrentTime; /* Time that ball was put into play */
    if ( Mem->MySetPlayWaitTime() == 0 ) {
      Mem->LogAction2(30,"setplay_prepare: time up -- ending play");      
      Mem->EndSetPlay();
    }
  }
}

/*****************************************************************************************/

void setplay_wait()
{
  if ( Mem->CurrentTime - Mem->SetPlayStartTime > Mem->MySetPlayWaitTime() ){
    Mem->LogAction2(30,"setplay_wait: time up -- ending play");
    Mem->EndSetPlay();
    return;
  }

  if ( Mem->FastestTeammateToBall() == Mem->MyNumber ){
    Mem->LogAction2(30,"setplay_wait: I'm fastest -- going to ball");
    get_ball();
    return;
  }

  face_neck_and_body_to_ball();
  Mem->LogAction2(30,"setplay_wait: I'm not fastest to ball");
}

/*****************************************************************************************/

void setplay_kick()
{
  /* Play has started */

  if ( !Mem->BallKickable() ){
    if ( Mem->MyInterceptionAble() && 
	 (Mem->MyInterceptionNumberCycles() <= 2 || Mem->BallDistance() <= Mem->SP_kickable_area+2) ){
      Mem->LogAction2(30,"setplay_kick: lost control, retrieving and continuing");
      get_ball();      
    }
    else {
      Mem->LogAction2(30,"setplay_kick: lost control, ending play");
      if ( Mem->MyInterceptionAble() ) get_ball();
      Mem->EndSetPlay();
    }
    return;
  }

  change_view(VW_Narrow);
  Mem->ChangeViewForHandleBallTime = Mem->CurrentTime;

  if ( Mem->KickInProgress() ){
    Mem->LogAction2(30,"setplay_kick: continuing kick");
    /* Already kicking */
    smart_kick_hard_abs(Mem->kick_in_progress_abs_angle,Mem->kick_in_progress_mode,
			Mem->kick_in_progress_target_vel,Mem->kick_in_progress_rotation);
    return;
  }

  Pnum position = Mem->MySetPlayAimPosition();
  Unum player   = Unum_Unknown;
  Vector aim_point;

  Bool AdjustForOffsides = TRUE;
  if ( Mem->SetPlayType() == PM_My_Corner_Kick || Mem->SetPlayType() == PM_My_Kick_Off ||
       Mem->SetPlayType() == PM_Their_Free_Kick || Mem->SetPlayType() == PM_Their_Goalie_Free_Kick ||
       Mem->SetPlayType() == PM_Their_Goal_Kick || Mem->SetPlayType() == PM_My_Goalie_Free_Kick  ||
       Mem->SetPlayType() == PM_Their_Corner_Kick)
    AdjustForOffsides = FALSE;

  if ( Mem->MySetPlayPositionType() == SPA_Shooter )
    AdjustForOffsides = FALSE;  /* still go for the goal */

  if ( position == Pnum_Unknown ){ /* We're going for a point */
    aim_point = Mem->MySetPlayAimPoint(AdjustForOffsides);
  }
  else {                              /* We're going for a player */
    player = Mem->PositionPlayer(position);
    if ( player == Unum_Unknown )
      my_error("Should know who's playing the position");
  } 

  switch( Mem->MySetPlayPositionType() ){
  case SPA_Shooter:
    Mem->LogAction4(40,"setplay_kick: shooter starting kick to (%.1f %.1f)",aim_point.x,aim_point.y);
    kick_ball(aim_point,Mem->ShotMode(), TURN_CLOSEST);
    break;
  case SPA_Getter:
    Mem->LogAction2(40,"setplay_get: getter ending set play");
    SmartDribbleTo(aim_point);
    Mem->EndSetPlay();
    break;
  case SPA_Starter:
    /* Assuming the starter either passes or knocks */
    if ( player != Unum_Unknown ){
      /* otherwise, just end */
      if ( Mem->TeammatePositionValid(player) && Mem->PositionInSetPlayPosition(position,AdjustForOffsides) ){
	Mem->LogAction3(40,"setplay_kick: starter starting pass to %d",player);
	pass_ball(player,1.5);
	Mem->SetPlayStartTime = Mem->CurrentTime; /* Time that mode is changed to PLAY_ON */
      }
      else{
	Mem->LogAction3(40,"setplay_kick: starter just putting in play -- %d not ready",player);
	hold_ball(); /* just to put it in play */
	Mem->SetPlayStartTime = Mem->CurrentTime; /* Time that mode is changed to PLAY_ON */
	Mem->EndSetPlay();
      }
    }
    else {
      Mem->LogAction4(40,"setplay_kick: starter just kicking to (%.1f %.1f)",aim_point.x,aim_point.y);
      kick_ball(aim_point);
    }
    break;
  case SPA_Passer:
    if ( Mem->TeammatePositionValid(player) && Mem->PositionInSetPlayPosition(position,AdjustForOffsides) ){
      Mem->LogAction3(40,"setplay_kick: passer starting pass to %d",player);
      pass_ball(player);
    }
    else{
      Mem->LogAction3(40,"setplay_kick: passer just putting into play -- %d isn't ready",player);
      hold_ball(); /* just to put it in play */
      Mem->EndSetPlay(); /* next player isn't ready */
    }
    break;
  case SPA_Knocker:
    Mem->LogAction4(40,"setplay_kick: knocker kicking to (%.1f %.1f)",aim_point.x,aim_point.y);
    kick_ball(aim_point,KM_Moderate);
    break;
  case SPA_Blaster:
    Mem->LogAction4(40,"setplay_kick: blaster kicking to (%.1f %.1f)",aim_point.x,aim_point.y);
    kick_ball(aim_point,KM_QuickestRelease);
    break;
  default: my_error("what's my set play position type???");
  }

  Mem->GotBallInSetPlay = TRUE;
}

