/* -*- Mode: C++ -*- */

/* test.h
 * CMUnited99 (soccer client for Robocup99)
 * Peter Stone <pstone@cs.cmu.edu>
 * Computer Science Department
 * Carnegie Mellon University
 * Copyright (C) 1999 Peter Stone
 *
 * CMUnited-99 was created by Peter Stone, Patrick Riley, and Manuela Veloso
 *
 * You may copy and distribute this program freely as long as you retain this notice.
 * If you make any changes or have any comments we would appreciate a message.
 */


#ifndef _BEHAVE_TEST_H_
#define _BEHAVE_TEST_H_

#include "geometry.h"

void test_scan_with_body();
void test_random_movement_in_rectangle(Rectangle *rect);
void test_1v1();
void test_volley();
void test_go_to_ball(AngleDeg kick_angle);
void test_go_to_ball();
void test_go_to_point(Vector p, float buffer, float dash_power = 100);
void test_face_ball();
void test_random_movement();
void test_straight_to_ball();
void test_run_straight();
void test_turn_and_dash_slow();
void test_print_ball();
void test_print_positions();
void test_turnball();
void test_turnball2();
void test_hard_kick(KickMode km);
void test_intercept();
void test_go_to_static_ball();
void test_pred_cycles_to_point();

#ifndef RELEASE_VERSION  

void test_DT();
Unum test_control();
void test_2v3(Rectangle *rect);
void test_get_open_in_rectangle(Rectangle *rect);
void test_dodge();
void test_play();
void test_say();
void test_go_to_position();
void test_move();
void test_time();
void test_good_pass();
void test_print_mode();
void test_shot(KickMode km);


void test_breakaway();
Bool test_evaluate_kick_run_angle(AngleDeg ang, Unum oppGoalie, Vector* pTarg);
  //void test_breakaway_kick_ball(Vector point, KickMode mode = KM_Moderate, TurnDir rotation = TURN_AVOID);
#endif // RELEASE_VERSION

#endif
