/* -*- Mode: C++ -*- */

/* behave.h
 * CMUnited99 (soccer client for Robocup99)
 * Peter Stone <pstone@cs.cmu.edu>
 * Computer Science Department
 * Carnegie Mellon University
 * Copyright (C) 1999 Peter Stone
 *
 * CMUnited-99 was created by Peter Stone, Patrick Riley, and Manuela Veloso
 *
 * You may copy and distribute this program freely as long as you retain this notice.
 * If you make any changes or have any comments we would appreciate a message.
 */


#ifndef _BEHAVE_H_
#define _BEHAVE_H_

#include "geometry.h"
#include "types.h"

void behave();

ActionQueueRes scan_field_with_body();
void turn_neck_to_relative_angle(AngleDeg ang);
void scan_field_with_neck();

ActionQueueRes face_only_body_to_point(Vector point);
void           face_only_neck_to_point(Vector point);
ActionQueueRes face_neck_to_point(Vector point);
ActionQueueRes face_neck_and_body_to_point(Vector point);

ActionQueueRes face_only_body_to_player(char side, Unum num);
void           face_only_neck_to_player(char side, Unum num);
ActionQueueRes face_neck_to_player(char side, Unum num);
ActionQueueRes face_neck_and_body_to_player(char side, Unum num);

ActionQueueRes face_only_body_to_opponent(Unum opponent);
void           face_only_neck_to_opponent(Unum opponent);
ActionQueueRes face_neck_to_opponent(Unum opponent);
ActionQueueRes face_neck_and_body_to_opponent(Unum opponent);

ActionQueueRes face_only_body_to_teammate(Unum teammate);
void           face_only_neck_to_teammate(Unum teammate);
ActionQueueRes face_neck_to_teammate(Unum teammate);
ActionQueueRes face_neck_and_body_to_teammate(Unum teammate);

ActionQueueRes face_only_body_to_ball();
void           face_only_neck_to_ball();
ActionQueueRes face_neck_to_ball();
ActionQueueRes face_neck_and_body_to_ball();

#ifndef RELEASE_VERSION  
void watch_pass();
void move_to_position();
#endif // RELEASE_VERSION
void get_ball();
void stop_ball();
void hold_ball();
void pass_ball(Unum teammate, float target_vel=1.0);
void kick_ball(AngleDeg target_angle, KickMode mode, float targ_vel,
	       TurnDir rotation = TURN_NONE);
void kick_ball(Vector point, KickMode mode, float targ_vel,
	       TurnDir rotation = TURN_NONE);
void kick_ball(AngleDeg target_angle, KickMode mode = KM_Moderate,
	       TurnDir rotation = TURN_NONE);
void kick_ball(Vector point, KickMode mode = KM_Moderate,
	       TurnDir rotation = TURN_NONE);

#ifndef RELEASE_VERSION  
ActionQueueRes breakaway_look_for_shot(Unum oppGoalie);
void breakaway_pick_target(Unum oppGoalie, Vector approach_pt, int kick_run_cycles);
Bool breakaway_evaluate_kick_run_angle(AngleDeg ang, Unum oppGoalie,
				       int kick_run_cycles, Vector* pTarg);

void handle_ball();
void get_on_sides();
void go_to_position();
void support_ball();
#endif // RELEASE_VERSION
ActionQueueRes go_to_point(Vector p, float buffer = 0, float dash_power = 100, DodgeType dodge = DT_all);

#ifndef RELEASE_VERSION  
void mark_opponent(Unum opp, float dist);
void track_opponent(Unum opp, float dist);
ActionQueueRes get_open_in_rectangle(Rectangle *rect);
ActionQueueRes get_open_for_pass_from_in_rectangle(Rectangle *rect,Vector from);
void passive_defend();
void auxiliary_defend();
void active_defend();

ActionQueueRes move_to_point_in_between(Vector pt1, Vector pt2,
			      float pt1dist, float dash_power = 100);
inline ActionQueueRes move_to_point_in_between(Vector pt1, float ang,
				     float pt1dist, float dash_power = 100)
{
  return move_to_point_in_between(pt1, pt1 + Polar2Vector(1000, ang),
				  pt1dist, dash_power);
}

ActionQueueRes move_in_between(Vector pt1, Vector pt2, float dash_power = 100);
inline ActionQueueRes move_in_between(Vector pt1, float ang, float dash_power = 100)
{
  return move_in_between(pt1, pt1 + Polar2Vector(1000, ang), dash_power);
}


ActionQueueRes defensive_block_opponent(Unum opponent,float dash_power,Vector block_targ);
void clear_ball();
void send_ball();
#endif // RELEASE_VERSION

#endif
