/* -*- Mode: C++ -*- */

/* behave.C
 * CMUnited99 (soccer client for Robocup99)
 * Peter Stone <pstone@cs.cmu.edu>
 * Computer Science Department
 * Carnegie Mellon University
 * Copyright (C) 1999 Peter Stone
 *
 * CMUnited-99 was created by Peter Stone, Patrick Riley, and Manuela Veloso
 *
 * You may copy and distribute this program freely as long as you retain this notice.
 * If you make any changes or have any comments we would appreciate a message.
 */


#include <fstream.h>
#include "behave.h"
#include "Memory.h"
#include "client.h"
#include "test.h"
#include "kick.h"
#include "dribble.h"
#ifndef RELEASE_VERSION  
#include "intercept.h"
#include "goalie.h"
#include "setplay.h"
#endif // RELEASE_VERSION

#define DebugMark(x) 

#ifdef DEBUG_OUTPUT
#define DebugBlock(x) x
#else
#define DebugBlock(x) 
#endif

//#define MAKE_DEMO
//#define TEST_PETER
//#define TEST_PAT
//#define TEST_PAT2

void behave(){
#ifndef RELEASE_VERSION  

  if ( !Mem->ClockStopped && Mem->CurrentTime-1 != Mem->LastBehaveTime && Mem->LastBehaveTime != 0 )
    my_error("Missed a behave cycle!!  (%d %d)",Mem->LastBehaveTime.t,Mem->LastBehaveTime.s);
  Mem->LastBehaveTime = Mem->CurrentTime;
  
  if ( Mem->MyConf() && Mem->BallPositionValid() && Mem->BallDistance() < Mem->SP_player_size/2 ){
    my_error("How did the ball get so close???");
    if ( Mem->PlayMode == PM_My_Goalie_Free_Kick ){
      Mem->LogAction2(200,"moving with the ball to their goal");
      return;
    }
  }

#ifdef TEST_PAT2
  static Bool First_time = TRUE;
  static ofstream outfile;

  if ( First_time ){
    if (!Mem->CP_goalie) {
      char fn[MAX_FP_LEN];
      sprintf(fn, "Logfiles/%s-%d-cont.log", Mem->MyTeamName, Mem->MyNumber);
      outfile.open(fn);
      if (!outfile)
	my_error("test_2v3: could not open the outfile");
    }
    
    First_time=FALSE;
    //return;
  }

  if (Mem->CurrentTime.s == 0 && !Mem->CP_goalie &&
      Mem->MyConf() && Mem->BallPositionValid()) {
    //Unum cont = Mem->PlayerWithBall();
    Unum cont = Mem->BallPossessor();
    if (Mem->MySide == 'l')
      cont = -cont;
    outfile << Mem->CurrentTime.t << '\t'
	    << (Mem->MySide == 'l' ? -Mem->MyNumber : Mem->MyNumber)
	    << '\t' << cont << endl;
  }
#endif

#ifdef TEST_PETER
  //test_scan_with_body();
  //test_go_to_point(30,0);
  //return;

//   if ( Mem->PlayMode == PM_Before_Kick_Off ){
//     move(-1,0);
//     my_stamp; printf("%.1f\n",Mem->MyBodyAng());
//     return;
//   }

  //turn(Mem->CurrentTime.t%2 ? 90 : -90);
  //turn_neck(Mem->CurrentTime.t%2 ? 90 : -90);
  //my_stamp; printf("        %.1f\n",Mem->MyBodyAng());
  
  //test_1v1();
  //test_volley();
  //return;

  static Rectangle *rect = new Rectangle(Vector(0,0),Vector(30,30));
  test_2v3(rect);
  return;

  if ( 1 || Mem->TestVersion){
    test_random_movement_in_rectangle(rect);
    return;
  }
  else if ( Mem->PlayMode==PM_Play_On && Mem->MyConf() && Mem->BallPositionValid() &&
	    Mem->OpponentPositionValid(1) ){
    mark_opponent(1,3);
    return;
  }
  else if ( Mem->PlayMode==PM_Play_On ){
    scan_field_with_body();
    my_stamp; printf("not marking\n");
    return;
  }

  delete rect;
#endif

#ifdef TEST_PAT
  //PatsTest_kick();
  //PatsTest_kick2();
  //PatsTest_turn();
  //PatsTest_int();
  //Mem->TestPred2();
  //Mem->TestPred();
  //Mem->TestPosVelEst();
  //PatsTest_dribble2();
  //PatsTest_BPI();
  //PatsTest_1v1();
  //CalcStaticKickAngle();
  //goalie_behave();
  //test_goalie();

  //test_turnball();
  //test_turnball2();
  test_hard_kick(KM_Moderate);
  //test_hard_kick(KM_HardestKick);
  //test_1v1();
  //test_intercept((Bool)(Mem->MySide == 'l'));
  //test_intercept();
  //PatsTest_dribble();
  //test_go_to_static_ball();
  //test_pred_cycles_to_point();
  //test_shot(KM_HardestKick);
  //test_breakaway();
  
  /*
  if (Mem->PlayMode == PM_Before_Kick_Off &&
      (!Mem->MyConf() || !Mem->FieldRectangle.IsWithin(Mem->MyPos()))) {
    move(-10 - 2 * Mem->MyNumber,0);
  } else {
    ;
  }
  */

  /* test whether we can send lots of commands */
  /* turn (-90);
  turn_neck (range_random(-10, 10) - Mem->MyNeckRelAng());
  change_view(Mem->ViewWidth == VW_Normal ? VW_Wide : VW_Normal);
  */
  
  //if (Mem->ViewWidth != VW_Wide)
  //  change_view(VW_Wide);

  //if (!(Mem->MySide == 'l' && Mem->MyNumber == 2)) //for test_breakaway defender
  return;
#endif

  Mem->ReactToScoreAndTime();

  /* set that I'm tired before choosing action mode */
  if ( Mem->Tired() && Mem->NeedToAnnounceTired() ){
    Mem->Say(PMsg_tired);
    Mem->SetAnnouncedTired(Mem->CurrentTime);
  }

  if ( Mem->NeedToInitializeSetPlay() ){
    Mem->InitializeSetPlay();
  }
  else if ( Mem->SetPlay && !Mem->InSetPlay && 
	    (Mem->PlayMode == PM_Play_On || Mem->CurrentTime-Mem->PlayModeTime > Mem->CP_Setplay_Max_Delay) )
    Mem->EndSetPlay();

  Mem->UpdateActionMode();

  //my_stamp; printf("mode %d\n",Mem->MyActionMode);

  /* if we're the sweeper and we're in a dangerous defensive situation, warn the goalie */
  if (Mem->MyPositionType() == PT_Sweeper &&
      Mem->BallPositionValid() && Mem->BallVelocityValid() &&
      IsShot() && Mem->GoalieWarnTime < Mem->CurrentTime - Mem->CP_goalie_warn_space) {
    Mem->SayToPlayer(Mem->FP_goalie_number, PMsg_none);
    Mem->GoalieWarnTime = Mem->CurrentTime;
    //my_stamp; printf("warning goalie of shot\n");
  }

  /* Make sure teammate knows ball is coming */
  if ( 0 && Mem->BallPositionValid() && Mem->BallMoving() ){
    Unum fastest = Mem->FastestTeammateToBall();
    if ( fastest != Unum_Unknown && fastest != Mem->MyNumber && Mem->TeammateNeckAngleValid(fastest) && 
	 Mem->TeammatePositionValid(fastest) ){
      AngleDeg teammate_face = (Mem->BallAbsolutePosition() - Mem->TeammateAbsolutePosition(fastest)).dir();
      if ( fabs( GetNormalizeAngleDeg(teammate_face - Mem->TeammateAbsoluteNeckAngle(fastest)) ) > 45 ){
	Mem->SayToPlayer(fastest,PMsg_none);
	my_stamp; printf("allerting %d of ball\n",fastest);
      }
    }
  }

  /* find out who the player nearby is */
  if ( Mem->MyConf() && Mem->NumTeamlessPlayers() > 0 && 
       Mem->DistanceTo(Mem->ClosestTeamlessPlayerPosition()) < Mem->SP_feel_distance )
    Mem->Say(PMsg_ping);

  /* Closest 2 players should say something if they think ball possession is changing */
  Unum possessor = Mem->BallPossessor();
  if ( Mem->MyConf() && Mem->BallPositionValid() &&
       Mem->NumTeammatesCloserToBall() <= 1 && possessor != Mem->LastBallPossessor &&
       Mem->LastBallPossessorTime == Mem->CurrentTime-1 && 
       Mem->BallVelocityValid() >= Mem->CP_ball_conf_decay )
    Mem->Say(PMsg_none);
  Mem->LastBallPossessor = possessor;
  Mem->LastBallPossessorTime = Mem->CurrentTime;

  /*int ChangeTime = 150;
  int NumFormations = 6;
  if ( Mem->CurrentTime.t>10 && (Mem->CurrentTime.t)%ChangeTime < 7){
    Ftype newFormationType = ((Mem->CurrentTime.t/ChangeTime)%NumFormations)+1;
    Mem->SetFormation(newFormationType,Mem->CurrentTime);
  }*/

#ifdef MAKE_DEMO
  /* log01.log */
  /*if ( Mem->CurrentTime > 100 ){ 
    face_ball(); 
    return;
  }*/
  /* log02.log, log03.log */
  if ( Mem->BallKickable() && !Mem->CP_goalie ){
    if ( Mem->KickInProgress() ){
      smart_kick_hard_abs(Mem->kick_in_progress_abs_angle,Mem->kick_in_progress_mode,
			  Mem->kick_in_progress_target_vel,Mem->kick_in_progress_rotation);
    }
    else if (Mem->BallX() < -20 ) 
      TurnballTo(GetNormalizeAngleDeg(Mem->BallAngle() + 180));
    else if ( Mem->BallX() < 10 ) 
      SmartDribbleTo(Vector(50,0));
    else 
      kick_ball(Mem->ShotTarget(),Mem->ShotMode());
    return;
  }
  /* log04.log */
  /* test_1v1();
  return; */
  /* log05.log */
  /* Rectangle *rect = new Rectangle(Vector(0,0),Vector(30,30));
  test_2v3(rect);
  delete rect;
  return;*/
  /* log06.log */
  /* if ( Mem->MySide == 'r' ) 
    Mem->SetFormation(FT_352,Mem->CurrentTime);
  if ( Mem->MyActionMode >= AM_With_Ball ){
    Mem->MyActionMode = AM_Offense_Passive;
  }*/
  /* log07.log - log09.log :  turn on/off marking, spar, offside */
  if ( Mem->MyActionMode == AM_With_Ball )
    return;
#endif


  switch ( Mem->MyActionMode ){
  case AM_goaltend: goalie_behave();                           break;
  case AM_Unknown: my_error("need an active mode");            break;
  case AM_Localize: scan_field_with_body();                    break;
  case AM_Face_Ball: face_neck_and_body_to_ball();             break;
  case AM_Watch_Pass: watch_pass();                            break;
  case AM_Recover: 
    my_error("recovering %.1f",Mem->MyStamina()); 
    face_neck_and_body_to_ball();                              break;
  case AM_Before_Kick_Off: move_to_position();                 break;
  case AM_Setplay: execute_setplay();                          break;
  case AM_GetOnSide: get_on_sides();                           break;
  case AM_With_Ball: handle_ball();                            break;
  case AM_Offense_Active: get_ball();                          break;
  case AM_Offense_Passive: go_to_position();                   break;
  case AM_Offense_Auxiliary: support_ball();                   break;
  case AM_Defense_Active: active_defend();                     break;
  case AM_Defense_Auxiliary: auxiliary_defend();               break;
  case AM_Defense_Passive: passive_defend();                   break;
  default: my_error("amode not defined");
  }

  if ( Mem->ChangeViewForHandleBallTime != Mem->CurrentTime && Mem->CurrentTime > 0 &&
       Mem->ChangeViewForHandleBallTime > Mem->CurrentTime-5 &&
       Mem->ViewWidth == VW_Narrow && !Mem->ChangeView.valid() ) 
    /* cycle after handling, go back to normal view */
    change_view(VW_Normal);

  if ( Mem->AmUnitCaptain(UT_Defense) )
    Mem->AssignMarks();

  Ftype formation_type = Mem->MyCurrentFormationType();
  if ( formation_type <= FT_None || formation_type > FT_left )
    my_error("Invalid formation type (%d)",formation_type);

  return;
#endif // RELEASE_VERSION
  /* SMURFSMURFMURF: other test functions to put it? */
  
  /* Put any one of these test functions in -- but only one at a time */

  /* Start one player -- move the ball around the field */
  //face_ball();

  /* Start one player, press kickoff -- it will kick to the goal */
  test_go_to_ball();

  /* Start one player, press kickoff -- it will dribble to the goal */
  //test_dribble_to_goal();

  /* Start 2 players on different teams, press 'drop ball' near one player */
  //test_1v1();

  /* Start 2 players on different teams, press 'drop ball' near one player */
  //test_volley();

  /* These are to print out the positions of objects */
  //test_print_ball();
  //test_print_positions();

  /* Start 3 players on each team and press 'drop ball' in the middle of the field */
  // Rectangle *rect = new Rectangle(Vector(0,0),Vector(30,30));
  // test_random_movement_in_rectangle(rect);
  // delete rect;
}

/*
[ 3) Collect statistics about adversaries, coach, consider formation changes, etc. :  
        maybe this in a non-acting cycle 
        (CheckForPlayersInMyPosition, DirectUnit...) ]
*/




/*****************************************************************************************/
/*****************************************************************************************/
/*****************************************************************************************/

ActionQueueRes scan_field_with_body()
{
  Mem->LogAction3(40,"scan_field_with_body (%d)",Mem->TimeToTurnForScan());
  if ( Mem->TimeToTurnForScan() ){
    turn(Mem->MyViewAngle() * 2 - Mem->CP_scan_overlap_angle);
    return AQ_ActionQueued;
  }
  else 
    return AQ_ActionNotQueued;
}

/*****************************************************************************************/

void turn_neck_to_relative_angle(AngleDeg ang)
{
  turn_neck(GetNormalizeAngleDeg(ang - Mem->MyNeckRelAng()));
}

/*****************************************************************************************/

void scan_field_with_neck()
{
  Mem->LogAction3(40,"scan_field_with_neck (%d)",Mem->TimeToTurnForScan());
  if ( Mem->TimeToTurnForScan() ){
    if ( Mem->MyNeckRelAng() >= Mem->SP_max_neck_angle-1 ) /* take into account reporting error */
      turn_neck_to_relative_angle(Mem->SP_min_neck_angle);
    else 
      turn_neck(Mem->LimitTurnNeckAngle(Mem->MyViewAngle()*2 - Mem->CP_scan_overlap_angle));
  }
}

/*****************************************************************************************/

ActionQueueRes face_only_body_to_point(Vector point)
{
  /* don't turn neck */
  Mem->LogAction4(30,"facing only body to point (%.1f %.1f)",point.x,point.y);

  /* shouldn't actually have queued actions at this point */
  AngleDeg target_rel_ang = Mem->PredictedPointRelAngFromBodyWithQueuedActions(point);

  if ( fabs(target_rel_ang) < 1 ){
    Mem->LogAction2(40,"Already close enough");
    return AQ_ActionNotQueued;
  }
  turn( target_rel_ang );
  return AQ_ActionQueued;
}

/*****************************************************************************************/

void face_only_neck_to_point(Vector point)
{
  /* don't turn body */
  Mem->LogAction4(30,"facing only neck to point (%.1f %.1f)",point.x,point.y);

  AngleDeg target_rel_ang = Mem->PredictedPointRelAngFromBodyWithQueuedActions(point);

  if ( fabs(GetNormalizeAngleDeg(Mem->MyNeckRelAng() - target_rel_ang)) < 1 ){
    Mem->LogAction2(40,"Already close enough");
    return;
  }

  if ( Mem->CanSeeAngleFromBodyWithNeck(target_rel_ang) ){
    turn_neck( Mem->LimitTurnNeckAngle(target_rel_ang - Mem->MyNeckRelAng()) );
  }
  else
    Mem->LogAction5(30,"can't face point (%.1f %.1f) with only neck (%.1f)",
		    point.x,point.y, target_rel_ang);
}

/*****************************************************************************************/

ActionQueueRes face_neck_to_point(Vector point)
{
  /* face_neck can turn body if needed */
  Mem->LogAction4(30,"facing neck to point (%.1f %.1f)",point.x,point.y);

  AngleDeg target_rel_ang = Mem->PredictedPointRelAngFromBodyWithQueuedActions(point);

  if ( fabs(GetNormalizeAngleDeg(Mem->MyNeckRelAng() - target_rel_ang)) < 1 ){
    Mem->LogAction2(40,"Already close enough");
    return AQ_ActionNotQueued;
  }

  if ( Mem->CanFaceAngleFromBodyWithNeck(target_rel_ang) ){
    Mem->LogAction2(35,"can face with neck");
    turn_neck_to_relative_angle(target_rel_ang);
    return AQ_ActionNotQueued;
  }

  /* If can't do it with just neck, turn body as much as needed to face directly */
  AngleDeg max_turn = Mem->MaxEffectiveTurn();
  if ( fabs(target_rel_ang) < max_turn ) {
    Mem->LogAction2(35,"can't face with neck, can with body");
    turn(target_rel_ang);
    turn_neck_to_relative_angle(0);
    return AQ_ActionQueued;
  }

  Mem->LogAction2(35,"can't face with neck or body alone, turning both");  
  turn(target_rel_ang);
  target_rel_ang -= max_turn;  /* The neck target_ang */

  if ( target_rel_ang < Mem->SP_min_neck_angle ){
    Mem->LogAction2(40,"couldn't face all the way");  
    turn_neck_to_relative_angle(Mem->SP_min_neck_angle);
  }
  else if ( target_rel_ang > Mem->SP_max_neck_angle ){
    Mem->LogAction2(40,"couldn't face all the way");  
    turn_neck_to_relative_angle(Mem->SP_max_neck_angle);
  }
  else 
    turn_neck_to_relative_angle(target_rel_ang);

  return AQ_ActionQueued;
}

/*****************************************************************************************/

ActionQueueRes face_neck_and_body_to_point(Vector point)
{
  /* face_neck_and_body will turn both as much as possible to the point */
  Mem->LogAction4(30,"facing neck and body to point (%.1f %.1f)",point.x,point.y);

  AngleDeg max_turn = Mem->MaxEffectiveTurn();
  AngleDeg target_rel_ang = Mem->PredictedPointRelAngFromBodyWithQueuedActions(point);

  if ( fabs(GetNormalizeAngleDeg(Mem->MyNeckRelAng() - target_rel_ang)) < 1 && fabs(target_rel_ang) < 1 ){
    Mem->LogAction2(40,"Already close enough");
    return AQ_ActionNotQueued;
  }

  if ( fabs(target_rel_ang) < max_turn ) {
    Mem->LogAction2(35,"Can get both neck and body there");
    /* Can get both neck and body there */
    face_only_body_to_point(point);
    turn_neck_to_relative_angle(0);
    return AQ_ActionQueued;
  }

  /* Turn body as much as possible and try to get neck there */
  return face_neck_to_point(point);
}

/*****************************************************************************************/

ActionQueueRes face_only_body_to_player(char side, Unum num)
{
  if ( Mem->PlayerPositionValid(side, num) ){
    return face_only_body_to_point(Mem->PlayerAbsolutePosition(side,num));
  }
  else
    return scan_field_with_body();
}

/*****************************************************************************************/

void face_only_neck_to_player(char side, Unum num)
{
  if ( Mem->PlayerPositionValid(side,num) ){
    face_only_neck_to_point(Mem->PlayerAbsolutePosition(side,num));
  }
  else
    scan_field_with_neck();
}

/*****************************************************************************************/

ActionQueueRes face_neck_to_player(char side, Unum num)
{
  if ( Mem->PlayerPositionValid(side, num) ){
    return face_neck_to_point(Mem->PlayerAbsolutePosition(side,num));
  }
  else
    return scan_field_with_body();
}

/*****************************************************************************************/

ActionQueueRes face_neck_and_body_to_player(char side, Unum num)
{
  if ( Mem->PlayerPositionValid(side, num) ){
    return face_neck_and_body_to_point(Mem->PlayerAbsolutePosition(side,num));
  }
  else
    return scan_field_with_body();
}

/*****************************************************************************************/

ActionQueueRes face_only_body_to_opponent(Unum opponent){ 
  Mem->LogAction3(30,"facing only body to opponent %d",opponent); 
  return face_only_body_to_player(Mem->TheirSide, opponent);
}

/*****************************************************************************************/

void           face_only_neck_to_opponent(Unum opponent){
  Mem->LogAction3(30,"facing only neck to opponent %d",opponent);
  face_only_neck_to_player(Mem->TheirSide, opponent);
}

/*****************************************************************************************/

ActionQueueRes face_neck_to_opponent(Unum opponent){
  Mem->LogAction3(30,"facing neck to opponent %d",opponent);
  return face_neck_to_player(Mem->TheirSide, opponent);
}

/*****************************************************************************************/

ActionQueueRes face_neck_and_body_to_opponent(Unum opponent){
  Mem->LogAction3(30,"facing neck and body to opponent %d",opponent);
  return face_neck_and_body_to_player(Mem->TheirSide, opponent);
}

/*****************************************************************************************/

ActionQueueRes face_only_body_to_teammate(Unum teammate){ 
  Mem->LogAction3(30,"facing only body to teammate %d",teammate); 
  return face_only_body_to_player(Mem->MySide, teammate);
}

/*****************************************************************************************/

void           face_only_neck_to_teammate(Unum teammate){
  Mem->LogAction3(30,"facing only neck to teammate %d",teammate);
  face_only_neck_to_player(Mem->MySide, teammate);
}

/*****************************************************************************************/

ActionQueueRes face_neck_to_teammate(Unum teammate){
  Mem->LogAction3(30,"facing neck to teammate %d",teammate);
  return face_neck_to_player(Mem->MySide, teammate);
}

/*****************************************************************************************/

ActionQueueRes face_neck_and_body_to_teammate(Unum teammate){
  Mem->LogAction3(30,"facing neck and body to teammate %d",teammate);
  return face_neck_and_body_to_player(Mem->MySide, teammate);
}

/*****************************************************************************************/

ActionQueueRes face_only_body_to_ball()
{
  Mem->LogAction2(30,"facing body to ball");
  if ( Mem->BallPositionValid() ) {
    return face_only_body_to_point(Mem->BallPredictedPositionWithQueuedActions());
  }
  else 
    return scan_field_with_body();
}

/*****************************************************************************************/

void face_only_neck_to_ball()
{
  Mem->LogAction2(30,"facing only neck to ball");
  if ( Mem->BallPositionValid() ) {
    face_only_neck_to_point(Mem->BallPredictedPositionWithQueuedActions());
  }
  else 
    scan_field_with_neck();
}

/*****************************************************************************************/

ActionQueueRes face_neck_to_ball()
{
  Mem->LogAction2(30,"facing neck to ball");
  if ( Mem->BallPositionValid() ) {
    return face_neck_to_point(Mem->BallPredictedPositionWithQueuedActions());
  }
  else 
    return scan_field_with_body();
}

/*****************************************************************************************/

ActionQueueRes face_neck_and_body_to_ball()
{
  Mem->LogAction2(30,"facing neck and body to ball");
  if ( Mem->BallPositionValid() ) {
    return face_neck_and_body_to_point(Mem->BallPredictedPositionWithQueuedActions());
  }
  else 
    return scan_field_with_body();
}

#ifndef RELEASE_VERSION  

/*****************************************************************************************/

void watch_pass()
{
  if ( !Mem->VP_train_DT || !Mem->TrainingPassInProgress() ) my_error("shouldn't be watching ball");
  /*
  switch(Mem->TrainingPassType()){
  case PT_point: turn(Mem->AngleTo(Mem->TrainingPassTargetPoint())); break;
  case PT_teammate: face_teammate(Mem->TrainingPassTargetTeammate()); break;
  default: my_error("don't know that pass type");
  }
  */
  face_neck_to_ball();
  Mem->MonitorTrainingPass();
}

/*****************************************************************************************/

void move_to_position()
{
  if ( Mem->MyPosition() == Pnum_Unknown ) 
    my_error("Don't have a position to move to");

  Mem->ResetCurrentHome();

  if ( Mem->InSetPlay ){
    Mem->LogAction2(30,"move to position -- in set play");
    if ( !Mem->InMySetPlayPosition() )
      move( Mem->MySetPlayHome() );
    else 
      execute_setplay();
    return;
  }

  Mem->LogAction2(30,"move to position -- not in set play");
  if ( !Mem->InKickoffPosition() ) 
    move( Mem->PositionToKickoffPosition( Mem->MyCurrentHome()) );
  else
    face_neck_and_body_to_ball();
}
#endif // RELEASE_VERSION

/*****************************************************************************************/
/* if the arg is DT_all, we always dodge, otherwise we only dodge if they don't have ball */
void get_ball()
{
  if ( !Mem->MyConf() || !Mem->BallPositionValid() ) my_error("not enough info to get ball");

  DodgeType dodge = DT_only_with_ball;

  if ( !Mem->BallMoving() ){
    Mem->LogAction2(30, "get_ball: ball not moving, going to it's pos");
    if ( go_to_point(Mem->BallAbsolutePosition(),0,100,dodge) == AQ_ActionNotQueued ){
      my_error("already there???");
      face_neck_and_body_to_ball();
    }
    face_only_neck_to_ball();
  }
  else {
    if ( !Mem->MyInterceptionAble() ){
      Mem->LogAction2(30, "get_ball: going to the moving ball, but can't?");
      my_error("Can't get to the ball");
      face_neck_and_body_to_ball();
    } else if (Mem->MyInterceptionNumberCycles() == 1) {
      /* we're just one dash away, so just do it */
      Mem->LogAction2(30, "get_ball: going to the moving ball, just dashing 1 cycle");
      dash(Mem->CorrectDashPowerForStamina(Mem->MyInterceptionDashPower()));
      face_only_neck_to_ball();
    } else if ( go_to_point(Mem->MyInterceptionPoint(),0,
			  Mem->MyInterceptionDashPower(),dodge) == AQ_ActionNotQueued ) {
      Mem->LogAction2(30, "get_ball: going to the moving ball, but already there?");
      my_error("already there (moving) ???");
      face_neck_and_body_to_ball();
    } else {
      Mem->LogAction4(30, "get_ball: going to the moving ball (%d) pow %.2f",
		     Mem->MyInterceptionNumberCycles(), Mem->MyInterceptionDashPower());
      face_only_neck_to_ball();
    }
  }

#ifndef RELEASE_VERSION  
  /* Prepare to get ball -- need to be in narrow before a possible collision */
  if (Mem->MyInterceptionAble() &&
      (Mem->MyInterceptionNumberCycles() < Mem->CP_change_view_for_ball_cycles) &&
      (Mem->BallDistance() <= Mem->SP_feel_distance) ){
    Mem->LogAction2(200,"Changing view to prepare for with_ball mode");
    change_view(VW_Narrow); 
    Mem->ChangeViewForHandleBallTime = Mem->CurrentTime;
  }
#endif // RELEASE_VERSION
}

/*****************************************************************************************/

void stop_ball()
{
  if (!Mem->BallPositionValid())
    my_error("Need to know where ball is to stop it");

  if (Mem->BallVelocityValid()) {
    Mem->LogAction2(30, "stop_ball: velocity valid");
    DoTurnKickCommand(dokick(0,0));
  } else {
    Mem->LogAction2(30, "stop_ball: velocity not valid");
    //DebugDrib(printf("Stop kick; don't know velocity, so goign to kick to us"));
    kick(Mem->CP_stop_ball_power, GetNormalizeAngleDeg(Mem->BallAngleFromBody() + 180));
  }
}

/*****************************************************************************************/

void hold_ball()
{
  if (!Mem->BallPositionValid())
    my_error("Need to know where ball is to hold it");

  Unum opponent = Mem->ClosestOpponent();

  Mem->LogAction3(30, "hold_ball: closest opponent == %d",opponent);

  /* make sure that we keep control of the ball
     we need to make sure that ball's velocity is valid,
     and then scan_field only if we will keep control of ball */
  
  if ( opponent == Unum_Unknown) {
    if (!Mem->BallVelocityValid()){
      Mem->LogAction2(40, "hold_ball: velocity not valid");
      face_neck_to_ball();     
    }
    else if (Mem->TimeToTurnForScan() &&
	     (!Mem->BallMoving() || 
	      Mem->BallWillBeKickable(1,0,Mem->CP_holdball_kickable_buffer)) ){
      Mem->LogAction2(40, "hold_ball: ball not moving or will be kickable");
      scan_field_with_body();
    }
    else if (Mem->BallMoving() ||
	     !Mem->BallWillBeKickable(1,0,Mem->CP_holdball_kickable_buffer) ){
      Mem->LogAction2(40, "hold_ball: ball moving or won't be kickable");
      stop_ball();
    }
    else{
      Mem->LogAction2(40, "hold_ball: doing nothing");
      /* do nothing */
    }
  } else {
    /* closest opponent known */
    AngleDeg ang = GetNormalizeAngleDeg(Mem->OpponentAngleFromBody(opponent) + 180);

    Vector targ_pos = Mem->RelativeToMyBody2Global(Polar2Vector(Mem->CP_opt_ctrl_dist, ang));
    if (!Mem->FieldRectangle.IsWithin(targ_pos)) {
      /* Adjust the targ_pos and ang to be in bounds- ignore the corners! */
      Line lSide = Mem->FieldRectangle.nearestEdgeLine(Mem->MyPos());
      Vector sol1, sol2;
      int num_sol = LineCircleIntersect(lSide, Mem->CP_opt_ctrl_dist, Mem->MyPos(),
					&sol1, &sol2);
      if (num_sol == 0) {
	my_error("hold_ball: why didn't LineCircleIntersect work?");
      } else if (num_sol == 1) {
	Mem->LogAction6(40, "hold_ball: avoiding the sideline 1; old: (%.1f, %.1f)  new: (%.1f, %.1f)",
		   targ_pos.x, targ_pos.y, sol1.x, sol1.y);
	ang = Mem->AngleToFromBody(sol1);
      } else if (num_sol == 2) {
	if (targ_pos.dist2(sol1) < targ_pos.dist2(sol2)) {
	  Mem->LogAction6(40, "hold_ball: avoiding the sideline 2; old: (%.1f, %.1f)  new: (%.1f, %.1f)",
		     targ_pos.x, targ_pos.y, sol1.x, sol1.y);
	  ang = Mem->AngleToFromBody(sol1);
	} else {
	  Mem->LogAction6(40, "hold_ball: avoiding the sideline 3; old: (%.1f, %.1f)  new: (%.1f, %.1f)",
		     targ_pos.x, targ_pos.y, sol2.x, sol2.y);
	  ang = Mem->AngleToFromBody(sol2);
	}      
      }
    }
    
    if (!Mem->BallWillBeKickable(1,0,Mem->CP_holdball_kickable_buffer)) {
      Mem->LogAction2(40, "hold_ball: turning ball from opponent -- won't be kickable");
      if (TurnballTo(ang) == KT_DidNothing)
	my_error("hold_ball: why didn't turnball do something");
    } else if (Mem->OpponentPositionValid(opponent) < .9 &&
	       !Mem->InViewAngle(Mem->OpponentAngleFromNeck(opponent))){
      Mem->LogAction2(40, "hold_ball: looking at opponent");
      face_neck_to_opponent(opponent);
    }
    else if (Mem->TimeToTurnForScan() && Mem->EstimatedCyclesToSteal(opponent) > Mem->CP_time_for_full_rotation/3){
      /* do we want to scan when the ball may be near the opp? */
      /* yes, but only if the opponent isn't about to get the ball */
      Mem->LogAction2(40, "hold_ball: looking around");
      scan_field_with_body();
    }
    else{
      Mem->LogAction2(40, "hold_ball: turning ball from opponent");
      TurnballTo(ang);
    }
  }
}

/*****************************************************************************************/

void pass_ball(Unum teammate, float target_vel_at_dest)
{
  Mem->LogAction3(30, "passing to %d",teammate);    

  if ( teammate == Unum_Unknown ) my_error("Need to pass to a teammate");
  if ( !Mem->TeammatePositionValid(teammate) ) my_error("can't pass to invalid teammmate");

  if ( Mem->TeammatePositionValid(teammate) < .9 ){
    Mem->LogAction2(40, "pass_ball: looking for teammate");
#ifndef RELEASE_VERSION  
    Mem->Say(PMsg_ping_teammate,teammate);
#endif // RELEASE_VERSION
    if ( face_neck_to_teammate(teammate) == AQ_ActionNotQueued )
      hold_ball();
    return;
  }

  Vector   target = Mem->TeammateAbsolutePosition(teammate);
  AngleDeg target_angle = Mem->AngleToFromBody(target);
  TurnDir  rotation = KickRotationDirection(target_angle);
  float target_vel = Mem->VelAtPt2VelAtFoot(target,target_vel_at_dest);
  KickMode mode = Mem->BestKickMode(target_angle); 
  if (mode == KM_HardestKick) 
    mode = KM_Hard; 

  Mem->team_passer = Mem->MyNumber;
  Mem->team_receiver = teammate;
  Mem->team_pass_time = Mem->CurrentTime;  

  Mem->LogAction2(40, "pass_ball: starting pass");
#ifndef RELEASE_VERSION  
  Mem->Say( PMsg_passing_decision, teammate );
#endif // RELEASE_VERSION
  kick_ball(target,mode,target_vel,rotation); 
}

/*****************************************************************************************/

/* extend this angle to the sideline and call the other kick_ball variant */
/* target_angle is relative to body */
void kick_ball(AngleDeg target_angle, KickMode mode, float target_vel, TurnDir rotation)
{
  Vector target_pt =
    Mem->FieldRectangle.RayIntersection(Ray(Mem->MyPos(), target_angle + Mem->MyBodyAng()));
  Mem->LogAction5(40, "starting kick to angle %.1f, translated to point (%.1f, %.1f)",
		  target_angle, target_pt.x, target_pt.y);
  kick_ball(target_pt, mode, target_vel, rotation);
  return;
}

void kick_ball(Vector point, KickMode mode, float target_vel, TurnDir rotation)
{
  if (rotation == TURN_NONE)
    rotation = KickRotationDirection(Mem->AngleToFromBody(point));

  /* look to see if a dash will help */
  if (mode == KM_Hard && Mem->WillDashHelpKick(point, Mem->SP_max_power)) {
    mode = KM_Moderate;
    float target_angle =
      (point - Mem->MyPredictedPosition(1, Mem->SP_max_power)).dir() - Mem->MyBodyAng();
    Mem->LogAction3(40, "kick_ball: dashing will help kick to angle: %1.f", target_angle);
    dash(Mem->SP_max_power);
    Mem->StartKick(target_angle, mode, target_vel, rotation);
  } else {
    if (mode == KM_Hard)
      mode = KM_Moderate;
    float target_angle = Mem->AngleToFromBody(point);
    Mem->LogAction3(40, "kick_ball: starting kick to angle %.1f",target_angle);
    Mem->StartKick(target_angle, mode, target_vel, rotation);
    smart_kick_hard(target_angle, mode, target_vel, rotation);
  }
  
  return;
}

void kick_ball(AngleDeg target_angle, KickMode mode, TurnDir rotation)
{
  kick_ball(target_angle,mode,2*Mem->SP_ball_speed_max,rotation);
}

void kick_ball(Vector point, KickMode mode, TurnDir rotation)
{
  kick_ball(point,mode,2*Mem->SP_ball_speed_max,rotation);
}

#ifndef RELEASE_VERSION  
/*****************************************************************************************/
/* decides whether it's the right time to shoot on a breakaway */
ActionQueueRes breakaway_look_for_shot(Unum oppGoalie)
{
  Vector shot_target = Mem->ShotTarget();
  KickMode shot_mode = Mem->ShotMode(); 
  int cycles_to_steal;

  if (Mem->MarkerDistance(Mem->RM_Their_Goal) > Mem->CP_shot_distance) {
    Mem->LogAction2(30, "breakaway: too far away to shoot");
    return AQ_ActionNotQueued;
  }

  if (Mem->CP_breakaway_mode == 4) {
    if (Mem->MarkerDistance(Mem->RM_Their_Goal) < Mem->CP_shot_distance) {
      kick_ball(shot_target, shot_mode);
      return AQ_ActionQueued;
    } else 
      return AQ_ActionNotQueued;
  } else if (Mem->CP_breakaway_mode == 3) {
    if (Mem->MarkerDistance(Mem->RM_Their_Goal) < Mem->CP_good_shot_distance) {
      kick_ball(shot_target, shot_mode);
      return AQ_ActionQueued;
    } else 
      return AQ_ActionNotQueued;
  } 
  
  
  if (oppGoalie != Unum_Unknown) {
    cycles_to_steal = Mem->EstimatedCyclesToSteal(oppGoalie);
    Mem->LogAction3(40, "Cycles for goalie to steal: %d", cycles_to_steal);
  }

  /* look to see if we should shoot now */
  if (oppGoalie == Unum_Unknown) {
    Mem->LogAction5(30, "breakaway: shooting because goalie not there: mode: %d at (%.1f, %.1f)",
		    shot_mode, shot_target.x, shot_target.y);
    kick_ball(shot_target, shot_mode);
    return AQ_ActionQueued;
  } else if ((Mem->CP_breakaway_mode == 0 || Mem->CP_breakaway_mode == 1) &&
	     !Mem->CouldGoalieBlockShot(shot_target, Mem->CP_shot_speed, 1, oppGoalie)) {
    Mem->LogAction5(30, "breakaway: shooting because goalie can't stop it: mode: %d at (%.1f, %.1f)",
		    shot_mode, shot_target.x, shot_target.y);
    kick_ball(shot_target, shot_mode); 	  
    return AQ_ActionQueued;
  } else if ((Mem->CP_breakaway_mode == 0 || Mem->CP_breakaway_mode == 2) &&
	     cycles_to_steal <= Mem->CP_breakaway_min_goalie_steal_time) {
    /* look to see if we have any teammates that are better off */
    Unum teammate = Mem->BreakawayPassTarget();
    if (teammate != Unum_Unknown) {
      Mem->LogAction3(30, "breakaway: passing to player with a better shot %d",
		      teammate);
      pass_ball(teammate);
    } else {
      Mem->LogAction5(30, "breakaway: shooting because goalie close: mode: %d at (%.1f, %.1f)",
		      shot_mode, shot_target.x, shot_target.y);
      kick_ball(shot_target, shot_mode);
    }
    return AQ_ActionQueued;
  }
  return AQ_ActionNotQueued;
}

void breakaway_pick_target(Unum oppGoalie, Vector approach_pt, int kick_run_cycles) 
{
  Vector cross_targ(Mem->SP_pitch_length / 2,
		    -1.0 * signf(approach_pt.y) * Mem->SP_goal_area_width / 2);

  if (kick_run_cycles >= Mem->CP_breakaway_kick_run_min_cycles &&
      Mem->MyX() < approach_pt.x &&
      Mem->DistanceTo(approach_pt) > Mem->CP_at_point_buffer) {
    /* kick-run to approach point */
    Vector targ;
    AngleDeg ang;
    approach_pt = GetClosestPtInBetween(Mem->MyPos(), approach_pt, cross_targ);

    Mem->LogAction3(40, "breakaway: recomputing kick-run targ, approach %d",
		    kick_run_cycles);
    for (ang = (approach_pt - Mem->MyPos()).dir();
	 fabs(ang) < 90;
	 ang += signf(approach_pt.y) * -5.0 ) {
      if (breakaway_evaluate_kick_run_angle(ang, oppGoalie, kick_run_cycles, &targ))
	break;
    }
    if (fabs(ang) < 90 && //valid target
	Mem->DistanceTo(targ) <= Mem->DistanceTo(approach_pt)) { //don't overshoot
      Mem->LogAction4(40, "breakaway: kick-run to (%.2f, %.2f)",
		      targ.x, targ.y);
      Mem->my_breakaway_dribble = FALSE; //do kick-run
      Mem->my_breakaway_targ = targ;
      return;
    }

    /* if we got here, we shoudl dribble to the approach point */
    Mem->my_breakaway_dribble = TRUE; //do dribble
    Mem->my_breakaway_targ = cross_targ;
    Mem->LogAction4(40, "breakaway: tried kick-run, but now dribbling to approach (%.2f, %.2f)",
		      approach_pt.x, approach_pt.y);
    
  } else if (fabs(Mem->MyY()) - Mem->CP_at_point_buffer >
      fabs(approach_pt.y)) {
    /* we're on the side, dribble towards penalty corner, but recompute
       when we get to the near approach_edge */
    Mem->my_breakaway_dribble = TRUE; //do dribble
    Line l;
    l.LineFromTwoPoints(Mem->MyPos(),
			Vector(Mem->SP_pitch_length / 2,
			       -1.0 * signf(approach_pt.y) * Mem->SP_penalty_area_width / 2));
    Mem->my_breakaway_targ.y = approach_pt.y;
    Mem->my_breakaway_targ.x = l.get_x(Mem->my_breakaway_targ.y);
    Mem->LogAction2(40, "breakaway: recomputing dribble targ, across");
  } else {
    /* we're inside the approach area,
	     dribble to opposite corner */
    Mem->my_breakaway_dribble = TRUE; //do dribble
    Mem->my_breakaway_targ = cross_targ;
    Mem->LogAction2(40, "breakaway: recomputing dribble targ, opp corner");
  }
}

Bool breakaway_evaluate_kick_run_angle(AngleDeg ang, Unum oppGoalie,
				       int kick_run_cycles, Vector* pTarg) 
{
  if (fabs(GetNormalizeAngleDeg(ang - Mem->MyBodyAng())) <
      Mem->CP_max_go_to_point_angle_err)
    // facing the right dir
    // the 1 at the end is an initial idle cycle
    *pTarg = Mem->MyPredictedPosition(kick_run_cycles, Mem->SP_max_power, 1);
  else
    // the 1 at the end is an initial idle cycle
    *pTarg = Mem->MyPredictedPositionWithTurn(ang - Mem->MyBodyAng(),
					      kick_run_cycles,
					      Mem->SP_max_power,
					      TRUE, 1);
  /* displace it by a dribble dist  */
  Unum opp = Mem->ClosestOpponentTo(*pTarg);
  Vector disp;
  if (opp == Unum_Unknown)
    disp = *pTarg - Mem->MarkerPosition(Mem->RM_Their_Goal);
  else
    disp = -(Mem->OpponentAbsolutePosition(opp) - *pTarg);
  /* now we need to make sure that we displace in front of us */
  AngleDeg targ_dir = (*pTarg - Mem->MyPos()).dir();
  disp = Polar2Vector(Mem->CP_dribble_ball_dist,
		      targ_dir + 
		      MinMax(-90,
			     GetNormalizeAngleDeg(disp.dir() - targ_dir),
			     90));
  *pTarg += disp;
  
  int goalie_cyc;
  if (oppGoalie == Unum_Unknown)
    goalie_cyc = 10000;
  else
    goalie_cyc = Mem->OpponentPredictedCyclesToPoint(oppGoalie, *pTarg);
  Mem->LogAction7(205, "Trying ang: %.2f, targ is (%.2f, %.2f), goalie: %f, cycles: %.0f",
		  ang, pTarg->x, pTarg->y, (float)goalie_cyc, (float)kick_run_cycles);
  return (goalie_cyc > kick_run_cycles + Mem->CP_cycles_to_kick)
    ? TRUE : FALSE;
}

/*****************************************************************************************/

void handle_ball()
{
  /*Unum t = Mem->PassTarget(TRUE,PC_DT_Max);
  if ( t != Unum_Unknown )
    printf("would pass to %d (congestion %.4f, mine %.4f)\n",
	   t,Mem->TeammateCongestion(t,TRUE) + .01,Mem->MyCongestion());
  else 
    printf("no pass good enough\n");*/
  //return;

  Mem->LogAction2(20, "Handling the ball");
  change_view(VW_Narrow);
  Mem->ChangeViewForHandleBallTime = Mem->CurrentTime;

  if ( !Mem->BallKickable() ){
    Mem->LogAction2(30, "handle_ball:  ball not kickable => dribble in progress");
    if ( Mem->DribbleInProgress() ){
      DribbleRes res = 
	SmartDribbleTo(Mem->dribble_in_progress_target, Mem->dribble_in_progress_dash_power,
		       Mem->dribble_in_progress_buffer);
      if (res == DR_LostBall)
	get_ball();
      return;
    }
    else{
      my_error("Ball should be kickable in handle_ball (unless dribbling)");
      return;
    }
  }

#if 0
  Unum offside_teammate = Mem->TeammateOffsideIfIKick();
  if ( offside_teammate != Unum_Unknown ){
    Mem->LogAction3(30, "handle_ball:  Teammate %d will be offside if I kick", offside_teammate);
    get_ball();
    face_only_neck_to_teammate(offside_teammate);
    return;
  }
#endif

  if ( !Mem->BallVelocityValid() ){
    Mem->LogAction2(30, "handle_ball:  velocity not valid, so stopping ball");
    stop_ball();
    return;
  }

  /* Don't stay as receiver once getting the ball */
  if ( Mem->team_receiver == Mem->MyNumber ) Mem->team_receiver = Unum_Unknown;

  /* If 2 players can kick the ball, let the one with higher X coordinate go */
  /* (Could still have 2 players kicking if 3 or more can all kick)          */
  Unum closest_other_teammate = Mem->ClosestTeammateToBall(FALSE);
  if ( closest_other_teammate != Unum_Unknown && 
       Mem->BallKickableForTeammate(closest_other_teammate,Mem->CP_defer_kick_to_teammate_buffer) ){
    if ( Mem->TeammateX(closest_other_teammate) > Mem->MyX() ){
      Mem->LogAction3(30, "handle_ball: deferring to teammate %d",closest_other_teammate);
      return;
    }
    else {
      Mem->LogAction3(30, "handle_ball: also kickable for %d, but I'm more forward",
		     closest_other_teammate);
    }
  }

  if ( Mem->KickInProgress() ){
    /* Already kicking */
    Mem->LogAction2(30, "handle_ball: continuing kick");
    smart_kick_hard_abs(Mem->kick_in_progress_abs_angle,Mem->kick_in_progress_mode,
			Mem->kick_in_progress_target_vel,Mem->kick_in_progress_rotation);
    return;
  }

  if ( Mem->VP_train_DT ){
    Mem->LogAction2(30, "handle_ball: training DT");
    Unum teammate = Mem->PassTarget(FALSE,PC_Random);
    if ( teammate == Unum_Unknown ) 
      hold_ball();
    else{
      pass_ball(teammate);
      Mem->StartTrainingPass(teammate);
    }
    return;
  }

  if ( Mem->BallCatchable() ){
    my_error("goalie shouldn't get here");
    /* goalie can get it */
    goalie_catch_ball();
    return;
  }

  float dribble_speed = Mem->CP_dribble_dash_pow;
  if ( Mem->Tired() )
    dribble_speed = Min(Mem->CorrectDashPowerForStamina(dribble_speed),
			2.0 * Mem->SP_stamina_inc);  // dribble kick-dash-kick-dash
  Vector target = Mem->MarkerPosition(Mem->RM_Their_Goal);;

  //test_DT();

  Unum receiver;
  PassChoiceType pass_choice = ( Mem->VP_use_DT ? PC_DT_Max : PC_Fixed );
  if ( 0 && Mem->TestVersion ) pass_choice = PC_Fixed;
  if ( (receiver=Mem->PassTarget(FALSE,pass_choice,PF_BetterShot)) != Unum_Unknown ){
    /* There's a preferred pass available */
    Mem->LogAction2(30, "handle_ball: passing (0) -- better shot");
    pass_ball(receiver);
    return;
  }

  if ( Mem->OurBreakaway()==Mem->MyNumber ) {
    Unum oppGoalie = Mem->ClosestOpponentTo(Mem->MarkerPosition(Mem->RM_Their_Goal)); 
#ifndef NO_ACTION_LOG    
    Unum with_ball = Mem->TeammateWithBall(-Mem->CP_our_breakaway_kickable_buffer);
    Mem->LogAction4(100,"breakaway: with_ball = %d, opponents closer = %d",
		    with_ball,
		    Mem->NumOpponentsWithin(Mem->TeammateDistanceTo(with_ball,
			     Mem->MarkerPosition(Mem->RM_Their_Goal))+
			     Mem->CP_breakaway_buffer,Mem->MarkerPosition(Mem->RM_Their_Goal)));
#endif

    if (breakaway_look_for_shot(oppGoalie) == AQ_ActionNotQueued) {
      /* still not ready to shoot */
      Vector approach_pt = Mem->BreakawayApproachPoint();

      /* if there are opponents close to us, look for someone with a great shot */
      if (Mem->NumOpponentsWithin(Mem->SP_feel_distance) > 0 ||
	  Mem->Tired() ) {
	Unum teammate =  Mem->BreakawayPassTarget();
	if (teammate != Unum_Unknown) {
	  Mem->LogAction3(30, "breakaway: opps close, passing to player with a shot %d",
			  teammate);
	  pass_ball(teammate);
	  return; //don't need to set breakaway time
	}
      }
      
      /* try dribbling or a kick and run */

      /* determine what our kick_run cycles should be */
      int kick_run_cycles = Mem->BreakawayKickRunCycles();
    
      if (Mem->CurrentTime-Mem->CP_breakaway_targ_valid_time >= Mem->my_breakaway_time ||
	  Mem->DistanceTo(Mem->my_breakaway_targ) < Mem->CP_at_point_buffer) {
	/* stored value too old to reply on  OR
	   we got to the last target */
	breakaway_pick_target(oppGoalie, approach_pt, kick_run_cycles);
      }
      
      /* Now that we have a target picked, go to the dribble or kick-run to it */
      if (Mem->my_breakaway_dribble) {
	/* Do a dribble */
	if (!Mem->BallVelocityValid()) {
	  stop_ball();
	  face_only_neck_to_ball();
	} else {
	  face_only_neck_to_point((oppGoalie != Unum_Unknown) ?
				  Mem->OpponentAbsolutePosition(oppGoalie) :
				  Mem->MarkerPosition(Mem->RM_Their_Goal));
	  DribbleRes res = SmartDribbleTo(Mem->my_breakaway_targ, Mem->CP_dribble_dash_pow);
	  if (res != DR_Going)
	    my_error("breakaway: dribble did something wrong: %d", res);
	  Mem->LogAction4(30, "test breakaway: dribbling towards (%.1f, %.1f)",
			  Mem->my_breakaway_targ.x, Mem->my_breakaway_targ.y);
	}
      } else {
	/* Do a kick and run */
	/* now decide whether to kick or run */
	int my_cyc_to_point = Mem->PredictedCyclesToPoint(Mem->my_breakaway_targ);
	if (Mem->WillDashBeCollision(Mem->SP_max_power) ||
	    Mem->BallPredictedPosition(my_cyc_to_point).dist(Mem->my_breakaway_targ) >
	    Mem->SP_kickable_area - Mem->CP_kickable_buffer) {
	  /* need to kick the ball */
	  float target_vel =
	    SolveForFirstTermGeomSeries(Mem->SP_ball_decay,
					kick_run_cycles,
					Mem->BallAbsolutePosition().dist(Mem->my_breakaway_targ));
	  Mem->LogAction5(30, "Kicking for kick-run targ in %d cycles (%.2f, %.2f)",
			  kick_run_cycles,
			  Mem->my_breakaway_targ.x, Mem->my_breakaway_targ.y);
	  smart_kick_hard_abs((Mem->my_breakaway_targ-Mem->MyPos()).dir(),
			      KM_QuickestRelease, target_vel, TURN_CLOSEST);
	} else {
	  /* just go to the right point */
	  Mem->LogAction2(30, "Going to breakaway kick-run targ");
	  go_to_point(Mem->my_breakaway_targ, 0/*buffer*/, Mem->SP_max_power, DT_none);
	}
	face_only_neck_to_point((oppGoalie != Unum_Unknown) ?
				Mem->OpponentAbsolutePosition(oppGoalie) :
				Mem->MarkerPosition(Mem->RM_Their_Goal));	
      }
      Mem->my_breakaway_time = Mem->CurrentTime;
    }
    return;
  }

  Mem->LogAction3(50,"OurBreakaway() == %d",Mem->OurBreakaway());

  if ( Mem->HaveAGoodShot() ){
    Mem->LogAction2(30, "handle_ball: have a good shot");
    Mem->LogAction5(40, "handle_ball: shooting (no breakaway): mode: %d at (%.1f, %.1f)",
		    Mem->ShotMode(), Mem->ShotTarget().x, Mem->ShotTarget().y);
    kick_ball(Mem->ShotTarget(),Mem->ShotMode());
    return;
  }
  
  if ( Mem->NeedToClear() ){
    /* Dangerous position defensively */
    Mem->LogAction2(30, "handle_ball: need to clear)");
    clear_ball();
    return;
  }

  if ( (receiver=Mem->PassTarget(FALSE,pass_choice,PF_GoalDist_Congestion_And_Shot)) != Unum_Unknown ){
    /* There's a preferred pass available */
    Mem->LogAction2(30, "handle_ball: passing (1) -- prefereed pass available");
    pass_ball(receiver);
    return;
  }

  target = Mem->MarkerPosition(Mem->RM_Their_Goal);
  if ( Mem->CanDribbleTowards(target) ){ 
    /* have room to dribble */
    Mem->LogAction2(30, "handle_ball: dribbling to goal (2) -- have room");
    SmartDribbleTo(target, dribble_speed);
    return;
  }

  /* Look for a pass to a less congested AND closer to goal teammate */
  if ( (receiver=Mem->PassTarget(FALSE,pass_choice,PF_GoalDist_And_Congestion)) != Unum_Unknown ){
    /* There's a pass available */
    Mem->LogAction2(30, "handle_ball: passing (2) -- closer,less congested pass");
    pass_ball(receiver);
    return;
  }
  
  /* Now look for a cross- it's not to a particular teammate */
  if (Mem->ShouldIMoveToCross()) {
    Vector cross_targ =
      Vector(Mem->CP_cross_pt_x, -1.0 * signf(Mem->MyY()) * Mem->CP_cross_pt_y);
    if ( Mem->ShouldICross() ){
      Mem->LogAction2(30, "handle_ball: crossing because shouldIcross==true");
      kick_ball(cross_targ, Mem->ShotMode(),
		Mem->VelAtPt2VelAtFoot(cross_targ, Mem->CP_cross_target_vel));
      return;
    }
    Vector target(Mem->FieldRectangle.RightX(), Mem->MyY());
    if (Mem->CanDribbleTowards(target)) {
      Mem->LogAction2(30, "handle_ball: dribbling to baseline for crossing");
      SmartDribbleTo(target, dribble_speed);
      return;
    }
    target.y = signf(Mem->MyY())*Mem->FieldRectangle.BottomY();
    if (Mem->CanDribbleTowards(target)) {
      Mem->LogAction2(30, "handle_ball: dribbling to corner for crossing");
      SmartDribbleTo(target, dribble_speed);
      return;
    }
    Mem->LogAction2(30, "handle_ball: crossing because can't dribble to baseline or corner");
    kick_ball(cross_targ, Mem->ShotMode(),
	      Mem->VelAtPt2VelAtFoot(cross_targ, Mem->CP_cross_target_vel));
    return;
  }
  
  if ( Mem->HaveAShot() ){
    /* In a good position for a shot */
    Mem->LogAction5(30, "handle_ball: shooting from a bit farther: mode: %d at (%.1f, %.1f)",
		    Mem->ShotMode(), Mem->ShotTarget().x, Mem->ShotTarget().y);
    kick_ball(Mem->ShotTarget(),Mem->ShotMode());
    return;
  }

  if (Mem->CanDribble() ){ 
    /* have room and energy to dribble */
    Vector dest = Mem->DribbleTarget();
    if ( fabs(dest.y) != Mem->SP_pitch_width/2 || Mem->DistanceTo(dest) > 5 ){
      Mem->LogAction2(30, "handle_ball: have room to dribble");
      SmartDribbleTo(dest, dribble_speed);
      return;
    }
  }

  /* kick to beat offsides */
  if ( Mem->SP_use_offside && 
       Mem->MyX() > Mem->my_offside_line - Mem->CP_beat_offsides_buffer &&
       Mem->my_offside_line < Mem->CP_beat_offsides_threshold &&
       Mem->MyX() < Mem->CP_beat_offsides_max_x ){
    Mem->LogAction2(30, "handle_ball: kicking to beat offsides");
    send_ball();
    return;
  }


  /* Look for a pass to a less congested OR closer to goal teammate */
  if ( (receiver=Mem->PassTarget(TRUE,pass_choice,PF_GoalDist_Or_Congestion)) != Unum_Unknown ){
    /* There's a pass available */
    Mem->LogAction2(30, "handle_ball: passing (3) -- closer OR less congested pass");
    pass_ball(receiver);
    return;
  }

  if ( Mem->CanKeepBall() ){
    /* There aren't 2 opponents nearby */
    Mem->LogAction2(30, "handle_ball: keeping ball (there aren't 2 opponents nearby)");
    hold_ball();
    return;
  }

  if ( (receiver=Mem->PassTarget(FALSE,pass_choice,PF_No_Opponent_Near)) != Unum_Unknown ){
    /* There's a pass available, possbily off preference list */
    Mem->LogAction2(30, "handle_ball: passing (4) -- passing to a open someone");
    pass_ball(receiver);
    return;
  }
  
  /* Just get rid of it */
  if ( Mem->MyX() < -20 ){
    Mem->LogAction2(30, "handle_ball: clearing ball (in my zone)");
    clear_ball();
  } else {
    Mem->LogAction2(30, "handle_ball: sending ball (not in my zone)");
    send_ball();
  }
}
  
/*****************************************************************************************/

void support_ball()
{
  float width = 20, height = 20;
  Vector center = Mem->BallAbsolutePosition();

  float my_pos_x = Mem->MyPositionX(TRUE);
  float ball_x   = Mem->BallX();

  if ( my_pos_x > ball_x || Mem->MyPositionType() == PT_Forward ){
    width = Max(width,my_pos_x - ball_x);
    if ( Mem->MyPositionY(TRUE) > Mem->BallY() ) 
      center += Vector(width/2,height/2);
    else 
      center += Vector(width/2,-height/2);
  }
  else{
    if ( Mem->MyPositionY(TRUE) > Mem->BallY() ) 
      center += Vector(-width/2,height/2);
    else 
      center += Vector(-width/2,-height/2);
  }

  Rectangle rect = Rectangle(center,Vector(width,height));
  rect = Mem->ShiftRectangleInBounds(&rect);
  if ( get_open_for_pass_from_in_rectangle(&rect,Mem->BallAbsolutePosition()) == AQ_ActionNotQueued ){
    Mem->LogAction2(30, "support_ball:  can't get open for pass, going to position ");
    go_to_position();
  }
  else{
    Mem->LogAction2(30, "support_ball:  getting open for pass");
    scan_field_with_neck();
  }
}

/*****************************************************************************************/

void get_on_sides()
{
  Mem->LogAction2(30, "get_on_sides");
  go_to_point(Mem->PositionToOnsidePosition(Mem->MyPos(),Mem->CP_at_point_buffer+2));
  scan_field_with_neck();
}

/*****************************************************************************************/

void go_to_position()
{
  if ( Mem->BallPositionValid() ){
    if ( !Mem->CP_spar || Mem->MyPos().Behind(Mem->BallAbsolutePosition()) || 
	 Mem->MyPositionType() <= PT_Defender ){
      Mem->LogAction2(40, "go_to_position:  HomeChangeMethod == HC_Shift");
      Mem->HomeChangeMethod = HC_Shift;
    }
    else{
      Mem->LogAction2(40, "go_to_position:  HomeChangeMethod == HC_Get_Open");
      Mem->HomeChangeMethod = HC_Get_Open;
    }
    Mem->UpdateHome();
  }

  Vector home = Mem->MyCurrentHome();
  float buffer = Mem->MyPositionBuffer();
  float dash_power = 40;

  if ( Mem->OffsidePosition(home,Mem->MySide) ) 
    my_error("shouldn't go to an offside position");

  if ( go_to_point(home,buffer,dash_power) == AQ_ActionNotQueued ){
    Mem->LogAction2(30, "go_to_position:  Already there, facing ball");
    face_neck_and_body_to_ball(); 
  }
  else{
    Mem->LogAction4(30, "go_to_position:  going to home position (%.1f, %.1f)",
		   Mem->MyCurrentHomeX(),Mem->MyCurrentHomeY());
    scan_field_with_neck();
  }
}
#endif // RELEASE_VERSION

/*****************************************************************************************/

ActionQueueRes go_to_point( Vector p, float buffer, float dash_power, DodgeType dodge )
{
  Mem->LogAction5(30, "go_to_point %d (%.1f %.1f)",dodge, p.x,p.y);
  if ( !Mem->MyConf() ) my_error("Can't go to a point if not localized");

  if ( Mem->DistanceTo(p) < buffer ){
    if ( Mem->SP_use_offside && fabs(Mem->MyX() - Mem->my_offside_line) < 5 ){ /* hack */
      Unum opp = Mem->FurthestForwardOpponent();
      if ( opp != Unum_Unknown && Mem->OpponentPositionValid(opp) < .9 ){ /* hack */
	Mem->LogAction2(40, "go_to_point: looking for offsides line");
	return face_neck_to_opponent(opp);
      }
    }
    Mem->LogAction2(40, "go_to_point: already at the point");
    return AQ_ActionNotQueued;
  }

  if ( Mem->PlayMode == PM_Their_Goal_Kick && Mem->MyPos() != p ){
    /* if ( Mem->TheirPenaltyArea.IsWithin(p) ){
      my_error("Can't go into their penalty area on a goal kick!"); */
    Line l = LineFromTwoPoints(Mem->MyPos(),p);
    Vector intersection = AdjustPtToRectOnLine(Mem->MyPos(),Mem->TheirPenaltyArea,l);
    if ( intersection != Mem->MyPos() && l.InBetween(intersection,Mem->MyPos(),p) ){
      /* Need to go around the rectangle */
      Mem->LogAction2(40, "go_to_point: moving around penalty area");
      Vector target;
      if ( Mem->MyX() < Mem->TheirPenaltyArea.LeftX() )
	target = Vector(Mem->TheirPenaltyArea.LeftX()-3,p.y);
      else if ( Mem->MyY() > 0 )
	target = Vector(Mem->TheirPenaltyArea.LeftX()-3,Mem->TheirPenaltyArea.BottomY()+3 );
      else
	target = Vector(Mem->TheirPenaltyArea.LeftX()-3,Mem->TheirPenaltyArea.TopY()-3 );
      go_to_point( target, 0, dash_power, dodge );
      return AQ_ActionQueued;
    }
  }

  if ( Mem->PlayMode != PM_Play_On && Mem->TeamInPossession() == Mem->TheirSide &&
       !Mem->OffsidePosition(p,Mem->MySide) &&
       //p.dist(Mem->BallAbsolutePosition()) > Mem->SP_free_kick_buffer &&
       Mem->InOffsidePosition() && Mem->BallDistance() < Mem->SP_free_kick_buffer+1 ){
    Mem->LogAction2(40, "go_to_point: moving around free_kick area");
    if ( Mem->BallY() > Mem->MyY() )
      go_to_point(Vector(Mem->MyX(),Mem->BallY()-(Mem->SP_free_kick_buffer+1)));
    else
      go_to_point(Vector(Mem->MyX(),Mem->BallY()+(Mem->SP_free_kick_buffer+1)));
    return AQ_ActionQueued;
  }

  float target_ang  = GetNormalizeAngleDeg((p - Mem->MyPredictedPosition()).dir() - Mem->MyBodyAng());
  float target_dist = Mem->DistanceTo(p);

  if ( dodge != DT_none ){ /* dodge players */
    PlayerObject *player;
    float    dodge_dist = Min(Mem->CP_dodge_distance_buffer,target_dist);
    AngleDeg dodge_ang  = Mem->CP_dodge_angle_buffer;
    if ( (player = Mem->GetPlayerWithin( dodge_dist, dodge_ang, 0, target_ang - dodge_ang)) != NULL &&
	 (dodge!=DT_unless_with_ball || 
	  (Mem->BallPositionValid() && 
	   player->get_abs_pos().dist(Mem->BallAbsolutePosition()) > Mem->SP_kickable_area)) &&
	 (dodge!=DT_only_with_ball ||
	  (Mem->BallPositionValid() && 
	   player->get_abs_pos().dist(Mem->BallAbsolutePosition()) <= Mem->SP_kickable_area)) ){
      Mem->LogAction2(40, "go_to_point: dodging right");
      /*if ( Mem->NumPlayersWithin( dodge_dist, 2*dodge_ang) ){*/
	/* Target at dist player_size, so no players will be within in the next iteration ==> dash */
      Vector new_target = Mem->BodyPolar2Gpos(Mem->SP_player_size,player->get_ang_from_body() + Mem->CP_dodge_angle);
      if ( new_target == p )
	my_error("Dodging isn't changing the point!");
      go_to_point(new_target,0,Mem->CP_dodge_power,DT_none); 
      /*}
      else{
	dash(Mem->CorrectDashPowerForStamina(Min(dash_power,Mem->CP_dodge_power)));
      }*/
      return AQ_ActionQueued;
    }
    if ( (player = Mem->GetPlayerWithin( dodge_dist, dodge_ang, 0, target_ang + dodge_ang)) != NULL &&
	 (dodge!=DT_unless_with_ball || 
	  (Mem->BallPositionValid() && 
	   player->get_abs_pos().dist(Mem->BallAbsolutePosition()) > Mem->SP_kickable_area)) &&
	 (dodge!=DT_only_with_ball ||
	  (Mem->BallPositionValid() && 
	   player->get_abs_pos().dist(Mem->BallAbsolutePosition()) <= Mem->SP_kickable_area)) ){
      Mem->LogAction2(40, "go_to_point: dodging left");
      /*if ( Mem->NumPlayersWithin( dodge_dist, 2*dodge_ang) ){*/
	/* Target at dist player_size, so no players will be within in the next iteration ==> dash */
	Vector new_target = Mem->BodyPolar2Gpos(Mem->SP_player_size,player->get_ang_from_body() - Mem->CP_dodge_angle);
	if ( new_target == p )
	  my_error("Dodging isn't changing the point!");
	go_to_point(new_target,0,Mem->CP_dodge_power,DT_none);
      /*}
      else{
	dash(Mem->CorrectDashPowerForStamina(Min(dash_power,Mem->CP_dodge_power)));
      }*/
      return AQ_ActionQueued;
    }
  }

  if ( fabs(target_ang) > Mem->CP_max_go_to_point_angle_err || 
       (Mem->PlayMode == PM_Their_Goal_Kick && 
	Mem->TheirPenaltyArea.IsWithin(Mem->MyPredictedPosition(1,dash_power))) ){
    Mem->LogAction3(50, "go_to_point: turning %f", target_ang);
    turn(target_ang);
    return AQ_ActionQueued;
  }

  dash_power = Mem->CorrectDashPowerForStamina(dash_power);
  if ( dash_power > 0 ){
    Mem->LogAction3(50, "go_to_point: dashing %f", dash_power);
    dash( dash_power );
    return AQ_ActionQueued;
  }
  else
    {my_stamp; printf("recovering\n");} 

  Mem->LogAction2(50, "go_to_point: doing nothing?");
  return AQ_ActionNotQueued;
}

#ifndef RELEASE_VERSION  
/*****************************************************************************************/

ActionQueueRes move_to_point_in_between(Vector pt1, Vector pt2,
					float pt1dist, float dash_power)
{
  Mem->LogAction7(30, "move_to_point_in_between: (%.2f, %.2f) (%.2f, %.2f) %.2f",
		  pt1.x, pt1.y, pt2.x, pt2.y, pt1dist);
  Line l = LineFromTwoPoints(pt1, pt2);
  Vector projPos = l.ProjectPoint(Mem->MyPos());
  //Vector projPos = l.GetClosestPtInBetween(Mem->MyPos(), pt1, pt2);
  Vector closePt = (projPos.dist2(pt1) < projPos.dist2(pt2)) ? pt1 : pt2;
  Unum opp = Mem->ClosestOpponent();
  if (!l.OnLine(Mem->MyPos(), Mem->CP_at_point_buffer) &&
      (l.InBetween(projPos, pt1, pt2) ||
       (projPos.dist(closePt) < Mem->CP_at_point_buffer &&
	fabs(Mem->AngleToFromBody(closePt)) < Mem->CP_max_go_to_point_angle_err)) &&
      (opp == Unum_Unknown ||
       Mem->OpponentAbsolutePosition(opp).dist(pt1) < Mem->CP_at_point_buffer ||
       Mem->OpponentAbsolutePosition(opp).dist(pt2) < Mem->CP_at_point_buffer ||
       !(l.OnLine(Mem->OpponentAbsolutePosition(opp)) &&
	 l.OnLine(Mem->MyPos(), Mem->CP_dodge_distance_buffer)))) {   
    Mem->LogAction2(30, "move_to_point_in_between: not on line yet");
    return move_in_between(pt1, pt2, dash_power);
  } else {
    Vector dest = PointInBetween(pt1,pt2,pt1dist);
    if (Mem->AtPos(dest)){
      Mem->LogAction2(30, "move_to_point_in_between: already there");
      return AQ_ActionNotQueued;
    }
    else{
      Mem->LogAction2(30, "move_to_point_in_between: on line, going to point");
      go_to_point(dest, Mem->CP_at_point_buffer, dash_power);
    }
    return AQ_ActionQueued;
  }
}

/*****************************************************************************************/

ActionQueueRes move_in_between(Vector pt1, Vector pt2, float dash_power)
{  
  Line l = LineFromTwoPoints(pt1,pt2);
  if (l.OnLine(Mem->MyPos())){
    Mem->LogAction2(30, "move_in_between:  already on line");
    return AQ_ActionNotQueued;
  }
  //Vector dest = l.ProjectPoint(Mem->MyPos());
  Vector dest = l.GetClosestPtInBetween(Mem->MyPos(), pt1, pt2);
  dest = Mem->FieldRectangle.shrink(Mem->CP_at_point_buffer).AdjustToWithin(dest);
  Mem->LogAction4(30, "move_in_between:  aiming for (%.1f %.1f)", dest.x, dest.y);
  return go_to_point(dest, Mem->CP_at_point_buffer, dash_power);
}

/*****************************************************************************************/

/* get between player and ball */
void mark_opponent(Unum opp, float dist)
{
  if ( !Mem->BallPositionValid() ) my_error("can't mark without knowing ball");
  if ( !Mem->OpponentPositionValid(opp) ) my_error("can't mark without knowing opp");

  //my_stamp; printf("%d marking %d\n",Mem->MyNumber,opp);
  Mem->LogAction3(30, "Marking opponent %d",opp);

  AngleDeg goal_ang = (Mem->MarkerPosition(Mem->RM_My_Goal) - Mem->OpponentAbsolutePosition(opp)).dir();
  AngleDeg ball_ang = (Mem->BallAbsolutePosition()          - Mem->OpponentAbsolutePosition(opp)).dir();

  AngleDeg mark_ang = AngleBisect(goal_ang,ball_ang);

  if ( Mem->PullOffside &&
       Mem->OpponentX(opp) < Mem->PullOffsidePosition &&
       !Mem->SetPlay &&
       Mem->MyX() - Mem->their_offside_line < Mem->CP_pull_offside_threshold){
    Mem->LogAction2(40, "mark_opponent:  pulling offsides");
    if ( go_to_point(Vector(Mem->PullOffsidePosition+Mem->CP_pull_offside_buffer,
			    Mem->OpponentY(opp))) == AQ_ActionQueued ){
      face_only_neck_to_opponent(opp);
      return;
    }
  }
  else if ( go_to_point (Mem->OpponentAbsolutePosition(opp) + Polar2Vector(dist, mark_ang),
			 Mem->CP_at_point_buffer, 40) == AQ_ActionQueued){
    /*  else if ( move_to_point_in_between(Mem->OpponentAbsolutePosition(opp),mark_ang,
				dist,40) == AQ_ActionQueued ) */
    face_only_neck_to_opponent(opp);
    return;
  }

  if ( Mem->BallPositionValid() < Mem->OpponentPositionValid(opp) ){
    Mem->LogAction2(40, "mark_opponent:  facing ball");    
    face_neck_to_ball();
  }
  else{
    Mem->LogAction2(40, "mark_opponent:  facing opponent");    
    face_neck_to_opponent(opp);
  }
}

/*****************************************************************************************/

/* get between player and goal */
void track_opponent(Unum opp, float dist)
{
  if ( !Mem->BallPositionValid() ) my_error("can't mark without knowing ball");
  if ( !Mem->OpponentPositionValid(opp) ) my_error("can't mark without knowing opp");

  //my_stamp; printf("%d tracking %d\n",Mem->MyNumber,opp);
  Mem->LogAction3(30, "Tracking opponent %d",opp);

  if ( Mem->PullOffside &&
       Mem->OpponentX(opp) < Mem->PullOffsidePosition &&
       !Mem->SetPlay &&
       Mem->MyX() - Mem->their_offside_line < Mem->CP_pull_offside_threshold){
    Mem->LogAction2(40, "track_opponent:  pulling offsides");
    if ( go_to_point(Vector(Mem->PullOffsidePosition+Mem->CP_pull_offside_buffer,
			    Mem->OpponentY(opp))) == AQ_ActionQueued ){
      face_only_neck_to_opponent(opp);
      return;
    }
  }
  else if ( move_to_point_in_between(Mem->OpponentAbsolutePosition(opp),
				     Mem->MarkerPosition(Mem->RM_My_Goal),
				     dist,40) == AQ_ActionQueued ){
    face_only_neck_to_opponent(opp);
    return;
  }

  if ( Mem->BallPositionValid() < Mem->OpponentPositionValid(opp) ){
    Mem->LogAction2(40, "track_opponent:  facing ball");
    face_neck_to_ball();
  }
  else{
    Mem->LogAction2(40, "track_opponent:  facing opponent");
    face_neck_to_opponent(opp);
  }
}

/*****************************************************************************************/

ActionQueueRes get_open_in_rectangle(Rectangle *rect)
{
  Vector best_point;

  if ( Mem->MyPositionType() == PT_Forward )
    best_point = Mem->LeastCongestedValidPointInRectangle(rect,TRUE,Mem->MarkerPosition(Mem->RM_Their_Goal));
  else
    best_point = Mem->LeastCongestedValidPointInRectangle(rect);

  if ( !rect->IsWithin(best_point) ){
    if ( best_point != rect->Center() + Vector(rect->Width(),0) )
      my_error("Why isn't the point in the rectangle????");
    return AQ_ActionNotQueued;
  }

  int buffer = 3;

  if ( Mem->DistanceTo(best_point) < buffer ){
    Mem->LogAction2(30, "get_open_in_rectangle:  already there");
    scan_field_with_body();
  }
  else{
    Mem->LogAction4(30, "get_open_in_rectangle:  going to (%.1f %.1f)",best_point.x,best_point.y);
    go_to_point(best_point,buffer,40);
  }

  face_only_neck_to_ball();

  return AQ_ActionQueued;
}

/*****************************************************************************************/

ActionQueueRes get_open_for_pass_from_in_rectangle(Rectangle *rect,Vector from)
{
  Vector best_point;

  if ( Mem->MyPositionType() == PT_Forward )
    best_point = Mem->LeastCongestedValidPointForPassFromInRectangle(rect,from,TRUE,
								     Mem->MarkerPosition(Mem->RM_Their_Goal));
  else
    best_point = Mem->LeastCongestedValidPointForPassFromInRectangle(rect,from);

  if ( !rect->IsWithin(best_point) ){
    if ( best_point != rect->Center() + Vector(rect->Width(),0) )
      my_error("Why isn't the point in the rectangle????");
    return AQ_ActionNotQueued;
  }

  int buffer = 3;

  if ( Mem->DistanceTo(best_point) < buffer ){
    Mem->LogAction2(30, "get_open_for_pass_from_in_rectangle:  already there");
    scan_field_with_body();
  }
  else{
    Mem->LogAction4(30, "get_open_for_pass_from_in_rectangle:  going to (%.1f %.1f)",
		   best_point.x,best_point.y);
    go_to_point(best_point,buffer,40);
  }

  face_only_neck_to_ball();

  return AQ_ActionQueued;
}

/*****************************************************************************************/

void passive_defend()
{
  Unum mark = Mem->MyMark();
  if ( Mem->CP_mark && mark != Unum_Unknown && Mem->OpponentPositionValid(mark) ){
    float ball_dist = Mem->OpponentDistanceToBall(mark);
    float track_dist = (ball_dist/Mem->SP_pitch_width)*
      (Mem->CP_track_max_distance - Mem->CP_track_min_distance) +  Mem->CP_track_min_distance;  /* scale */
    Mem->LogAction3(30, "passive_defend:  tracking opponent %d",mark);
    track_opponent( mark,track_dist );
    return;
  }

  Mem->LogAction2(30, "passive_defend:  no mark -- going to position");
  go_to_position();
}

/*****************************************************************************************/

void auxiliary_defend()
{
  Unum mark = Mem->MyMark();
  if ( mark != Unum_Unknown && Mem->OpponentPositionValid(mark) ){
    Mem->LogAction3(30, "auxiliary_defend:  marking oponent %d",mark);
    mark_opponent( mark,3 );
    return;
  }

  Mem->LogAction2(30, "auxiliary_defend:  no mark -- going to position");
  go_to_position();
}

/*****************************************************************************************/

void active_defend()
{
  Unum opp = Mem->OpponentWithBall(-Mem->CP_their_breakaway_front_kickable_buffer);
  if ( opp != Unum_Unknown ){
    Mem->LogAction3(30, "active_defend:  going after opponent with ball (%d)",opp);
    defensive_block_opponent(opp,Mem->SP_max_power,Mem->MarkerPosition(Mem->RM_My_Goal));
    face_only_neck_to_ball();
    return;
  }

  Mem->LogAction2(30, "active_defend:  no opponent with ball -- going for ball");
  get_ball();
}

/*****************************************************************************************/

void clear_ball()
{
  if (!Mem->BallKickable())
    my_error("clear_ball: ball not kickable");

  AngleDeg ang = Mem->ClearTarget();

  Mem->LogAction3(30, "clear_ball:  target ang == %.1f",ang);
  kick_ball(ang, Mem->BestKickMode(ang));
}

/*****************************************************************************************/

void send_ball()
{
  if (!Mem->BallKickable())
    my_error("send_ball: ball not kickable");

  AngleDeg ang = Mem->ClearTargetOffensive();
  //cout << "clear angle: " << ang << endl;
  Vector ball_traj = Polar2Vector(2 * Mem->SP_pitch_length, ang + Mem->MyBodyAng());
  Line trajLine = LineFromRay(Mem->BallAbsolutePosition(), ball_traj);
  Rectangle rect = Mem->FieldRectangle.shrink(5);
  if ( !rect.IsWithin(Mem->BallAbsolutePosition()) )
    rect = Mem->FieldRectangle;
  Vector target =
    AdjustPtToRectOnLine(Mem->BallAbsolutePosition() + ball_traj,
			 rect, trajLine);
  //if it's in their penalty area, then stop the ball at the penalty area
  //we use our pos becuase we want the nearest edge
  //cout << "target1: " << target << endl;
  Vector target2 =
    AdjustPtToRectOnLine(Mem->MyPos(), Mem->TheirPenaltyArea, trajLine);
  if (target2.dist(Mem->MyPos()) > Mem->CP_at_point_buffer)
    target = target2;
  //cout << "target2: " << target << endl;
  float target_vel = Mem->VelAtPt2VelAtFoot(target, 0);
  //cout << "target_vel: " << target_vel << endl;
  KickMode mode = Mem->BestKickMode(ang);
  TurnDir rotation = KickRotationDirection(ang);

  Mem->LogAction4(30, "send_ball:  starting kick to (%.1f %.1f)",target.x,target.y);
  
  kick_ball(ang, mode, target_vel, rotation);
}

/*****************************************************************************************/

ActionQueueRes defensive_block_opponent(Unum opponent,float dash_power,Vector block_targ)
{
  DebugBlock(cout << "block_targ: " << block_targ << endl);
  if (!Mem->BallPositionValid())
    my_error("defensive_block_opponent: lost ball");

  if (!Mem->OpponentPositionValid(opponent))
    my_error("defensive_block_opponent: lost opponent");

  Mem->LogAction3(30, "defensive_block_opponent: TheirBreakaway (%d)",Mem->TheirBreakaway());

  Line TrajLine = LineFromTwoPoints(Mem->OpponentAbsolutePosition(opponent),
				    block_targ);
#ifdef OLD_CODE
  if ((Mem->def_block_overrun_time == Mem->CurrentTime - 1 &&
       Mem->def_block_overrun) ||
      TrajLine.IsPtCloserToPtOnLine(Mem->OpponentAbsolutePosition(opponent),
				    Mem->MyPos(), block_targ)) {
  }
#endif	
  if ((Mem->def_block_overrun_time == Mem->CurrentTime - 1 &&
       Mem->def_block_overrun) ||
      !Mem->AmIInCone(Mem->TheirBreakawayConeRatio(opponent), block_targ,
		      Mem->OpponentAbsolutePosition(opponent))) {    
    //change_view(VW_Wide);  /* not needed with neck */
    /* opponent is past us, and we're overrunning */
    DebugBlock(cout << "Overrunning opponent" << endl);
    DebugBlock(cout << "Opponent position"
	      << Mem->OpponentAbsolutePosition(opponent) << endl);
    Vector targ = Mem->OverrunBlockPos(block_targ, opponent, TrajLine);

    if (!IsPointInCone(targ, Mem->TheirBreakawayConeRatio(opponent), block_targ,
		       Mem->OpponentAbsolutePosition(opponent))) {    
      /* in order for everything to work, a succesful overrun shoudl make it not
	 theri breakaway, but this depends on lots of parameter:
	 CP_def_block_dist
	 CP_def_block_dist_ratio;
	 CP_their_breakaway_min_cone_dist_wid; */
      my_error("Overrun target is not in the breakaway cone!");
    }
    
    DebugBlock(cout << "MyPos: " << Mem->MyPos() << endl);
    DebugBlock(cout << "targ: " << targ << endl);
    if (Mem->AtPos(targ)) {
      //we reached the overrun position! we'll fall through to below code
      Mem->def_block_overrun = FALSE;
      Mem->def_block_overrun_time = Mem->CurrentTime;  
    } else {
      //SMURF: use greater dash power?
      Mem->LogAction4(30, "defensive_block_opponent: overrunning opponent to (%.1f %.1f)",targ.x,targ.y);
      go_to_point(targ, Mem->CP_at_point_buffer, 100, DT_none); /* not dodging */
      Mem->def_block_overrun = TRUE;
      Mem->def_block_overrun_time = Mem->CurrentTime;
      return AQ_ActionQueued;
    }	  
  }

  /* this could 'fall through' if we reached the overrun spot */
  if (!(Mem->def_block_overrun_time == Mem->CurrentTime && Mem->def_block_overrun)) {
    DebugBlock(cout << "BallPos: " << Mem->BallAbsolutePosition() << endl);
    DebugBlock(cout << "OppPos : " << Mem->OpponentAbsolutePosition(opponent) << endl);
    DebugBlock(cout << "Dist: " << (Mem->BallAbsolutePosition() - Mem->OpponentAbsolutePosition(opponent)).mod() << endl);

    DebugBlock(cout << "blocking opponent" << endl);
    Mem->def_block_overrun = FALSE;
    Mem->def_block_overrun_time = Mem->CurrentTime;  
    Mem->LogAction4(30, 
		   "defensive_block_opponent: overran player, now moving to point in between: (%.1f, %.1f)",
		   block_targ.x,block_targ.y);
    //    if ( Mem->OpponentAbsolutePosition(opponent).dist2(Mem->MarkerPosition(Mem->RM_My_Goal)) <=
    //	 Mem->BallAbsolutePosition().dist2(Mem->MarkerPosition(Mem->RM_My_Goal)) )
    return move_to_point_in_between(Mem->OpponentAbsolutePosition(opponent), block_targ,
				    Mem->CP_def_block_dist,dash_power);
    //    else
    //      return move_to_point_in_between(Mem->BallAbsolutePosition(), block_targ,
    //				      Mem->CP_def_block_dist,dash_power);
  }

  my_error("defensive_block_opponent: how did I get here?");
  return AQ_ActionNotQueued;
}
#endif // RELEASE_VERSION
