/* -*- Mode: C++ -*- */

/* Memory.h
 * CMUnited99 (soccer client for Robocup99)
 * Peter Stone <pstone@cs.cmu.edu>
 * Computer Science Department
 * Carnegie Mellon University
 * Copyright (C) 1999 Peter Stone
 *
 * CMUnited-99 was created by Peter Stone, Patrick Riley, and Manuela Veloso
 *
 * You may copy and distribute this program freely as long as you retain this notice.
 * If you make any changes or have any comments we would appreciate a message.
 */


#ifndef _MEMORY_H_
#define _MEMORY_H_

#ifndef RELEASE_VERSION  
#include "MemCommunicate.h"
#else
#include "MemAction.h"
#endif // RELEASE_VERSION

#ifndef RELEASE_VERSION  
class Memory : public CommunicateInfo{
#else
class Memory : public ActionInfo{
#endif // !RELEASE_VERSION
public:

  void Initialize(); // depends on the size of the teams

#ifndef RELEASE_VERSION  
  void AssignMarks();
  void ReactToScoreAndTime();
  void ReactToOpponents();
#endif // RELEASE_VERSION
};

/* extern Memory *const Mem; */   /* it's in client.h */

#endif
