/* -*- Mode: C++ -*- */

/* Memory.C
 * CMUnited99 (soccer client for Robocup99)
 * Peter Stone <pstone@cs.cmu.edu>
 * Computer Science Department
 * Carnegie Mellon University
 * Copyright (C) 1999 Peter Stone
 *
 * CMUnited-99 was created by Peter Stone, Patrick Riley, and Manuela Veloso
 *
 * You may copy and distribute this program freely as long as you retain this notice.
 * If you make any changes or have any comments we would appreciate a message.
 */

#include "Memory.h"

void Memory::Initialize()
{
  PlayerInfo::Initialize();
  PositionInfo::Initialize();
#ifndef RELEASE_VERSION  
  FormationInfo::Initialize();
  DTInfo::Initialize();
#endif // RELEASE_VERSION
  ActionInfo::Initialize();
#ifndef RELEASE_VERSION  
  PatInfo::Initialize();
  CommunicateInfo::Initialize();
#endif // RELEASE_VERSION
}

#ifndef RELEASE_VERSION  

/*****************************************************************************/
/** Change the team strategy based on situation and/or opponents             */
/** Can change formation, setplay, coaching, changepositions, echosound,     */
/** Markchangemethod, homechangemethod                                       */
/*****************************************************************************/

void Memory::ReactToScoreAndTime(){
  /* based on score difference and time left */
  int ScoreDiff = MyScore - TheirScore;
  int TimeLeft  = SP_half_time*2 - CurrentTime.t;

  if ( SP_half >= 2 ) TimeLeft -= SP_half_time;

  int MinutesLeft = ((TimeLeft/60)*SP_simulator_step)/1000; /* Lower bound */

  /* if ( MyNumber == 3 && !CurrentTime.t%20) printf("%d  ScoreDiff %d TimeLeft %d  MinutesLeft %d\n",
			      CurrentTime.t, ScoreDiff, TimeLeft, MinutesLeft); */


  if ( SP_use_offside && CP_pull_offsides ) PullOffside = TRUE;
  if ( BallPositionValid() )
    PullOffsidePosition = Min(-10,Max(BallX() - 15,-30));
  else 
    PullOffsidePosition = -30;
  PullOffsidePosition = Min(PullOffsidePosition,my_offside_line-40);


  if ( ScoreDiff < 0 && -ScoreDiff >= MinutesLeft ){
    /*  losing by more than 1 goal/minutes */
    /* printf(" (1) Score Diff = %d,  TimeLeft = %d\n", ScoreDiff, TimeLeft); */
    SetFormation(FormationWhenLosingByLots,CurrentTime);
    return;
  }

  if ( ScoreDiff < 0 && -3*ScoreDiff >= MinutesLeft ){
    /*  losing by more than 1 goal/3 minutes */
    /* printf(" (2) Score Diff = %d,  TimeLeft = %d\n", ScoreDiff, TimeLeft); */
    SetFormation(FormationWhenLosing,CurrentTime);
    return;
  }

  if ( ScoreDiff == 0 && MinutesLeft <= 0 ){
    /* OT or tied with a minute left */
    /* printf(" (3) Score Diff = %d,  TimeLeft = %d\n", ScoreDiff, TimeLeft); */
    SetFormation(FormationWhenTied,CurrentTime);
    return;
  }

  if ( ScoreDiff > 0 && ScoreDiff >= MinutesLeft ){
    /*  winning by more than 1 goal/minute */
    /* printf(" (4) Score Diff = %d,  TimeLeft = %d\n", ScoreDiff, TimeLeft); */
    SetFormation(FormationWhenWinning,CurrentTime);
    if ( !CP_pull_offsides_when_winning ) PullOffside = FALSE;
    return;
  }

  /* default */
  SetFormation(InitialFormation,CurrentTime);

  return;
}

/*****************************************************************************/

void Memory::ReactToOpponents()
{
  ;
}

/*****************************************************************************/

#define MY_ZONE_LINE -10
void Memory::AssignMarks(){

  /* must be the captain to get here */
  /* call a function that's attached to the unit? */
  /* For now just do it here, and only do it for defensive unit */

  Utype unit = UT_Defense;

  if ( !AmUnitCaptain(unit) )
    my_error("I can only assign marks if I'm the defensive captain");

  /* Look for opponents in "my zone" that don't have a teammate "nearby" */
  /* If there's a teammate not marking someone, assign him to mark       */

  if ( MessageTypePending(UMsg_assign_mark) ) /* wait until said old messages */
    return;
  
  Pnum *members = UnitMembers(unit);
  int num_free_to_mark = 0;
  Bool *members_assigned = new Bool[UnitSize(unit)];
  for (int j=0; j<UnitSize(unit); j++){
    members_assigned[j] = FALSE;
    if ( PositionMark(members[j]) == Unum_Unknown && PositionType(members[j]) > PT_Sweeper )
      num_free_to_mark++;
  }

  for (int opp=1; opp<=SP_team_size; opp++){

    if ( !OpponentPositionValid(opp) || OpponentX(opp) > MY_ZONE_LINE )
      continue;

    if ( OpponentMarked(opp) ){
      /* printf("Opponent %d already marked\n",i); */
      continue;
    }

    /* choose a player to mark the opponent        */
    /* Keep track of who's marking and who's free? */
    /* Make an auxiliary array in Unit???          */
    Unum player,mark;
    Pnum position;
    float tmp,min_dist = HUGE;
    Pnum best_pos = Pnum_Unknown;
    int members_index = 0;
    for (int j=0; j<UnitSize(unit); j++){
      position = members[j];
      player = PositionPlayer(position);

      if ( PositionType(position) <= PT_Sweeper )
	continue;

      if ( members_assigned[j] == TRUE )
	continue;

      if ( player == Unum_Unknown ){
	SayToPosition(position,PMsg_ping);
	break;
      }

      if ( (mark=PositionMark(position)) != Unum_Unknown ){
	if ( num_free_to_mark > 0 )
	  continue; /* player already marking, other options exist */
	Vector goal = MarkerPosition(RM_My_Goal);
	if ( !OpponentPositionValid(mark) ||
	     OpponentDistanceTo(opp,goal) > OpponentDistanceTo(mark,goal) - 5 )
	  continue; /* player already marking someone closer */
      }

      if ( (tmp=DistanceToPositionHome(position,OpponentAbsolutePosition(opp),TRUE)) < min_dist ){
	min_dist = tmp;
	best_pos = position;
	members_index = j;
      }
    }
    if ( best_pos != Pnum_Unknown ){
      //printf("%d assigning %d (%d) to mark %d (%d)\n",CurrentTime.t,PositionPlayer(best_pos),best_pos,opp,members_index); 
      members_assigned[members_index] = TRUE;
      if ( PositionPlayer(best_pos) == MyNumber )
	SetMyMark(opp,CurrentTime);
      else
	SayToUnit(unit,UMsg_assign_mark,opp,best_pos);
    }
  }
  delete [] members_assigned;

  /* If there's an unoccupied position in my unit, and if it's important,*/
  /* assign someone else to it                                           */
}

#endif // RELEASE_VERSION











