/* -*- Mode: C++ -*- */

/* MemAction.h
 * CMUnited99 (soccer client for Robocup99)
 * Peter Stone <pstone@cs.cmu.edu>
 * Computer Science Department
 * Carnegie Mellon University
 * Copyright (C) 1999 Peter Stone
 *
 * CMUnited-99 was created by Peter Stone, Patrick Riley, and Manuela Veloso
 *
 * You may copy and distribute this program freely as long as you retain this notice.
 * If you make any changes or have any comments we would appreciate a message.
 */

#ifndef _MEMACTION_H_
#define _MEMACTION_H_

#ifndef RELEASE_VERSION  
#include "MemSetplay.h"
#else
#include "MemPosition.h"
#endif // !RELEASE_VERSION

/****************************************************************************************/

typedef struct PLAYERINTERCEPTINFO 
{
  Time time;
  float dash_pow;
  int lookahead;
  InterceptRes res;
  int numCyc;
  Vector pos;
  float dash_pow_to_use;
} PlayerInterceptInfo;

typedef struct TURNKICKCOMMAND 
{
  CMDType type;
  Time time;
  float angle;
  float power;  
  Bool turn_neck;
  float turn_neck_angle;
} TurnKickCommand;

const int LA_Default = -2;
const int LA_BestSoFar = -1;




/****************************************************************************************/
/****************************************************************************************/
/****************************************************************************************/

#ifndef RELEASE_VERSION  
class ActionInfo : public SetplayInfo{
#else	
  class ActionInfo : public PositionInfo{
#endif // !RELEASE_VERSION
public:

  void Initialize();

#ifndef RELEASE_VERSION  
  void UpdateActionMode();
  ActionMode MyActionMode;
#endif
  
  // these are for hard kicking 
  Time HKTime;
  int HKStep;
  int HKStepNext;
  TurnDir HKrot;

  float VelAtPt2VelAtFoot(Vector pt, float targ_vel_at_pt);

  /* these are for ball interception */
  InterceptRes PlayerInterceptionResult(char side, Unum num, float dash_pow);
  InterceptRes PlayerInterceptionResult(char side, Unum num)
    { return PlayerInterceptionResult(side, num, 
				      (side==MySide && TeammateTired(num)) ? SP_stamina_inc : SP_max_power); }
  Bool PlayerInterceptionAble(char side, Unum num, float dash_pow);
  Bool PlayerInterceptionAble(char side, Unum num)
    { return PlayerInterceptionAble(side, num, 
				    (side==MySide && TeammateTired(num)) ? SP_stamina_inc : SP_max_power); }
  int PlayerInterceptionNumberCycles(char side, Unum num, float dash_pow);
  int PlayerInterceptionNumberCycles(char side, Unum num)
    { return PlayerInterceptionNumberCycles(side, num, 
					    (side==MySide&&TeammateTired(num)) ? SP_stamina_inc:SP_max_power); }
  Vector PlayerInterceptionPoint(char side, Unum num, float dash_pow);
  Vector PlayerInterceptionPoint(char side, Unum num)
    { return PlayerInterceptionPoint(side, num, 
				     (side==MySide && TeammateTired(num)) ? SP_stamina_inc : SP_max_power); }
  float PlayerInterceptionDashPower(char side, Unum num, float dash_pow);
  float PlayerInterceptionDashPower(char side, Unum num)
    { return PlayerInterceptionDashPower(side, num, 
					 (side==MySide && TeammateTired(num)) ? SP_stamina_inc : SP_max_power); }
  
  InterceptRes TeammateInterceptionResult(Unum num, float dash_pow)
    { return PlayerInterceptionResult(MySide, num, dash_pow); }
  InterceptRes TeammateInterceptionResult(Unum num)
    { return (num == MyNumber) ?
	MyInterceptionResult() :
      TeammateInterceptionResult(num, TeammateTired(num) ? SP_stamina_inc : SP_max_power);
    }
  Bool TeammateInterceptionAble(Unum num, float dash_pow)
    { return PlayerInterceptionAble(MySide, num, dash_pow); }
  Bool TeammateInterceptionAble(Unum num)
    { return (num == MyNumber) ?
	MyInterceptionAble() :
      TeammateInterceptionAble(num, TeammateTired(num) ? SP_stamina_inc : SP_max_power);
    }
  int TeammateInterceptionNumberCycles(Unum num, float dash_pow)
    { return PlayerInterceptionNumberCycles(MySide, num, dash_pow); }
  int TeammateInterceptionNumberCycles(Unum num)
    { return  (num == MyNumber) ?
	MyInterceptionNumberCycles() :
      TeammateInterceptionNumberCycles(num, TeammateTired(num) ? SP_stamina_inc : SP_max_power);
    }
  Vector TeammateInterceptionPoint(Unum num, float dash_pow)
    { return PlayerInterceptionPoint(MySide, num, dash_pow); }
  Vector TeammateInterceptionPoint(Unum num)
    { return  (num == MyNumber) ?
	MyInterceptionPoint() :
      TeammateInterceptionPoint(num, TeammateTired(num) ? SP_stamina_inc : SP_max_power); }
  float TeammateInterceptionDashPower(Unum num, float dash_pow)
    { return PlayerInterceptionDashPower(MySide, num, dash_pow); }
  float TeammateInterceptionDashPower(Unum num)
    { return  (num == MyNumber) ?
	MyInterceptionDashPower() :
      TeammateInterceptionDashPower(num, TeammateTired(num) ? SP_stamina_inc : SP_max_power);
    }

  InterceptRes OpponentInterceptionResult(Unum num, float dash_pow)
    { return PlayerInterceptionResult(TheirSide, num, dash_pow); }
  InterceptRes OpponentInterceptionResult(Unum num)
    { return OpponentInterceptionResult(num, SP_max_power); }
  Bool OpponentInterceptionAble(Unum num, float dash_pow)
    { return PlayerInterceptionAble(TheirSide, num, dash_pow); }
  Bool OpponentInterceptionAble(Unum num)
    { return OpponentInterceptionAble(num, SP_max_power); }
  int OpponentInterceptionNumberCycles(Unum num, float dash_pow)
    { return PlayerInterceptionNumberCycles(TheirSide, num, dash_pow); }
  int OpponentInterceptionNumberCycles(Unum num)
    { return OpponentInterceptionNumberCycles(num, SP_max_power); }
  Vector OpponentInterceptionPoint(Unum num, float dash_pow)
    { return PlayerInterceptionPoint(TheirSide, num, dash_pow); }
  Vector OpponentInterceptionPoint(Unum num)
    { return OpponentInterceptionPoint(num, SP_max_power); }
  float OpponentInterceptionDashPower(Unum num, float dash_pow)
    { return PlayerInterceptionDashPower(TheirSide, num, dash_pow); }
  float OpponentInterceptionDashPower(Unum num)
    { return OpponentInterceptionDashPower(num, SP_max_power); }

  InterceptRes MyInterceptionResult(float dash_pow)
    { return PlayerInterceptionResult(MySide, MyNumber, dash_pow); }
  InterceptRes MyInterceptionResult()
    { return MyInterceptionResult(CorrectDashPowerForStamina(SP_max_power)); }
  Bool MyInterceptionAble(float dash_pow)
    { return PlayerInterceptionAble(MySide, MyNumber, dash_pow); }
  Bool MyInterceptionAble()
    { return MyInterceptionAble(CorrectDashPowerForStamina(SP_max_power)); }
  int MyInterceptionNumberCycles(float dash_pow)
    { return PlayerInterceptionNumberCycles(MySide, MyNumber, dash_pow); }
  int MyInterceptionNumberCycles()
    { return MyInterceptionNumberCycles(CorrectDashPowerForStamina(SP_max_power)); }
  Vector MyInterceptionPoint(float dash_pow)
    { return PlayerInterceptionPoint(MySide, MyNumber, dash_pow); }
  Vector MyInterceptionPoint()
    { return MyInterceptionPoint(CorrectDashPowerForStamina(SP_max_power)); }
  float MyInterceptionDashPower(float dash_pow)
    { return PlayerInterceptionDashPower(MySide, MyNumber, dash_pow); }
  float MyInterceptionDashPower()
    { return MyInterceptionDashPower(CorrectDashPowerForStamina(SP_max_power)); }

  /* just min of what's been done so far - returns -1 if nothing done */
  int GetInterceptionMinCyc();
  inline void ResetInterceptionMinCyc()  { IntMinCycTime -= 1; }
  inline int  GetInterceptionLookahead() { return InterceptLookahead; }
  void SetInterceptionLookahead(int newval);

  Bool BallPathInterceptValid();
  Vector BallPathInterceptPoint();
  Bool BallPathInterceptAmIThere(float buffer);
  Bool BallPathInterceptAmIThere()
    { return BallPathInterceptAmIThere(CP_at_point_buffer); }
  float BallPathInterceptDistance();
  /* careful! if ball is kickable, next func returns 0 */
  int BallPathInterceptCyclesForBall();
  Bool BallPathInterceptCanIGetThere(float max_pow = 100.0);

  KickMode BestKickModeAbs(AngleDeg abs_ang);
  KickMode BestKickMode(AngleDeg rel_ang)  /* Angle relative to body */
    { return BestKickModeAbs(GetNormalizeAngleDeg(rel_ang + MyBodyAng())); }

  int EstimatedCyclesToSteal(Unum opp, Vector ball_pos);  
  inline int EstimatedCyclesToSteal(Unum opp, AngleDeg ball_ang) //absolute angle
    { return EstimatedCyclesToSteal(opp, MyPos() +
				    Polar2Vector(CP_opt_ctrl_dist, ball_ang));
    }
  inline int EstimatedCyclesToSteal(Unum opp)
    {
      if (!BallPositionValid())
	my_error("EstimateCyclesToSteal: don;t know where ball is");
      return EstimatedCyclesToSteal(opp, BallAbsolutePosition());
    }

#ifndef RELEASE_VERSION  
  int NumCyclesGoalieBeatsBall(Vector from_spot, float abs_shot_ang,
			       float shot_vel, Unum goalie = Unum_Unknown);
  int NumCyclesGoalieBeatsBall(Vector from_spot, Vector shot_targ,
			       float shot_vel, Unum goalie = Unum_Unknown)
    { return NumCyclesGoalieBeatsBall(from_spot, (shot_targ - from_spot).dir(),
				      shot_vel, goalie);
    }
  int NumCyclesGoalieBeatsBall(float abs_shot_ang,
			       float shot_vel, Unum goalie = Unum_Unknown)
    { return NumCyclesGoalieBeatsBall(BallAbsolutePosition(), abs_shot_ang,
				      shot_vel, goalie);
    }
  int NumCyclesGoalieBeatsBall(Vector shot_targ,
			       float shot_vel, Unum goalie = Unum_Unknown)
    { return NumCyclesGoalieBeatsBall(BallAbsolutePosition(), shot_targ,
				      shot_vel, goalie);
    }
      
  
  Bool CouldGoalieBlockShotFromSpot(Vector from_spot, float abs_shot_ang, float shot_vel,
				    int goalie_react_time = 1, Unum goalie = Unum_Unknown)
    {
      return (NumCyclesGoalieBeatsBall(from_spot, abs_shot_ang, shot_vel, goalie) <  goalie_react_time)
	? FALSE : TRUE;
    }  
  Bool CouldGoalieBlockShot(float abs_shot_ang, float shot_vel,
			    int goalie_react_time = 1, Unum goalie = Unum_Unknown)
    { return CouldGoalieBlockShotFromSpot(BallAbsolutePosition(),
					  abs_shot_ang, shot_vel,
					  goalie_react_time, goalie);
    }
  Bool CouldGoalieBlockShotFromSpot(Vector from_spot, Vector shot_targ, float shot_vel,
				    int goalie_react_time = 1, Unum goalie = Unum_Unknown)
    { return CouldGoalieBlockShotFromSpot(from_spot, (shot_targ - from_spot).dir(),
					  shot_vel, goalie_react_time, goalie);
    }
  Bool CouldGoalieBlockShot(Vector shot_targ, float shot_vel,
			    int goalie_react_time = 1, Unum goalie = Unum_Unknown)
    { return CouldGoalieBlockShotFromSpot(BallAbsolutePosition(),
					  (shot_targ - MyPos()).dir(), shot_vel,
					  goalie_react_time, goalie);
    }
#endif // RELEASE_VERSION
  
  Bool WillDashHelpKick(Vector pt, float dash_pow);
  Bool WillDashHelpKick(Vector pt)
    { return WillDashHelpKick(pt, SP_max_power); }


#ifndef RELEASE_VERSION  
  Unum BreakawayPassTarget();
  Vector BreakawayApproachPoint();
  int BreakawayKickRunCycles();
  
  Bool     HaveAShot();
  Bool     HasAShot(Unum teammate);
  Bool     HaveAGoodShot();
  Bool     HasAGoodShot(Unum teammate);
  Bool     HaveAGreatShot();
  Bool     HasAGreatShot(Unum teammate);
  Bool     HasABetterShot(Unum teammate);

  KickMode ShotMode();
  Vector   ShotTarget(Vector from_pos);
  Vector   ShotTarget() { return ShotTarget(BallAbsolutePosition()); }

  Unum     PassTarget(Bool use_receiver_list,PassChoiceType choice_type,PassFilterType filter_type = PF_None);
  Bool     NeedToClear();
  float    EvaluateClearAngle(Vector end);
  AngleDeg ClearTarget();
  AngleDeg ClearTargetOffensive();
  Bool     CanWeDribbleAroundOpponent();
  Bool     CanDribbleTowards(Vector pt);
  Bool     CanDribbleTo(Vector pt);  
  Bool     CanDribble();
  Vector   DribbleTarget();
  Bool     CanKeepBall();

  Bool ShouldICross();
  Bool ShouldIMoveToCross();
  
  /* if we get beat in block mode, we need to overrun */
  Vector   OverrunBlockPos(Vector block_targ, Unum opponent, Line TrajLine);
  Time def_block_overrun_time;
  Bool def_block_overrun;

  Time my_breakaway_time; /* time we last thought we had a breakaway */
  Vector my_breakaway_targ; /* the current dribbling or kick-run target in breakaway */
  Bool my_breakaway_dribble; /* whether we are dribbling or kick-running */

#endif

  
  Bool KickInProgress(); 
  void StartKick(AngleDeg target_angle, KickMode mode, float target_vel, TurnDir rot=TURN_AVOID);
  void StartShot(AngleDeg target_angle, KickMode mode, TurnDir rot=TURN_AVOID);
  void StartPass(Unum target, float target_vel, TurnDir rot=TURN_AVOID);  
  
  AngleDeg       kick_in_progress_abs_angle;
  float          kick_in_progress_target_vel;
  KickMode       kick_in_progress_mode;
  TurnDir        kick_in_progress_rotation;

  Unum team_receiver;
  Unum team_passer; 
  Time team_pass_time;

#ifndef RELEASE_VERSION  
  Bool goalie_after_catch;
  Bool goalie_moved_after_catch;
  Time goalie_last_catch_time;
  Time GoalieWarnTime;
#endif // RELEASE_VERSION

  Unum FastestTeammateToBall();
  Unum FastestOpponentToBall();
  Unum BallPossessor();   /* possessor means can get there quickest */
  char TeamInPossession();

#ifndef RELEASE_VERSION  
  Unum OurBreakaway();
  Unum TheirBreakaway();
  float TheirBreakawayConeRatio(Unum opp_ball) 
    { return (SP_goal_area_width/2) /
	Min(OpponentDistanceTo(opp_ball, MarkerPosition(RM_My_Goal)),
	    CP_their_breakaway_min_cone_dist_wid); }
#endif // RELEASE_VERSION

#ifndef RELEASE_VERSION  
  /* this is just our goalie position for thier half of the field */
  Vector TheirGoalieDesiredPosition();
#endif // RELEASE_VERSION
  
  Unum LastBallPossessor;
  Time LastBallPossessorTime;

#ifndef RELEASE_VERSION  
  inline void SetDribbleTime(Time t) { dribble_time = t;     }
  inline Time GetDribbleTime()       { return dribble_time;  }
  inline Bool DribbleInProgress() { return (dribble_time == CurrentTime-1 ? TRUE : FALSE); }
  inline void SetDribbling(Vector target, float dash_power, float buffer) 
    { SetDribbleTime(CurrentTime); dribble_in_progress_target = target;
    dribble_in_progress_dash_power = dash_power; dribble_in_progress_buffer = buffer; }

  Vector dribble_in_progress_target;
  float  dribble_in_progress_dash_power;
  float  dribble_in_progress_buffer;

  Time ChangeViewForHandleBallTime;
#endif

private:
  Bool           kick_in_progress;
  Time           start_kick_time;
  Time           kick_in_progress_time;

#ifndef RELEASE_VERSION  
  Time           dribble_time; /* Last time we called DribbleTo */

  Time           DribbleTargetTime;
  Vector         DribbleTargetVector;
  Bool           DribbleTargetAvailable;
#endif

  PlayerInterceptInfo* TeamIntInfo[MAX_PLAYERS];
  PlayerInterceptInfo* OppIntInfo[MAX_PLAYERS];

  Time Stored_Fastest_Teammate_Time;
  Unum Stored_Fastest_Teammate;
  Time Stored_Fastest_Opponent_Time;
  Unum Stored_Fastest_Opponent;

  int InterceptLookahead; /* can either be a positve number or a LA_constant
			     from above */
  int IntMinCyc;
  Time IntMinCycTime;
  void SetIntMinCyc(int newval);

  void BallIntercept_active(float max_pow_to_use, int max_lookahead,
			    char PlayerSide, Unum PlayerNum,
			    PlayerInterceptInfo* pInfo);
  PlayerInterceptInfo CloseBallInterception(float max_pow, int max_lookahead,
					    Vector vBallPos, Vector vBallVel);
  PlayerInterceptInfo  ActiveCanGetThere(float max_pow, int max_lookahead,
					 Vector vBallPos, Vector vBallVel,
					 char side, Unum num,
					 Vector vPlayerPos, Vector vPlayerVel,
					 float vPlayerAng, int PlayerAngValid,
					 bool IsThisMe);

  PlayerInterceptInfo* GetPlayerIntInfo(char side, Unum num);
  PlayerInterceptInfo* VerifyIntInfo(char side, Unum num, float dash_pow);

  bool IsSuccessRes(InterceptRes res)
    { return (res == BI_CanChase || res == BI_ReadyToKick); }

  Time BPItime;
  Bool BPIvalid;
  Bool BPIable; 
  float BPIdist;
  Vector BPIpoint;
  float BPIballcyc;

  void VerifyBPIInfo();
  int GetClosestPointToBallPath(Vector* pvPt, float* pNumCycles,
				Vector PlayerPos, Vector BallPos,
				Vector BallVel);
  void BallIntercept_passive(float max_pow_to_use, 
			     PlayerInterceptInfo* pInfo);      
};

inline Bool ActionInfo::BallPathInterceptValid()
{
  VerifyBPIInfo();
  return BPIvalid;
}

#endif
