/* -*- Mode: C++ -*- */

/* intercept.C - ball interception functions */
/* reasoning is done in global coorsdinates */

/* returns the gloal Vector to the estimated ball position <cyc> clyles
   in the future */

#include <math.h>
#include "Memory.h"
#include "client.h"
#include "kick.h"
#include "intercept.h"
#include "test.h"
#include "behave.h"

#ifdef DEBUG_OUTPUT
#define DebugInt(x) 
#else
#define DebugInt(x)
#endif


void PatsTest_int(void)
{
  const int IntPower = 75;
  if (Mem->ViewWidth != VW_Wide)
    change_view(VW_Wide);
  //Mem->SetInterceptionLookahead(LA_BestSoFar);
  Mem->SetInterceptionLookahead(LA_Default);
  
  switch (Mem->MyNumber) {
  case 0:
    /* nothing specified- assume kicker*/
    /* fall through */

  case 1:
    PatsTest_kick();
    break;

  case 2:
    /* we are the receiver */
    DebugInt(printf("\nTime: %d\n", Mem->CurrentTime.t));
    if (!Mem->BallPositionValid()) {
      /* turn to face right */
      if (fabs(Mem->MyBodyAng()) > Mem->CP_max_go_to_point_angle_err) {
	
	DebugInt(printf("lost the ball, turning to middle\n"));
	scan_field_with_body();
	//turn(-Mem->MyBodyAng() );
      } else
	DebugInt(cout << "lost ball, but already facing middle" << endl);
      break;
    } 

    if (Mem->BallVelocityValid())
      printf("%d 1 %f %f %f\n", Mem->CurrentTime.t, Mem->BallAbsoluteVelocity().x,
	     Mem->BallAbsoluteVelocity().y, Mem->BallSpeed());
    else
      printf("%d 0 0 0 0\n", Mem->CurrentTime.t);
    
    if (Mem->BallAbsoluteVelocity().x < 0 ) {
    //if (Mem->BallAbsoluteVelocity().y > 0 ) {
      /* ball is coming towards us */
      if (Mem->BallKickable()) {
	DoTurnKickCommand(dokick(0,0,1.0)); /* stop ball */
	DebugInt(printf("Success!!!!\n"));
	return;
      } 

      if (!Mem->MyInterceptionAble(IntPower))
	DebugInt(printf("Could not succesfully intercept ball!\n"));
      else {
	DebugInt(printf("Time: %d; Receiver: Cycles: %d\n", Mem->CurrentTime.t,
			Mem->MyInterceptionNumberCycles(IntPower)));
	DebugInt(cout << "Point: " << Mem->MyInterceptionPoint(IntPower) << endl);
	go_to_point(Mem->MyInterceptionPoint(IntPower),
		    Mem->SP_kickable_area/4, IntPower);
      }
      
    }
    DebugInt(cout << " end of case" << endl);
    break;

  case 3:
    /* watch the other players and say how long it's gonna take them */
    if ((Mem->MyBodyAng() - 90) > 10) {      
      turn(90 - Mem->MyBodyAng());
      return;
    }

    if (!Mem->BallPositionValid())
      return;

    Mem->SetInterceptionLookahead(5);
    printf("Time: %d\n", Mem->CurrentTime.t);
    if (Mem->TeammateInterceptionAble(1, IntPower))
      printf("Watcher: P1: cycles: %d\n",
	     Mem->TeammateInterceptionNumberCycles(1, IntPower));
    if (Mem->TeammateInterceptionAble(2, IntPower))
      printf("Watcher: P2: cycles: %d\n",
	     Mem->TeammateInterceptionNumberCycles(2, IntPower));

    break;
    
  } 
} 

void PatsTest_BPI()
{
  switch (Mem->MyNumber) {
  case 0:
    /* nothing specified- assume kicker*/
    /* fall through */

  case 1:
    PatsTest_kick();
    break;

  case 2:
    /* we are the receiver */
    if (!Mem->BallPositionValid()) {
      /* turn to face right */
      if (fabs(Mem->MyBodyAng()) > Mem->CP_max_go_to_point_angle_err) {	
	DebugInt(printf("lost the ball, turning to middle\n"));
	turn(-Mem->MyBodyAng() );
      }      
      break;
    } 

    if (Mem->BallAbsoluteVelocity().x < 0 ) {
      /* ball is coming towards us */
      if (Mem->BallKickable()) {
	DoTurnKickCommand(dokick(0,0,1.0)); /* stop ball */
	DebugInt(printf("Success!!!!\n"));
	return;
      } 

      //printf("\nTime: %d\n", Mem->CurrentTime.t);
      if (!Mem->BallPathInterceptValid() ||
	  !Mem->BallPathInterceptCanIGetThere(75))
	DebugInt(printf("Could not succesfully intercept ball!\n"));
      else {
	if (Mem->BallPathInterceptAmIThere(Mem->SP_kickable_area/4)) {
	  if (fabs(Mem->MyBodyAng()) > Mem->CP_max_go_to_point_angle_err) {	
	    DebugInt(printf("at the point, turning and waiting\n"));
	    turn( -Mem->MyBodyAng() );
	  }      	  
	}
	    
	test_go_to_point(Mem->BallPathInterceptPoint(),
			 Mem->SP_kickable_area/4, 75);
      }
      
    } 
    break;
  }
  
}




