/* -*- Mode: C++ -*- */

#include <math.h>
#include "Memory.h"
#include "client.h"
#include "kick.h"
#include "behave.h"
#include "goalie.h"


#ifdef DEBUG_OUTPUT
#define DebugGoal(x) x
#define DebugGoal2(x) x
#else
#define DebugGoal(x)
#define DebugGoal2(x) 
#endif

/*****************************************************************************************/

/* the goalie's version of the behave function */
/* this has only casually been updated to handle the new neck.
   Unless the goalie is scanning the field, it will always be watching the
   ball by using the neck. Therefore, there are some superfluous turn commands
   in here */
void goalie_behave()
{
  DebugGoal(cout << endl << "Time: " << Mem->CurrentTime.t << endl);
  //SMURF: what about a WithBall mode?

  /* first make sure the goalie after_catch vars are set correctly */
  if (Mem->PlayMode == PM_My_Goalie_Free_Kick && !Mem->goalie_after_catch) {
    Mem->goalie_after_catch = TRUE;
    Mem->goalie_moved_after_catch = FALSE;
    return;
  }
  if (Mem->PlayMode == PM_Play_On) {
    Mem->goalie_after_catch = FALSE;
  }

  /* Check my stamina */
  if (Mem->MyStamina() < Mem->EffortDecThreshold) {
    my_error("Goalie going below effort threshold: %f", Mem->MyStamina());
    if (Mem->MyStamina() < Mem->RecoveryDecThreshold) {
      my_error("Goalie going below recovery threshold: %f", Mem->MyStamina());
    }
  }
  
  
  /* Now do the main action conditionals */
  if (!Mem->MyConf()) {
    Mem->LogAction2(10, "Don't know wher I am, scannign field");
    scan_field_with_body();
  } else if ( Mem->PlayMode == PM_Before_Kick_Off && !Mem->InOwnPenaltyArea()) {
    Mem->LogAction2(10, "Moving to home position");
    move(-Mem->SP_pitch_length/2 + Mem->SP_goal_area_length, 0);
  } else if (Mem->goalie_after_catch) {
    Mem->LogAction2(10, "In after_catch mode");
    goalie_after_catch();
/* SMURF: need to reason about kicking correctly 
  } else if ( Mem->BallKickable() && Mem->LastActionType() == CMD_kick) {
    Mem->LogAction2(10, "Looks like I kicked it last time, so kicking again");
    goalie_clear_ball();
*/
  } else if (!Mem->BallPositionValid()) {
    Mem->LogAction2(10, "Looking for ball");
    goalie_scan_field();
  } else if (ShouldICatch()) {
    Mem->LogAction2(10, "Catching the ball");
    goalie_catch_ball();
  } else if (ShouldIKick()) {
    Mem->LogAction2(10, "Kicking (clearing) the ball");
    goalie_clear_ball();
  } else if (!Mem->BallVelocityValid()) {
    if (Mem->OwnPenaltyArea.IsWithin(Mem->BallAbsolutePosition())) {
      Mem->LogAction2(10, "Ball velocity unknown, but it's in the penalty area. Yikes!");
      goalie_go_to_point(Mem->BallAbsolutePosition(), SVS_FavorSpeed);
    } else {
      Mem->LogAction2(10, "Ball velocity unknown, going to position");
      goalie_go_to_position(); //SMURF: is this really the right thing to do?
    }    
  } else if (Mem->CP_goalie_comes_out && ShouldIComeOutToOpponent()) {
    Mem->LogAction2(10, "coming out to opponent");
    goalie_block_opponent();
  } else if (Mem->PlayMode == PM_Play_On && (IsShot() || ShouldIGoToBall())) {
    Mem->LogAction2(10, "Intercepting ball");
    goalie_intercept();
  } else {
    Mem->LogAction2(10, "Don't know what else to do, going to position");
    goalie_go_to_position();
  }
  
  /* turn our neck so that we can see the ball */
  if (!Mem->TurnNeckThisCycle() && Mem->MyConf() && Mem->BallPositionValid()) {
    Mem->LogAction2(40, "Turning my neck to ball");
    float pred_my_body_ang = Mem->MyBodyAng();
    if (Mem->Action->valid(Mem->CurrentTime) &&
	Mem->Action->type == CMD_turn) {
      Mem->LogAction2(60, "Planning for a turn we want");
      //pred_my_body_ang += Mem->Action->angle; 
      pred_my_body_ang += Mem->EffectiveTurn(Mem->Action->angle); 
    }
    Mem->LogAction3(70, "pred_my_body_ang: %f", pred_my_body_ang);
    float pred_rel_body_ball_ang =
      (Mem->BallPredictedPosition() - Mem->MyPredictedPosition()).dir() -
      pred_my_body_ang;
    NormalizeAngleDeg(&pred_rel_body_ball_ang);
    float targ_neck_ang = MinMax(Mem->SP_min_neck_angle,
				 pred_rel_body_ball_ang,
				 Mem->SP_max_neck_angle);
    Mem->LogAction4 (50, "Pred Relative to body ball angle: %f\t: target_neck_ang: %f",
	       pred_rel_body_ball_ang, targ_neck_ang);
    turn_neck(targ_neck_ang - Mem->MyNeckRelAng());
    if (fabs(pred_rel_body_ball_ang) >
	fabs(targ_neck_ang)+Mem->MyViewAngle()) {
      Mem->LogAction2 (40, "Changing view to help me see the ball");
      change_view(VW_Wide);
    }
  }
}

/*****************************************************************************************/

/* given the position of the ball (does not take into account vel),
   decides where the goalie should be */
Vector GoalieDesiredPosition()
{
  if (!Mem->BallPositionValid())
    my_error("GoalieDesiredPosition: need to know where ball is");

  Line l = LineFromTwoPoints(Mem->BallAbsolutePosition(),
			     Mem->MarkerPosition(Mem->RM_My_Goal));
  float d = MinMax(Mem->CP_goalie_min_pos_dist,
		   Mem->MarkerPosition(Mem->RM_My_Goal).dist(Mem->BallAbsolutePosition()),
		   Mem->CP_goalie_max_pos_dist);
  float scale = (d-Mem->CP_goalie_min_pos_dist)/
    (Mem->CP_goalie_max_pos_dist-Mem->CP_goalie_min_pos_dist);

  Rectangle r(-Mem->SP_pitch_length/2, //left
	      Max(-Mem->SP_pitch_length/2 + Mem->CP_goalie_baseline_buffer,
		  Min(-Mem->SP_pitch_length/2 + Mem->CP_goalie_baseline_buffer + 
		      scale*(Mem->SP_penalty_area_length *
			     Mem->CP_goalie_max_forward_percent),
		      Mem->PositionOfFurthestBackPlayer(FALSE).x -
		      Mem->CP_goalie_baseline_buffer)),//right
	      MinMax(-Mem->SP_goal_area_width/2,
		     -scale*Mem->SP_goal_area_width/2,
		     -Mem->SP_goal_width / 2), //top
	      MinMax(Mem->SP_goal_width / 2, 
		     scale*Mem->SP_goal_area_width/2,
		     Mem->SP_goal_area_width/2) ); //bottom  
  scale = Min(Mem->CP_goalie_ball_ang_for_corner, fabs(l.angle()))/
    Mem->CP_goalie_ball_ang_for_corner;
  d = MinMax(Mem->CP_goalie_ball_dist_for_corner,
	     Mem->MarkerPosition(Mem->RM_My_Goal).dist(Mem->BallAbsolutePosition()),
	     Mem->CP_goalie_ball_dist_for_center);
  scale *= (Mem->CP_goalie_ball_dist_for_center - d)/
    (Mem->CP_goalie_ball_dist_for_center-Mem->CP_goalie_ball_dist_for_corner);
  Vector guard_pt = Mem->MarkerPosition(Mem->RM_My_Goal);
  guard_pt.x += Mem->CP_goalie_baseline_buffer;
  guard_pt.y += signf(Mem->BallAbsolutePosition().y -
		      Mem->MarkerPosition(Mem->RM_My_Goal).y) *
    scale*Mem->SP_goal_width / 2;
  DebugGoal(cout << "d: " << d << "\tr: " << r << endl);
  DebugGoal(cout << "scale: " << scale << "\tguard: " << guard_pt << endl);
  //DebugGoal(cout << "side_shrink: " << side_shrink << endl);
  Vector pos =
    AdjustPtToRectOnLine(Mem->BallAbsolutePosition(), r,
			 LineFromTwoPoints(guard_pt, Mem->BallAbsolutePosition()));
  DebugGoal(cout << "pos before free kick correction: " << pos << endl);
  if (Mem->PlayMode == PM_My_Free_Kick &&
      Mem->OwnPenaltyArea.IsWithin(Mem->BallAbsolutePosition())) {      
    /* we need to get out fo the way for free kicks in our penalty area */
    if (pos.dist(Mem->BallAbsolutePosition()) < Mem->CP_goalie_free_kick_dist) {
      /*	Vector ballToPos = pos - Mem->BallAbsolutePosition();
		ballToPos *= Mem->CP_goalie_free_kick_dist / ballToPos.mod();
		pos = Mem->BallAbsolutePosition() + ballToPos;*/
      DebugGoal(cout << "Adjusting for free kick: ball:" << Mem->BallAbsolutePosition()
		<< endl);
      Vector ballToGoal = Mem->MarkerPosition(Mem->RM_My_Goal) -
	Mem->BallAbsolutePosition();
      ballToGoal *= Mem->CP_goalie_free_kick_dist / ballToGoal.mod();
      pos = Mem->BallAbsolutePosition() + ballToGoal;
    }      
  }

  DebugGoal(cout << "GoalieDesiredPosition: " << pos << endl);

  /* Now take a weighted average of the pos and the center of the goalie box
     It weights the goalie box if the the ball is on the far side of the field */
  float center_weight;
  if (Mem->BallX() < -Mem->CP_goalie_position_weight_dist)
    center_weight = 0;
  else if (Mem->BallX() > Mem->CP_goalie_position_weight_dist)
    center_weight = 1;
  else
    center_weight = (Mem->BallX() + Mem->CP_goalie_position_weight_dist) /
      (2 * Mem->CP_goalie_position_weight_dist);

  pos = pos.WeightedAverage(Vector(-Mem->SP_pitch_length/2 + Mem->SP_goal_area_length, 0),
			    center_weight);

  return pos;
}



/*****************************************************************************************/

/* looks at position and velocity of ball and decides if it's a shot
   basically if the ball is headed for the base line in the penalty area
   with enought velocity to get there, it's a shot */
/* we might want to adjust buffer for angle of shot */
/* SMURF: what about distance and possible other players who can redirect? */
Bool IsShot()  
{
  if (!Mem->BallPositionValid())
    my_error("Can't tell if it's shot if BallPosition not valid");
  if (!Mem->BallVelocityValid())
    my_error("Can't tell if it's shot if BallVelocity not valid");
  Line BaseLine = Mem->OwnGoalieArea.LeftEdge();
  if (fabs(Mem->BallAbsoluteVelocity().x) < FLOAT_EPS &&
      fabs(Mem->BallAbsoluteVelocity().y) < FLOAT_EPS)
    return FALSE;
  if (Mem->BallX() > -Mem->SP_pitch_length/2 + Mem->SP_goal_area_length &&
      Mem->BallAbsoluteVelocity().x > FLOAT_EPS)
    return FALSE; // ball is goign wrong way!
  Line ballTrajLine =
    LineFromRay(Mem->BallAbsolutePosition(), Mem->BallAbsoluteVelocity());
  if (ballTrajLine.SameSlope(BaseLine))
    return FALSE;
  Vector pt = BaseLine.intersection(ballTrajLine);
  if (BaseLine.InBetween(pt, Mem->OwnGoalieArea.TopLeftCorner(),
			 Mem->OwnGoalieArea.BottomLeftCorner())) {
    /* check if the ball has the velocity to get there */
    if (pt.dist(Mem->BallAbsolutePosition()) <
	SumInfGeomSeries(Mem->BallSpeed(), Mem->SP_ball_decay) + Mem->SP_goal_area_length)
      return TRUE;
  }

  return FALSE;
}

/*****************************************************************************************/

/* looks at position and velocity of the ball to decide if we should catch it */
/* can be called with velocity not valid */
Bool ShouldICatch()
{
  if (!Mem->BallPositionValid())
    my_error("ShouldICatch: ball position not valid");
  return (Mem->BallCatchable() &&
	  //don't kick then catch for free kick
	  (Mem->CurrentTime - Mem->CP_goalie_catch_wait_time > Mem->PlayModeTime || 
	   Mem->LastPlayMode != PM_My_Goalie_Free_Kick) &&
	  //don't catch during catch ban cycle
	  Mem->CurrentTime - Mem->SP_catch_ban_cycle >= Mem->goalie_last_catch_time &&
	  Mem->PlayMode == PM_Play_On)
	  //	  Mem->BallAbsoluteVelocity().x < 0)
    //	  (!Mem->BallVelocityValid() || IsShot() ||
    //	   !Mem->BallWillBeKickable() ||
    //	   Mem->BallSpeed() < Mem->CP_ball_moving_threshold))
	  ? TRUE : FALSE;
}

/*****************************************************************************************/

/* if the ball is kickable and we're in the catch ban time, then we shoudl try to kick to
   clear the ball */
Bool ShouldIKick()
{
  //SNORK: not right yet!
  if (!Mem->BallPositionValid())
    my_error("ShouldICatch: ball position not valid");
  return (Mem->BallKickable() &&
	  Mem->PlayMode == PM_Play_On &&
	  !ShouldICatch())
    ? TRUE : FALSE;  
}

/*****************************************************************************************/

Bool ShouldIFaceBall()
{
  //SMURF: are there more cases I want to scan the field on
  if (Mem->BallPositionValid() && Mem->BallX() < 0)
    return TRUE;
  return FALSE;
}

/*****************************************************************************************/

#define CP_goalie_cycle_int_buffer 10
#define CP_goalie_max_come_out_dist (Mem->SP_penalty_area_length + 4)
Bool ShouldIGoToBall()
{
  if (!Mem->BallPositionValid())
    my_error("ShouldIGoToBall: ball position not valid");
  if (Mem->PlayMode != PM_Play_On)
    return FALSE;
  //next two lines extedn end of cone SP_kickable_area past the ball absolute position
  Vector meToBall = Mem->BallAbsolutePosition() - Mem->MyPos();
  Vector coneEnd =  Mem->BallAbsolutePosition() +
    meToBall * (2 * Mem->SP_kickable_area / meToBall.mod());
  if (Mem->OwnPenaltyArea.IsWithin(Mem->BallAbsolutePosition()) &&
      Mem->NumPlayersInCone(Mem->CP_goalie_go_to_ball_cone_ratio, coneEnd) == 0 &&
      Mem->MyInterceptionAble() &&
      Mem->OwnPenaltyArea.IsWithin(Mem->MyInterceptionPoint()))
    /*	  (!Mem->BallVelocityValid() ||
	  (Mem->BallAbsoluteVelocity().x <= 0 &&
	  Mem->BallSpeed() >= Mem->CP_ball_moving_threshold)))  */
    return  TRUE;

  DebugGoal2(cout << "BallPos: " << Mem->BallAbsolutePosition() << endl);
  DebugGoal2(cout << "BallVel: " << Mem->BallAbsoluteVelocity()
	     << "\tValid: " << Mem->BallVelocityValid() << endl);
  DebugGoal2(if (Mem->MyInterceptionAble())
	     cout << "IntPoint: " << Mem->MyInterceptionPoint()
	     << "\tWithin: "
	     << Mem->OwnPenaltyArea.IsWithin(Mem->MyInterceptionPoint())
	     << endl);
	     
  Vector desired_pos = GoalieDesiredPosition();
  if (Mem->MyInterceptionAble() &&
      Mem->OwnPenaltyArea.IsWithin(Mem->MyInterceptionPoint()) &&
      Mem->NumPlayersInCone(Mem->CP_goalie_go_to_ball_cone_ratio,
			    Mem->BallAbsolutePosition()) == 0 &&
      Mem->MyPos().dist(desired_pos) >
      Mem->MyPos().dist(Mem->MyInterceptionPoint()))
    return TRUE;
  
  if (Mem->FastestTeammateToBall() == Mem->MyNumber &&
      Mem->MyInterceptionAble() &&
      Mem->OwnPenaltyArea.IsWithin(Mem->MyInterceptionPoint()))
    return TRUE;

  Unum opp_fastest = Mem->FastestOpponentToBall();
  if (Mem->FastestTeammateToBall() == Mem->MyNumber &&
      Mem->MyInterceptionAble() &&
      Mem->MarkerPosition(Mem->RM_Their_Goal).dist(Mem->MyInterceptionPoint())
      < CP_goalie_max_come_out_dist &&
      (opp_fastest == Unum_Unknown ||
       Mem->MyInterceptionNumberCycles() -
       Mem->OpponentInterceptionNumberCycles(opp_fastest) > CP_goalie_cycle_int_buffer))
    return TRUE;
  
  return FALSE;
}

/*****************************************************************************************/

Bool ShouldIComeOutToOpponent()
{
  float buf = MinMax(0,
		     Mem->CP_goalie_breakaway_kickable_buffer *
		     ((Mem->BallDistance() - Mem->CP_goalie_no_buffer_dist) /
		      (Mem->CP_goalie_opponent_dist_to_block-Mem->CP_goalie_no_buffer_dist)),
		     Mem->CP_goalie_breakaway_kickable_buffer);
  Unum opp = Mem->OpponentWithBall(-buf);
  if (opp == Unum_Unknown) {
    Mem->LogAction2(140, "comeout: no opp with ball");
    return FALSE;
  }
  if (!Mem->TheirBreakaway()) {
    Mem->LogAction2(140, "comeout: not a breakaway");
    return FALSE;
  }
  return (Mem->MarkerPosition(Mem->RM_My_Goal).dist(Mem->OpponentAbsolutePosition(opp)) <
	  Mem->CP_goalie_opponent_dist_to_block)
    ? TRUE : FALSE;
}

/*****************************************************************************************/

/* if the ball is in the nearest quarter of the field,
   and ther are no players blocking the way, then we are in danger */
Bool InDefensiveDanger()
{
  if (!Mem->BallPositionValid())
    my_error("InDefensiveDanger: must know where ball is");
  DebugGoal(cout << "InDefensiveDanger: balldist:" <<
	    Mem->MarkerPosition(Mem->RM_My_Goal).
	    dist(Mem->BallAbsolutePosition()) << endl);
  return (Mem->PlayMode == PM_Play_On &&
	  Mem->MarkerPosition(Mem->RM_My_Goal).dist(Mem->BallAbsolutePosition())
	  < Mem->CP_goalie_max_shot_distance &&
	  (Mem->NumTeammatesInCone((Mem->SP_goal_width / 2)/Mem->BallDistance(),
				   Mem->MyPos(),
				   Mem->BallAbsolutePosition())==0 ||
	   Mem->OpponentWithBall() != Unum_Unknown))
    ? TRUE : FALSE;
}


/*****************************************************************************************/

void goalie_catch_ball()
{
  DebugGoal(cout << "goalie_catch_ball" << endl);
  if ( !Mem->BallCatchable() ) my_error("Ball must be catchable to catch");
  if ( !Mem->CP_goalie )       my_error("Must be a goalie to catch");
  if ( !Mem->InOwnPenaltyArea() ) my_error("Must be in box to catch");
  if ( !(Mem->CurrentTime - Mem->SP_catch_ban_cycle >= Mem->goalie_last_catch_time) )
       my_error("goalie doing a catch during the catch ban cycle");

  Mem->goalie_last_catch_time = Mem->CurrentTime;
  Mem->LogAction3(40, "Catching at angle: %f", Mem->BallAngleFromBody());
  goalie_catch(Mem->BallAngleFromBody());
}


/*****************************************************************************************/

void goalie_clear_ball()
{
  if (!Mem->BallKickable())
    my_error("can't clear if ball not kickable");
  if ( Mem->KickInProgress() ){
    /* Already kicking */
    smart_kick_hard_abs(Mem->kick_in_progress_abs_angle,Mem->kick_in_progress_mode,
			Mem->kick_in_progress_target_vel,Mem->kick_in_progress_rotation);
    return;
  } else {
    AngleDeg targ = Mem->ClearTarget();
    //SMURF: this may not be the best way to choose rotation
    TurnDir rot = RotClosest(0); //to make sure we don't rotate into goal
    Mem->LogAction3(40, "Clearing the ball to angle: %f", targ);
    kick_ball(targ, KM_Moderate, rot);
  }  
}

/*****************************************************************************************/

void goalie_face_ball()
{
  DebugGoal(cout << "goalie_face_ball" << endl);
  if (fabs(Mem->BallAngleFromBody()) > Mem->CP_goalie_scan_angle_err) {
    Mem->LogAction2(40, "turning to face ball");
    face_neck_and_body_to_ball();
    //turn(Mem->BallAngleFromBody());
  }
  
}

/*****************************************************************************************/

void goalie_watch_ball()
{
  DebugGoal(cout << "goalie_watch_ball" << endl);
  Mem->LogAction2(40, "watching ball");
  //if (Mem->ViewWidth != VW_Normal) change_view(VW_Normal);
  if (fabs(Mem->BallAngleFromBody()) > Mem->CP_goalie_scan_angle_err)
    turn(Mem->BallAngleFromBody());
  goalie_shrink_view_cone();
}

/*****************************************************************************************/

void goalie_go_to_position()
{
  DebugGoal(cout << "goalie_go_to_position" << endl);
  if (Mem->BallDistance() > Mem->CP_goalie_max_shot_distance)
    change_view(VW_Wide);
  //use the regular at point buffer cause it's not THAT important
  if (goalie_go_to_point(GoalieDesiredPosition(), Mem->CP_at_point_buffer, SVS_FavorSight)
      == AQ_ActionNotQueued) {
    Mem->LogAction2(20, "go_to_position: already there");
    //SMURF    if (InDefensiveDanger() || !Mem->BallVelocityValid()) {
    if (InDefensiveDanger()) {
      DebugGoal(cout << " in defensive danger, facing ball\n" << endl);
      Mem->LogAction2(30, "go_to_position: watching ball");
      goalie_watch_ball();
    } else if (ShouldIFaceBall()) {
      Mem->LogAction2(30, "go_to_position: facing ball field");
      goalie_face_ball();
    } else {
      Mem->LogAction2(30, "go_to_position: scanning field");
      goalie_scan_field();
    }
  }
}

/*****************************************************************************************/

/* takes into account queued action to reduce the view cone as much as possible */
void goalie_shrink_view_cone() 
{
  Vwidth vw;
  Vector pred_ball =
    (Mem->BallVelocityValid() ? Mem->BallPredictedPosition() : Mem->BallAbsolutePosition());
  Vector pred_me = Mem->MyPredictedPositionWithQueuedActions();
  float ball_ang = (pred_ball - pred_me).dir();
/*    ((Mem->BallVelocityValid()?Mem->BallPredictedPosition():Mem->BallAbsolutePosition()) -
     Mem->MyPredictedPositionWithQueuedActions()).dir(); */
  ball_ang -= Mem->MyPredictedBodyAngleWithQueuedActions();
  NormalizeAngleDeg(&ball_ang);
  ball_ang = fabs(ball_ang);
  
  if ( ball_ang < Mem->SP_max_neck_angle + (Mem->SP_visible_angle/2)/2 - Mem->CP_goalie_vis_angle_err)
     vw = VW_Narrow;
  else if ( ball_ang < Mem->SP_max_neck_angle + (Mem->SP_visible_angle/2) - Mem->CP_goalie_vis_angle_err)
    vw = VW_Normal;
  else
    //if ( ball_ang < Mem->SP_max_neck_angle + (Mem->SP_visible_angle/2)*2 - Mem->CP_goalie_vis_angle_err)
    vw = VW_Wide;

  if (vw != VW_Narrow && pred_me.dist(pred_ball) < Mem->SP_feel_distance) {
    /* check to see if the ball is about to go out of bounds,
       in which case we should swithc to feelable */
    float dist = Mem->FieldRectangle.DistanceToEdge(Mem->BallAbsolutePosition());
    float cyc = SolveForLengthGeomSeries(Mem->BallSpeed(), Mem->SP_ball_decay, dist);
    if (cyc > 0 && cyc < Mem->CP_goalie_narrow_sideline_cyc)
      vw = VW_Narrow;
  }
  change_view(vw);
}


/*****************************************************************************************/
/*****************************************************************************************/
/*****************************************************************************************/

Bool DoesSpeedFavorForwardBackward(Vector pt, Bool* pForward)
{
  float abs_ang = (pt - Mem->MyPos()).dir();
  int forward_turns = Mem->NumTurnsToAngle(abs_ang);
  int backward_turns = Mem->NumTurnsToAngle(abs_ang + 180);
  Mem->LogAction4(110, "DoesSpeedFavor: forward: %d  backward: %d",
		  forward_turns, backward_turns);
  if (forward_turns < backward_turns) {
    *pForward = TRUE;
    return TRUE;
  } else if (backward_turns < forward_turns) {
    *pForward = FALSE;
    return TRUE;
  } else {
    return FALSE;
  }
}

/*****************************************************************************************/
Vwidth MinViewAngForBodyAngle(float body_ang)
{
  float ball_ang =
    ((Mem->BallVelocityValid()?Mem->BallPredictedPosition():Mem->BallAbsolutePosition()) -
     Mem->MyPredictedPosition()).dir();
  ball_ang -= body_ang;
  NormalizeAngleDeg(&ball_ang);
  ball_ang = fabs(ball_ang);

  if ( ball_ang < Mem->SP_max_neck_angle + (Mem->SP_visible_angle/2)/2 - Mem->CP_goalie_vis_angle_err)
    return VW_Narrow;
  else if ( ball_ang < Mem->SP_max_neck_angle + (Mem->SP_visible_angle/2) - Mem->CP_goalie_vis_angle_err)
    return VW_Normal;
  else
    //if ( ball_ang < Mem->SP_max_neck_angle + (Mem->SP_visible_angle/2)*2 - Mem->CP_goalie_vis_angle_err)
    return VW_Wide;
}

/*****************************************************************************************/

Bool DoesSightFavorForwardBackward(Vector pt, Bool* pForward)
{
  float abs_ang = (pt - Mem->MyPos()).dir();
  Vwidth forward_wid = MinViewAngForBodyAngle(abs_ang);
  Vwidth backward_wid = MinViewAngForBodyAngle(abs_ang + 180);

  Mem->LogAction4(110, "DoesSightFavor: forward: %d  backward: %d",
		  forward_wid, backward_wid);

  if (forward_wid < backward_wid) {
    *pForward = TRUE;
    return TRUE;
  } else if (backward_wid < forward_wid) {
    *pForward = FALSE;
    return TRUE;
  } else {
    return FALSE;
  }
}

/*****************************************************************************************/

/* the worst thing to happen to a goalie is to lose sight of the ball, so this
   function runs forwards or backwards to keep the ball in sight always */
/* Now that we have a neck, it will run forwards or backwards such that it can keep the
   ball in view in the smallest view cone AND tries to minimize turns to get to the right
   position */
/* Note: there is no backward dodging- probably won't be a problem */
/* returns whether it queued an action */
ActionQueueRes goalie_go_to_point(Vector pt, float buffer, SightVSpeed favor)
{
  Mem->LogAction4(50, "goalie_go_to_point (%.1f, %.1f)", pt.x, pt.y);
  if (Mem->AtPos(pt, buffer))
    return AQ_ActionNotQueued;

  Bool run_forward;

  /* decide whether to go ther forwards or backwards */
  if (favor == SVS_FavorSight) {
    if (DoesSightFavorForwardBackward(pt, &run_forward)) {
      Mem->LogAction3(60, "goalie_go_to_point: favoring sight, sight says forward=%d",
		      run_forward);
    } else if (DoesSpeedFavorForwardBackward(pt, &run_forward)) {
      Mem->LogAction3(60, "goalie_go_to_point: favoring sight, speed says forward=%d",
		      run_forward);
    } else {
      Mem->LogAction2(60, "goalie_go_to_point: favoring sight, no preference");
      run_forward = TRUE; // uses less stamina
    }
    
  } else if (favor == SVS_FavorSpeed) {
    /* favor speed over sight */
    if (DoesSpeedFavorForwardBackward(pt, &run_forward)) {
      Mem->LogAction3(60, "goalie_go_to_point: favoring speed, speed says forward=%d",
		      run_forward);
    } else if (DoesSightFavorForwardBackward(pt, &run_forward)) {
      Mem->LogAction3(60, "goalie_go_to_point: favoring speed, sight says forward=%d",
		      run_forward);
    } else {
      Mem->LogAction2(60, "goalie_go_to_point: favoring speed, no preference");
      run_forward = TRUE; // uses less stamina
    }
  } else {
    my_error("goalie_go_to_point: invalid favoring value: %d", favor);
  }
  
  if (run_forward) {
    float dash_power = Mem->SP_max_power;
    if (Mem->BallDistance() > Mem->CP_goalie_max_shot_distance)
      dash_power = Mem->SP_max_power / 2;
    if (go_to_point(pt, buffer, dash_power,DT_unless_with_ball) == AQ_ActionNotQueued) {
      my_error("Why didn't go_to_point do anything?");
      return AQ_ActionNotQueued;
    }
  } else {
    /* we don;t dodge backwards! */
    float targ_ang = Mem->AngleToFromBody(pt) + 180;
    NormalizeAngleDeg(&targ_ang);
    if (fabs(targ_ang) > Mem->CP_max_go_to_point_angle_err)
      turn(targ_ang);
    else
      dash( (Mem->BallDistance() > Mem->CP_goalie_max_shot_distance) ?
	    Mem->SP_min_power / 2 : Mem->SP_min_power);
  }

  return AQ_ActionQueued;
}

#ifdef OLD_CODE
ActionQueueRes goalie_go_to_point(Vector pt, float buffer,
				  Bool ForceForward, Bool ShrinkViewCone)
{
  DebugGoal(cout << "goalie_go_to_point" << endl);
  if (Mem->AtPos(pt, buffer))
    return AQ_ActionNotQueued;

  Bool run_forward;
  float targ_ang = Mem->AngleToFromBody(pt);

  if (ForceForward)
    run_forward = TRUE;
  else {
    Unum close_team = Mem->ClosestTeammateTo(Mem->MyPos(), FALSE);
    Unum close_opp  = Mem->ClosestOpponentTo(Mem->MyPos());
    if ((close_team != Unum_Unknown &&
	 Mem->TeammateDistance(close_team) < Mem->SP_feel_distance &&
	 Mem->IsTeammateBehind(close_team,
			       GetNormalizeAngleDeg(targ_ang+Mem->MyBodyAng()+180))) ||
	(close_opp != Unum_Unknown &&
	 Mem->OpponentDistance(close_opp) < Mem->SP_feel_distance &&
	 Mem->IsOpponentBehind(close_opp,
			       GetNormalizeAngleDeg(targ_ang+Mem->MyBodyAng()+180)))) {
      //SMURF: should we try backward dodging?
      Mem->LogAction2(50, "goalie_go_to_point: forwards because of backwards collision");
      run_forward = TRUE; // collision behind us
      change_view(VW_Wide);
    } else {
      float forward_ball_ang =
	fabs(GetNormalizeAngleDeg(Mem->BallAngleFromBody() - targ_ang));
      if (fabs(forward_ball_ang - 90) < Mem->CP_goalie_vis_angle_err &&
	  Mem->BallVelocityValid() &&
	  Mem->BallSpeed() > Mem->CP_ball_moving_threshold) {
	Line trajLine = LineFromTwoPoints(Mem->MyPos(), pt);
	Vector projBall = trajLine.ProjectPoint(Mem->BallAbsolutePosition());
	Vector projNewBall = trajLine.ProjectPoint(Mem->BallPredictedPosition());
	if (trajLine.InBetween(projNewBall, projBall, pt)) {
	  Mem->LogAction2(50, "goalie_go_to_point: forwards because ball will be in front");
	  run_forward = TRUE;
	} else {
	  Mem->LogAction2(50, "goalie_go_to_point: backwards to see ball");
	  run_forward = FALSE;
	}	
      } else if (forward_ball_ang < 90) {
	Mem->LogAction2(50, "goalie_go_to_point: forwards because ball is in front");
	run_forward = TRUE;
      } else {
	Mem->LogAction2(50, "goalie_go_to_point: backwards because ball is behind");
	run_forward = FALSE;
      }

      float ang_to_view = forward_ball_ang;
      if (run_forward == FALSE)
	ang_to_view += 180;
      NormalizeAngleDeg(&ang_to_view);
      ang_to_view = fabs(ang_to_view);
      if (ang_to_view >
	  Mem->SP_max_neck_angle + Mem->MyViewAngle() - Mem->CP_goalie_vis_angle_err) {
	Mem->LogAction2(50, "goalie_go_to_point: changing to wide to see ball");
	DebugGoal(cout << " Changin to wide view" << endl);
	change_view(VW_Wide);
      }
    }    
  }

  if (ShrinkViewCone) {
    float ball_ang =
      ((Mem->BallVelocityValid()?Mem->BallPredictedPosition():Mem->BallAbsolutePosition()) -
      Mem->MyPredictedPosition()).dir();
    ball_ang -= (pt - Mem->MyPredictedPosition()).dir();
    NormalizeAngleDeg(&ball_ang);
    ball_ang = fabs(ball_ang);

    if ( ball_ang < Mem->SP_max_neck_angle + (Mem->SP_visible_angle/2)/2 - Mem->CP_goalie_vis_angle_err)
      change_view(VW_Narrow);
    else if ( ball_ang < Mem->SP_max_neck_angle + (Mem->SP_visible_angle/2) - Mem->CP_goalie_vis_angle_err)
      change_view(VW_Normal);
    else if ( ball_ang < Mem->SP_max_neck_angle + (Mem->SP_visible_angle/2)*2 - Mem->CP_goalie_vis_angle_err)
      change_view(VW_Wide);
  }
  
  
  if (run_forward) {
    float dash_power = Mem->SP_max_power;
    if (Mem->BallDistance() > Mem->CP_goalie_max_shot_distance)
      dash_power = Mem->SP_max_power / 2;
    if (go_to_point(pt, buffer, dash_power,DT_unless_with_ball) == AQ_ActionNotQueued) {
      my_error("Why didn't go_to_point do anything?");
      return AQ_ActionNotQueued;
    }
  } else {
    /* we don;t dodge backwards! */
    targ_ang = GetNormalizeAngleDeg(targ_ang + 180);
    if (fabs(targ_ang) > Mem->CP_max_go_to_point_angle_err)
      turn(targ_ang);
    else
      dash( (Mem->BallDistance() > Mem->CP_goalie_max_shot_distance) ?
	    Mem->SP_min_power / 2 : Mem->SP_min_power);
  }
  
  return AQ_ActionQueued;
}
#endif
/*****************************************************************************************/

/* should be called when we know a shot is coming at us, or more generally
   if we want to get to the ball */
void goalie_intercept()
{
  DebugGoal(cout << "goalie_intercept_shot" << endl);

  Unum opp = Mem->OpponentWithBall();
  //SMURF: maybe we shoudl check how far off we are
  if (opp != Unum_Unknown) {
    if (Mem->MarkerPosition(Mem->RM_My_Goal).dist(Mem->OpponentAbsolutePosition(opp)) > 
	Mem->CP_goalie_opponent_dist_to_block) {
      /*Mem->LogAction2(40, "goalie_intercept: watching while opponent has ball");
	goalie_watch_ball(); */
      Mem->LogAction2(40, "goalie_intercept: opponent has ball, so just positioning self");
      goalie_go_to_position();
      return;
    } else {
      if (!Mem->CP_goalie_comes_out) {
	Mem->LogAction2(40, "goalie_intercept: opponent has ball, and he's close, but positioning self");
	goalie_go_to_position();
	return;
      } /*else {
	Mem->LogAction2(30, "Blocking opponent via intercept");
	goalie_block_opponent();
      }   */   
    }
  }

  if (!Mem->BallPathInterceptValid()) {
    my_error("goalie_intercept_shot: BPI not valid?");
  }
  if (Mem->BallSpeed() < Mem->CP_ball_moving_threshold) {
    DebugGoal(cout << " Ball is barely moving, going to it: " << Mem->BallAbsolutePosition() << endl);
    Mem->LogAction2(40, "goalie_intercept: goign to barely moving ball");  
    if (move_to_point_in_between(Mem->BallAbsolutePosition(), GoalieDesiredPosition(), 0)
	== AQ_ActionNotQueued)
      my_error("goalie_intercept: 1. how did we get so close to ball");
  } else if (Mem->BallPathInterceptAmIThere(Mem->CP_at_point_buffer)) {
    /* we're on the ball path, move along to intercept ball */
    if (Mem->MyInterceptionAble()) {	
      Mem->LogAction2(40, "goalie_intercept: on path, now normal intercept mode");  
      if (goalie_go_to_point(Mem->MyInterceptionPoint(), Mem->CP_goalie_at_point_buffer,
			     SVS_FavorSight)
	  == AQ_ActionNotQueued)
	my_error("goalie_intercept: 5. how did we get so close to ball");
      goalie_shrink_view_cone();
    } else {
      Mem->LogAction2(40, "goalie_intercept: on path, going to ball position");  
      if (goalie_go_to_point(Mem->BallAbsolutePosition(), Mem->CP_goalie_at_point_buffer,
			     SVS_FavorSight)
	  == AQ_ActionNotQueued)
	my_error("goalie_intercept: 2. how did we get so close to ball");
      goalie_shrink_view_cone();
    }
  } else {
    if (Mem->BallPathInterceptCanIGetThere()) {
      Mem->LogAction2(40, "goalie_intercept: going to path");  
      DebugGoal(cout << " Going to path: " << Mem->BallPathInterceptPoint() << endl);
      if (goalie_go_to_point(Mem->BallPathInterceptPoint(), Mem->CP_goalie_at_point_buffer,
			     SVS_FavorSpeed)
	  == AQ_ActionNotQueued)
	my_error("goalie_intercept: 3. how did we get so close to ball");
      goalie_shrink_view_cone();
    } else {
      /* can't make it to ball path, lets' try normal interception */
      if (Mem->MyInterceptionAble()) {	
	Mem->LogAction2(40, "goalie_intercept: normal intercept mode");  
	DebugGoal(cout << "Can't make it to path, but can for normal interception" << endl);
	if (goalie_go_to_point(Mem->MyInterceptionPoint(), Mem->CP_goalie_at_point_buffer,
			       SVS_FavorSpeed)
	    == AQ_ActionNotQueued)
	  my_error("goalie_intercept: 4. how did we get so close to ball");
	goalie_shrink_view_cone();
      } else {
	/* shot coming and can't intercept it */
	//Mem->LogAction2(40, "goalie_intercept: can't get to ball, goign to sideline intercept");  
	/*Line TrajLine =
	  LineFromRay(Mem->BallAbsolutePosition(), Mem->BallAbsoluteVelocity()); */
/*	  Vector pt =
	  AdjustPtToRectOnLine(TrajLine.intersection(Mem->FieldRectangle.LeftEdge()),
			       Mem->FieldRectangle.shrink(Mem->CP_goalie_baseline_buffer),
			       TrajLine);
			       */
	Vector pt;
	if (!Mem->FieldRectangle.LeftEdge().RayIntersection(Ray(Mem->BallAbsolutePosition(), Mem->BallAbsoluteVelocity()), &pt))
	  my_error("sideline ray intersection didn't work!");
	  
	Mem->LogAction4(40, "goalie_intercept: can't get to ball, goign to sideline intercept %f %f", pt.x, pt.y);  
	if (goalie_go_to_point(pt, Mem->CP_goalie_at_point_buffer,
			       SVS_FavorSpeed) == AQ_ActionNotQueued) {
	  Mem->LogAction2(40, "goalie_intercept: already at sideline intercept point? watching");
	  goalie_watch_ball();
	}
      }
    }

  }
}

/*****************************************************************************************/

void goalie_block_opponent()
{
  DebugGoal(cout << "goalie blocking opponent" << endl);
  Line ball_goal_line = 
    LineFromTwoPoints(Mem->MarkerPosition(Mem->RM_My_Goal),
		      Mem->BallAbsolutePosition());
  Line facing_line = LineFromRay(Mem->MyPos(), Vector(1, Mem->MyBodyAng()));
  Vector targ = ball_goal_line.intersection(facing_line);
  if (targ.dist(Mem->BallAbsolutePosition()) > Mem->CP_at_point_buffer)
    targ = Mem->BallAbsolutePosition();
  Unum opp_with_ball = Mem->OpponentWithBall(-Mem->CP_goalie_breakaway_kickable_buffer);
  Line opp_goal_line = LineFromTwoPoints(Mem->MarkerPosition(Mem->RM_My_Goal),
					 Mem->OpponentAbsolutePosition(opp_with_ball));
  Vector block_pos = Mem->OpponentAbsolutePosition(opp_with_ball);
  block_pos.x -= 1.5;
  targ = opp_goal_line.perpendicular(block_pos).ProjectPoint(targ);
  Mem->LogAction4(30, "Goalie blocking opponent %f %f", targ.x, targ.y);
  go_to_point(targ, 0, Mem->SP_max_power, DT_none);
#ifdef OLD_CODE
  Unum opp = Mem->OpponentWithBall(-Mem->CP_goalie_breakaway_kickable_buffer);
  if (opp == Unum_Unknown)
    my_error("goalie_block_opponent: no opponent to block");
  //  targ = Mem->FieldRectangle.shrink(Mem->CP_goalie_baseline_buffer).AdjustToWithin(targ);
  move_to_point_in_between(Mem->OpponentAbsolutePosition(opp), 
			   Mem->MarkerPosition(Mem->RM_Their_Goal),
			   CP_goalie_block_distance);
#endif
}

/*****************************************************************************************/

/* puts us back in wide view mode */
void goalie_scan_field()
{
  if (Mem->BallPositionValid() && Mem->BallX() > 0) {
    turn(-Mem->MyBodyAng()); //face center
    return;
  }

  Mem->LogAction2(20, "Goalie scanning field");
  /* Put the neck at 0 */
  turn_neck(-Mem->MyNeckRelAng());
  
  DebugGoal(cout << "goalie_scan_field" << endl);
  change_view(VW_Wide);
  if (!Mem->TimeToTurnForScan()) {
    Mem->LogAction2(40, "Goalie scanning field: just waiting for a sight");
    return; /* waiting for sight before turning again */
  }
  
  float center_ang = 0;
  float left_ang =
    (Mem->OwnGoalieArea.TopLeftCorner() - Mem->MyPos()).rotate(90).dir();
  float right_ang =
    (Mem->OwnGoalieArea.BottomLeftCorner() - Mem->MyPos()).rotate(-90).dir();

  DebugGoal(printf(" center: %f\tleft: %f\tright: %f\n",
		   center_ang, left_ang, right_ang));
  DebugGoal(printf(" MyBodyAng: %f\n", Mem->MyBodyAng()));
  
  if (fabs(Mem->MyBodyAng() - center_ang) < Mem->CP_goalie_scan_angle_err) {
    Mem->LogAction2(40, "Goalie scanning field: turning to left");
    turn(left_ang - Mem->MyBodyAng());
  } else if (fabs(Mem->MyBodyAng() - left_ang) < Mem->CP_goalie_scan_angle_err) {
    Mem->LogAction2(40, "Goalie scanning field: turning to right");
    turn(right_ang - Mem->MyBodyAng());
  } else if (fabs(Mem->MyBodyAng() - right_ang) < Mem->CP_goalie_scan_angle_err) {
    Mem->LogAction2(40, "Goalie scanning field: turning to center");
    turn(center_ang - Mem->MyBodyAng());
  } else { // turn to center
    Mem->LogAction2(40, "Goalie scanning field: turning to center");
    turn(center_ang - Mem->MyBodyAng());
  }
}

/*****************************************************************************************/
/* SMURF: this function is still not correct! */
void goalie_after_catch() 
{
  if (!Mem->goalie_moved_after_catch) {
    Mem->LogAction2(20, "Goalie after catch, moving");
    move(Mem->OwnGoalieArea.RightX(), 0); 
    Mem->goalie_moved_after_catch = TRUE;
  } else if ( Mem->BallKickable()) {
    Mem->LogAction2(20, "Goalie after catch, clearing ball");
    goalie_clear_ball();
  } else {
    /* SMURF: this is for a temporary bug in the server */
    Mem->LogAction2(20, "Goalie after catch, doing nothing");
    /* do nothing! */
  }
}

/*****************************************************************************************/
#include "dribble.h"
void test_goalie()
{
  if (Mem->MyNumber != 1) {
    static FirstTime = TRUE;
    if (FirstTime) {      
      move(-20, -20);
      FirstTime = FALSE;
    }
    return;
  }
  
  if (!strcmp(Mem->MyTeamName, "CMUnited") && Mem->CP_goalie) {
    goalie_behave();
  } else {
    //static float kick_ang = 0;
    if (!Mem->MyConf() || !Mem->BallPositionValid())
      scan_field_with_body();
    else if (Mem->BallPositionValid()) {
      if ( 0 && Mem->BallKickable() && Mem->KickInProgress() ){
	/*	 Already kicking */
	smart_kick_hard_abs(Mem->kick_in_progress_abs_angle,Mem->kick_in_progress_mode,
			    Mem->kick_in_progress_target_vel,Mem->kick_in_progress_rotation);
      } else if (Mem->BallKickable()) {
	Unum oppGoalie = Mem->ClosestOpponentTo(Mem->MarkerPosition(Mem->RM_Their_Goal));
	KickMode shot_mode = Mem->ShotMode();
	float dist_to_goal = Mem->DistanceTo(Mem->MarkerPosition(Mem->RM_Their_Goal));
	if (0 && (oppGoalie == Unum_Unknown ||
		  Mem->EstimatedCyclesToSteal(oppGoalie) <= Mem->CP_cycles_to_kick + 1 ||
		  shot_mode == KM_HardestKick && dist_to_goal < 13 ||
		  shot_mode == KM_Moderate    && dist_to_goal < 9))
	  kick_ball(Mem->ShotTarget(), shot_mode);
	else 
	  SmartDribbleTo(Vector(Mem->SP_pitch_length/2, 3), 75);
      } else
	if (Mem->BallPositionValid())
	  go_to_point(Mem->MyInterceptionPoint());
	else
	  scan_field_with_body();
      
      // if (SmartDribbleTo(Vector(Mem->SP_pitch_length/2, 3), 75) == DR_LostBall)
    }    
#ifdef NEVER
    else if (!Mem->BallKickable()) {      
      //go_to_point(Vector(Mem->SP_pitch_length/2 - 20, 15), 1, 50);
      Vector correction = Vector(0,Mem->SP_goal_width/2-1);
      kick_ang = Mem->AngleTo(Mem->MarkerPosition(Goal_L) +
			      /*signf(range_random(-1, 1))*/correction);
    } else {
      smart_kick_hard(kick_ang, KM_Moderate);
    }
#endif	
    
  }
  
  
}
