/* -*- Mode: C++ -*- */

/* Classes dealing with statistical stuff from data points */

/* Patrick Riley */

#ifndef _DATA_H_
#define _DATA_H_

#include <stdio.h>
#include <fstream.h>
#include "types.h"

class SingleDataSummary {

public:
  SingleDataSummary();

  void Reset();
  
  void AddPoint(float x);
  float GetMean();
  float GetVariance();
  float GetStdDev();
  int GetNumPoints();

  void WriteInfoToFile(ostream& output_file, int WithNumPoints = FALSE);
  
 private:
  int n;
  float sum;
  float sum_squares;
};

#endif
